/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.dashboard.DashboardPageInfo;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.DashboardControl;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestXsrfAdminSharedDashboards
extends BaseJiraFuncTest {
    @Inject
    protected Administration administration;
    @Inject
    private Form form;

    private Dashboard addSharedPublicDashboard() {
        return this.navigation.dashboard().addPage(Data.SHARED_PUBLIC_DASHBOARD, null);
    }

    @Test
    public void testSharedDasboardOperations() throws Exception {
        new XsrfTestSuite(new XsrfCheck("Delete Shared Dashboard", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfAdminSharedDashboards.this.backdoor.applicationProperties().enableGlobalSharing();
                TestXsrfAdminSharedDashboards.this.addSharedPublicDashboard();
                TestXsrfAdminSharedDashboards.this.backdoor.permissions().addGlobalPermission(22, "jira-users");
                Long dashboardId = ((DashboardControl.Dashboard)Iterables.getFirst((Iterable)TestXsrfAdminSharedDashboards.this.backdoor.dashboard().getOwnedDashboard("admin"), null)).getId();
                TestXsrfAdminSharedDashboards.this.administration.sharedDashboards().goTo();
                TestXsrfAdminSharedDashboards.this.tester.clickLink("delete_" + dashboardId);
                TestXsrfAdminSharedDashboards.this.tester.setWorkingForm("delete-portal-page");
            }
        }, new XsrfCheck.FormSubmissionWithId("delete-portal-page-submit"))).run(this.tester, this.navigation, this.form);
    }

    private static class Data {
        private static final DashboardPageInfo SHARED_PUBLIC_DASHBOARD = new DashboardPageInfo(10014L, "Public - Owner: Admin", null, true, TestSharingPermissionUtils.createPublicPermissions(), "admin", 1, DashboardPageInfo.Operation.ALL);

        private Data() {
        }
    }
}

