/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.security.xsrf;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfCheck;
import com.atlassian.jira.functest.framework.security.xsrf.XsrfTestSuite;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.junit.Test;
import org.w3c.dom.Element;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SECURITY})
@LoginAs(user="admin")
public class TestXsrfImportAndExport
extends BaseJiraFuncTest {
    @Inject
    protected Administration administration;
    @Inject
    private Form form;

    @Test
    @RestoreBlankInstance
    public void testProjectImportExport() throws Exception {
        final String tempFilePath = this.getTempFilePath(".xml");
        new XsrfTestSuite(new XsrfCheck("ExportXmlData", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfImportAndExport.this.navigation.gotoAdminSection(Navigation.AdminSection.BACKUP_DATA);
                TestXsrfImportAndExport.this.tester.setFormElement("filename", tempFilePath);
            }
        }, new BackupFormSubmission()), new XsrfCheck("ImportXmlData", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfImportAndExport.this.navigation.gotoAdminSection(Navigation.AdminSection.RESTORE_DATA);
                TestXsrfImportAndExport.this.tester.setFormElement("filename", tempFilePath);
            }
        }, new XsrfCheck.FormSubmission("Restore"))).run(this.getTester(), this.navigation, this.form);
    }

    @Test
    public void testProjectImport() throws Exception {
        new XsrfTestSuite(new XsrfCheck("ProjectImport", new XsrfCheck.Setup(){

            @Override
            public void setup() {
                TestXsrfImportAndExport.this.administration.projectImport().doImportToSummary("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataEmptyMKYProject.xml", null);
            }
        }, new XsrfCheck.FormSubmission("Import"))).run(this.getTester(), this.navigation, this.form);
    }

    private String getTempFilePath(String suffix) {
        File tempFile;
        try {
            tempFile = File.createTempFile("TestXsrfImportAndExport_Export", suffix);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tempFile.getAbsolutePath();
    }

    private class BackupFormSubmission
    extends XsrfCheck.FormSubmission {
        public BackupFormSubmission() {
            super("Backup");
        }

        @Override
        public void submitRequest() {
            super.submitRequest();
            Element replaceSubmit = TestXsrfImportAndExport.this.tester.getDialog().getElement("Replace File");
            if (replaceSubmit != null) {
                TestXsrfImportAndExport.this.tester.submit("Replace File");
            }
        }
    }
}

