/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin.statuses;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.BROWSING})
@LoginAs(user="admin")
public class TestStatuses
extends BaseJiraFuncTest {
    private static final String ERROR_403_MESSAGE = "HTTPError403";
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;

    @Test
    public void testWorkflowLinksUrlEncoded() {
        this.administration.restoreData("TestStatuses.xml");
        this.tester.gotoPage("secure/admin/ViewWorkflowsForStatus.jspa?id=1");
        this.tester.assertTextNotPresent("workflowName=<xxx>Crazy workflow</xxx>");
        this.tester.assertTextPresent("workflowName=%3Cxxx%3ECrazy%20workflow%3C%2Fxxx%3E");
    }

    @Test
    public void testDeleteActiveStatusViaUrlFails() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.STATUSES);
        this.tester.assertLinkNotPresentWithText("Delete");
        this.tester.gotoPage("secure/admin/DeleteStatus!default.jspa?id=1");
        this.tester.assertTextPresent("Delete status: Open");
        this.tester.assertTextPresent("Confirm that you want to delete this status ...");
        this.tester.assertTextNotPresent("Given status is currently associated with a workflow(s) and cannot be deleted");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Delete status: Open");
        this.tester.assertTextPresent("Confirm that you want to delete this status ...");
        this.tester.assertTextPresent("Given status is currently associated with a workflow(s) and cannot be deleted");
    }

    @Test
    public void testDeletePassiveStatusViaSucceeds() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.STATUSES);
        this.tester.assertLinkNotPresentWithText("Delete");
        this.tester.gotoPage("secure/admin/AddStatus!default.jspa");
        this.tester.setFormElement("name", "Not used");
        this.tester.setFormElement("description", "why bother");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Not used");
        this.tester.assertTextPresent("why bother");
        this.tester.assertLinkPresentWithText("Delete");
        this.tester.assertLinkPresent("del_10000");
        this.tester.gotoPage("secure/admin/DeleteStatus!default.jspa?id=10000");
        this.tester.assertTextPresent("Delete status: Not used");
        this.tester.assertTextPresent("Confirm that you want to delete this status ...");
        this.tester.submit("Delete");
        this.tester.assertTextNotPresent("Not used");
        this.tester.assertTextNotPresent("why bother");
        this.tester.assertLinkNotPresentWithText("Delete");
        this.tester.assertLinkNotPresent("del_10000");
    }

    @Test
    public void testEditStatusAlreadyExists() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.STATUSES);
        this.tester.gotoPage("secure/admin/AddStatus!default.jspa");
        this.tester.setFormElement("name", "closed");
        this.tester.submit();
        this.assertDuplicateStatusError();
        this.tester.setFormElement("name", "CLOSED");
        this.tester.submit();
        this.assertDuplicateStatusError();
        this.tester.gotoPage("secure/admin/EditStatus!default.jspa?id=5");
        this.tester.setFormElement("name", "closed");
        this.tester.submit();
        this.assertDuplicateStatusError();
        this.tester.setFormElement("name", "CLOSED");
        this.tester.submit();
        this.assertDuplicateStatusError();
    }

    @Test
    public void testRenamePropagates() throws Exception {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.WORKFLOWS);
        this.tester.clickLink("steps_live_jira");
        this.navigation.gotoAdminSection(Navigation.AdminSection.STATUSES);
        this.tester.gotoPage("secure/admin/EditStatus!default.jspa?id=5");
        this.tester.assertFormElementEquals("name", "Resolved");
        this.tester.setFormElement("name", "what-do-you-mean-resolved");
        this.tester.submit();
        this.navigation.gotoAdminSection(Navigation.AdminSection.WORKFLOWS);
        this.tester.clickLink("steps_live_jira");
        this.tester.assertTextPresent("what-do-you-mean-resolved");
        this.tester.gotoPage("secure/admin/EditStatus!default.jspa?id=5");
        this.tester.setFormElement("name", "Resolved");
        this.tester.submit();
    }

    @Test
    public void testStatusCanBeMoved() {
        Object[] defaultStatusesOrder = new String[]{"Open", "In Progress", "Reopened", "Resolved", "Closed"};
        Object[] updatedStatusesOrder = new String[]{"In Progress", "Open", "Reopened", "Resolved", "Closed"};
        this.administration.restoreBlankInstance();
        this.tester.gotoPage("secure/admin/ViewStatuses.jspa");
        List<String> originalStatusesList = this.getStatusesList();
        Assert.assertThat(originalStatusesList, (Matcher)Matchers.contains((Object[])defaultStatusesOrder));
        this.tester.gotoPage(this.page.addXsrfToken("secure/admin/StatusUp.jspa?up=3"));
        List<String> statusesAfterMoveUp = this.getStatusesList();
        Assert.assertThat(statusesAfterMoveUp, (Matcher)Matchers.contains((Object[])updatedStatusesOrder));
        this.tester.gotoPage(this.page.addXsrfToken("secure/admin/StatusDown.jspa?down=3"));
        List<String> statusesAfterMoveDown = this.getStatusesList();
        Assert.assertThat(statusesAfterMoveDown, (Matcher)Matchers.contains((Object[])defaultStatusesOrder));
    }

    private List<String> getStatusesList() {
        XPathLocator statusesLocator = new XPathLocator(this.tester, "//table/tbody/tr/td/p[@class='description']/../b");
        return Arrays.stream(statusesLocator.getNodes()).map(Node::getTextContent).collect(Collectors.toList());
    }

    @Test
    public void testStatusMovesAreNotXsrfable() {
        this.administration.restoreBlankInstance();
        this.tester.gotoPage("/secure/admin/StatusUp.jspa?up=3");
        this.tester.assertTextPresent(ERROR_403_MESSAGE);
        this.tester.gotoPage("/secure/admin/StatusDown.jspa?down=3");
        this.tester.assertTextPresent(ERROR_403_MESSAGE);
    }

    private void assertDuplicateStatusError() {
        Assert.assertEquals((Object)"A status with that name already exists, please enter a different name.", (Object)this.locator.css(".error").getNode().getNodeValue());
    }
}

