/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.ao;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.util.SlowTest;
import com.atlassian.jira.webtests.LicenseKeys;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REFERENCE_PLUGIN, Category.ACTIVE_OBJECTS, Category.PLUGINS})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestActiveObjectsRestore
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Test
    @SlowTest
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testRestoreDataSuccessfully() {
        this.administration.restoreBlankInstance();
        String filePath = "ActiveObjects.zip";
        File file = new File(this.getEnvironmentData().getXMLDataLocation().getAbsolutePath() + "/" + filePath);
        this.copyFileToJiraImportDirectory(file);
        this.getTester().gotoPage("secure/admin/XmlRestore!default.jspa");
        this.getTester().setWorkingForm("restore-xml-data-backup");
        this.getTester().setFormElement("filename", filePath);
        this.getTester().setFormElement("license", LicenseKeys.COMMERCIAL_DC.getLicenseString());
        this.getTester().submit();
        this.administration.waitForRestore();
        this.getTester().assertTextPresent("Your import has been successful");
        this.getTester().assertTextNotPresent("NullPointerException");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testRestoreWithDatabaseErrors() {
        try {
            try {
                this.administration.restoreData("ActiveObjectsBadData.zip", false);
                Assert.fail((String)"Database restore did not fail even though a bad backup file was supplied");
            }
            catch (Throwable e) {
                Assert.assertTrue((String)("Active objects bad data: " + e.getMessage()), (boolean)e.getMessage().startsWith("Failed to restore Jira data from"));
            }
            String expectedMessage = "There was a problem restoring ActiveObjects data for the plugin Atlassian Jira - Plugins - Development Only - Reference Plugin(com.atlassian.jira.dev.reference-plugin) #1.0.0 plugin.";
            if (!this.tester.getDialog().isTextInResponse("There was a problem restoring ActiveObjects data for the plugin Atlassian Jira - Plugins - Development Only - Reference Plugin(com.atlassian.jira.dev.reference-plugin) #1.0.0 plugin.")) {
                Assert.fail((String)String.format("Could not find '%s' in page. Are you sure you have the jira-reference-plugin installed?", "There was a problem restoring ActiveObjects data for the plugin Atlassian Jira - Plugins - Development Only - Reference Plugin(com.atlassian.jira.dev.reference-plugin) #1.0.0 plugin."));
            }
            CssLocator cssLocator = new CssLocator(this.getTester(), ".aui-message.aui-message-error");
            this.assertions.assertNodeHasText(cssLocator, "There was a problem restoring ActiveObjects data for the plugin Atlassian Jira - Plugins - Development Only - Reference Plugin(com.atlassian.jira.dev.reference-plugin) #1.0.0 plugin.");
            this.assertions.assertNodeHasText(cssLocator, "Importing table AO_98E482_REF_ENTITY failed. Please check the log for details.");
        }
        finally {
            this.backdoor.restoreBlankInstance();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testRestoreWithParseErrors() {
        try {
            try {
                this.administration.restoreData("ActiveObjectsBadXml.zip", false);
                Assert.fail((String)"Database restore did not fail even though a bad backup file was supplied");
            }
            catch (Throwable e) {
                Assert.assertTrue((String)("Active objects bad data: " + e.getMessage()), (boolean)e.getMessage().startsWith("Failed to restore Jira data from"));
            }
            CssLocator cssLocator = new CssLocator(this.getTester(), ".aui-message.aui-message-error");
            this.assertions.assertNodeHasText(cssLocator, "There was a problem restoring ActiveObjects data for the <unknown plugin> plugin.");
            this.assertions.assertNodeHasText(cssLocator, "Caught exception with following message: Unexpected close tag </databaseGARBAGE>; expected </database>.\n at [row,col {unknown-source}]: [10,19].");
            this.assertions.assertNodeHasText(cssLocator, "Please check the log for details.");
        }
        finally {
            this.backdoor.restoreBlankInstance();
        }
    }

    private void copyFileToJiraImportDirectory(File file) {
        File jiraImportDirectory = new File(this.administration.getJiraHomeDirectory(), "import");
        try {
            FileUtils.copyFileToDirectory((File)file, (File)jiraImportDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy file " + file.getAbsolutePath() + " to the import directory in jira home " + jiraImportDirectory, e);
        }
    }
}

