/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.application;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.ApplicationRoleControl;
import com.atlassian.jira.functest.framework.backdoor.EventClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.ApplicationRoleBeanMatcher;
import com.atlassian.jira.testkit.beans.UserDTO;
import com.atlassian.jira.webtests.LicenseKeys;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.API, Category.LICENSING})
public class TestApplicationRoleCache
extends BaseJiraFuncTest {
    private static final String JIRA_TEST = "jira-func-test";
    private static final String JIRA_SOFTWARE = "jira-software";

    @Before
    public void setUpTest() {
        this.backdoor.restoreBlankInstance();
    }

    @After
    public void tearDownTest() {
        this.backdoor.events().stopAllPollers();
    }

    @Test
    public void testCacheEventsTriggered() {
        EventClient.EventPoller events = this.backdoor.events().createPoller();
        String testGroup = "testGroup";
        this.backdoor.usersAndGroups().addGroup("testGroup");
        MatcherAssert.assertThat(events.events(), (Matcher)Matchers.hasItem((Object)"com.atlassian.crowd.event.group.GroupCreatedEvent"));
        this.backdoor.usersAndGroups().addUserToGroup("fred", "testGroup");
        MatcherAssert.assertThat(events.events(), (Matcher)Matchers.hasItem((Object)"com.atlassian.crowd.event.group.GroupMembershipCreatedEvent"));
        this.backdoor.usersAndGroups().removeUserFromGroup("fred", "testGroup");
        MatcherAssert.assertThat(events.events(), (Matcher)Matchers.hasItem((Object)"com.atlassian.crowd.event.group.GroupMembershipDeletedEvent"));
        this.backdoor.usersAndGroups().deleteGroup("testGroup");
        MatcherAssert.assertThat(events.events(), (Matcher)Matchers.hasItem((Object)"com.atlassian.crowd.event.group.GroupDeletedEvent"));
        this.backdoor.license().set(LicenseKeys.CORE_ROLE_DC);
        MatcherAssert.assertThat(events.events(), (Matcher)Matchers.hasItem((Object)"com.atlassian.jira.license.LicenseChangedEvent"));
        UserDTO fred = this.backdoor.usersAndGroups().getUserByName("fred");
        this.backdoor.usersAndGroups().updateUser(TestApplicationRoleCache.deactivate(fred));
        MatcherAssert.assertThat(events.events(), (Matcher)Matchers.hasItem((Object)"com.atlassian.crowd.event.user.UserEditedEvent"));
        this.backdoor.usersAndGroups().updateUser(TestApplicationRoleCache.activate(fred));
        MatcherAssert.assertThat(events.events(), (Matcher)Matchers.hasItem((Object)"com.atlassian.crowd.event.user.UserEditedEvent"));
    }

    @Test
    public void testCache() {
        this.backdoor.applicationRoles().putRole(JIRA_SOFTWARE, "jira-administrators");
        String testGroup = "testGroup";
        ApplicationRoleControl roles = this.backdoor.applicationRoles();
        this.backdoor.license().set(LicenseKeys.TEST_ROLE_DC);
        this.backdoor.usersAndGroups().addGroup("testGroup");
        roles.putRoleAndSetDefault(JIRA_TEST, "testGroup");
        MatcherAssert.assertThat((Object)roles.getRole(JIRA_TEST), (Matcher)TestApplicationRoleCache.testRoleMatcher().setGroups("testGroup").setDefaultGroups("testGroup").setUserCount(0));
        this.backdoor.usersAndGroups().addUserToGroup("fred", "testGroup");
        MatcherAssert.assertThat((Object)roles.getRole(JIRA_TEST), (Matcher)TestApplicationRoleCache.testRoleMatcher().setGroups("testGroup").setDefaultGroups("testGroup").setUserCount(1));
        this.backdoor.usersAndGroups().deleteGroup("testGroup");
        MatcherAssert.assertThat((Object)roles.getRole(JIRA_TEST), (Matcher)TestApplicationRoleCache.testRoleMatcher().setGroups(new String[0]).setDefaultGroups(new String[0]).setUserCount(0));
        this.backdoor.usersAndGroups().addGroup("testGroup");
        MatcherAssert.assertThat((Object)roles.getRole(JIRA_TEST), (Matcher)TestApplicationRoleCache.testRoleMatcher().setGroups("testGroup").setDefaultGroups("testGroup").setUserCount(0));
        this.backdoor.usersAndGroups().addUserToGroup("fred", "testGroup");
        MatcherAssert.assertThat((Object)roles.getRole(JIRA_TEST), (Matcher)TestApplicationRoleCache.testRoleMatcher().setGroups("testGroup").setDefaultGroups("testGroup").setUserCount(1));
        UserDTO fred = this.backdoor.usersAndGroups().getUserByName("fred");
        this.backdoor.usersAndGroups().updateUser(TestApplicationRoleCache.deactivate(fred));
        MatcherAssert.assertThat((Object)roles.getRole(JIRA_TEST), (Matcher)TestApplicationRoleCache.testRoleMatcher().setGroups("testGroup").setDefaultGroups("testGroup").setUserCount(0));
        this.backdoor.usersAndGroups().updateUser(TestApplicationRoleCache.activate(fred));
        MatcherAssert.assertThat((Object)roles.getRole(JIRA_TEST), (Matcher)TestApplicationRoleCache.testRoleMatcher().setGroups("testGroup").setDefaultGroups("testGroup").setUserCount(1));
        this.backdoor.usersAndGroups().removeUserFromGroup("fred", "testGroup");
        MatcherAssert.assertThat((Object)roles.getRole(JIRA_TEST), (Matcher)TestApplicationRoleCache.testRoleMatcher().setGroups("testGroup").setDefaultGroups("testGroup").setUserCount(0));
    }

    private static UserDTO deactivate(UserDTO userDTO) {
        return TestApplicationRoleCache.setActive(userDTO, false);
    }

    private static UserDTO activate(UserDTO userDTO) {
        return TestApplicationRoleCache.setActive(userDTO, true);
    }

    private static UserDTO setActive(UserDTO userDTO, boolean active) {
        return new UserDTO(active, userDTO.getDirectoryId(), userDTO.getDisplayName(), userDTO.getEmail(), userDTO.getKey(), userDTO.getName(), userDTO.getUsername(), Long.valueOf(userDTO.getId()));
    }

    private static ApplicationRoleBeanMatcher testRoleMatcher() {
        return new ApplicationRoleBeanMatcher(JIRA_TEST, "Test Product");
    }
}

