/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.application;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.ApplicationRoleControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.ApplicationRoleBeanMatcher;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestApplicationRoleResource
extends BaseJiraFuncTest {
    private static final String USERS = "jira-users";
    private static final String DEVELOPERS = "jira-developers";
    private static final String ADMINS = "jira-administrators";
    private ApplicationRoleControl roleClient;

    @Before
    public void setUpTest() {
        this.roleClient = this.backdoor.applicationRoles();
    }

    @Test
    public void testAdminHappyPath() {
        this.backdoor.restoreBlankInstance(LicenseKeys.CORE_ROLE_DC);
        ApplicationRoleControl.ApplicationRoleBean roleBean = this.roleClient.getRole("jira-core");
        ApplicationRoleBeanMatcher matcher = ApplicationRoleBeanMatcher.forCore();
        matcher.setDefaultGroups(USERS);
        matcher.setGroups(USERS, ADMINS);
        matcher.setSelectedByDefault(true);
        MatcherAssert.assertThat((Object)roleBean, (Matcher)matcher);
        MatcherAssert.assertThat(this.roleClient.getRolesMap(), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"jira-core"), (Matcher)matcher));
        roleBean = this.roleClient.putRole("jira-core", USERS, DEVELOPERS);
        matcher.setDefaultGroups(new String[0]);
        matcher.setSelectedByDefault(false);
        MatcherAssert.assertThat((Object)roleBean, (Matcher)matcher.setGroups(USERS, DEVELOPERS));
        MatcherAssert.assertThat((Object)this.roleClient.getRole("jira-core"), (Matcher)matcher);
        MatcherAssert.assertThat(this.roleClient.getRolesMap(), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"jira-core"), (Matcher)matcher));
        roleBean = this.roleClient.putRoleWithDefaults("jira-core", TestApplicationRoleResource.groups(USERS, ADMINS), TestApplicationRoleResource.groups(USERS));
        MatcherAssert.assertThat((Object)roleBean, (Matcher)matcher.setGroups(USERS, ADMINS).setDefaultGroups(USERS));
        MatcherAssert.assertThat((Object)this.roleClient.getRole("jira-core"), (Matcher)matcher);
        MatcherAssert.assertThat(this.roleClient.getRolesMap(), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"jira-core"), (Matcher)matcher));
        roleBean = this.roleClient.putRoleWithDefaults("jira-core", TestApplicationRoleResource.groups(USERS, ADMINS), TestApplicationRoleResource.groups(USERS, ADMINS));
        MatcherAssert.assertThat((Object)roleBean, (Matcher)matcher.setGroups(USERS, ADMINS).setDefaultGroups(USERS, ADMINS));
        MatcherAssert.assertThat((Object)this.roleClient.getRole("jira-core"), (Matcher)matcher);
        MatcherAssert.assertThat(this.roleClient.getRolesMap(), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"jira-core"), (Matcher)matcher));
        roleBean = this.roleClient.putRole("jira-core", new String[0]);
        MatcherAssert.assertThat((Object)roleBean, (Matcher)matcher.setGroups(new String[0]).setDefaultGroups(new String[0]));
        MatcherAssert.assertThat((Object)this.roleClient.getRole("jira-core"), (Matcher)matcher);
        MatcherAssert.assertThat(this.roleClient.getRolesMap(), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"jira-core"), (Matcher)matcher));
        roleBean = this.roleClient.putRoleSelectedByDefault("jira-core", true);
        MatcherAssert.assertThat((Object)roleBean, (Matcher)matcher.setSelectedByDefault(true));
        MatcherAssert.assertThat((Object)this.roleClient.getRole("jira-core"), (Matcher)matcher);
        MatcherAssert.assertThat(this.roleClient.getRolesMap(), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"jira-core"), (Matcher)matcher));
        roleBean = this.roleClient.putRoleSelectedByDefault("jira-core", false);
        MatcherAssert.assertThat((Object)roleBean, (Matcher)matcher.setSelectedByDefault(false));
        MatcherAssert.assertThat((Object)this.roleClient.getRole("jira-core"), (Matcher)matcher);
        MatcherAssert.assertThat(this.roleClient.getRolesMap(), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"jira-core"), (Matcher)matcher));
    }

    @Test
    public void testResultOrder() {
        this.backdoor.restoreBlankInstance();
        this.backdoor.license().set(LicenseKeys.CORE_AND_TEST_ROLES_DC);
        String coreRoleName = this.roleClient.getCore().getName();
        List roleNames = this.roleClient.getRoles().stream().map(ApplicationRoleControl.ApplicationRoleBean::getName).collect(Collectors.toList());
        MatcherAssert.assertThat(roleNames, (Matcher)Matchers.contains((Object[])new String[]{"Jira Software", "Test Product", coreRoleName}));
    }

    @Test
    public void testWebsudo() {
        this.backdoor.restoreBlankInstance(LicenseKeys.CORE_ROLE_DC);
        this.backdoor.websudo().enable();
        try {
            Object response = this.roleClient.getRoleResponse("jira-core");
            MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)401));
            response = this.roleClient.getRolesResponse();
            MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)401));
            response = this.roleClient.putRoleResponse("jira-core", USERS);
            MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)401));
        }
        finally {
            this.backdoor.websudo().disable();
        }
    }

    @Test
    public void test403ReturnedForNonAdmin() {
        this.backdoor.restoreBlankInstance(LicenseKeys.CORE_ROLE_DC);
        Object response = ((ApplicationRoleControl)this.roleClient.loginAs("fred")).getRoleResponse("jira-core");
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)403));
        response = this.roleClient.getRolesResponse();
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)403));
        response = this.roleClient.putRoleResponse("jira-core", USERS);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)403));
    }

    private static Set<String> groups(String ... groups) {
        return ImmutableSet.copyOf((Object[])groups);
    }
}

