/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.application;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.ApplicationRoleControl;
import com.atlassian.jira.functest.framework.backdoor.LicenseControl;
import com.atlassian.jira.functest.framework.backdoor.ServerInfoControl;
import com.atlassian.jira.functest.framework.backdoor.SingleProductLicenseDetailsViewTO;
import com.atlassian.jira.functest.framework.backdoor.application.ApplicationAccessStatus;
import com.atlassian.jira.functest.framework.backdoor.application.ApplicationBean;
import com.atlassian.jira.functest.framework.backdoor.application.ApplicationControl;
import com.atlassian.jira.functest.framework.backdoor.application.PlatformApplicationBean;
import com.atlassian.jira.functest.framework.backdoor.application.PluginApplicationBean;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.ApplicationRoleBeanMatcher;
import com.atlassian.jira.testkit.client.UsersAndGroupsControl;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.API, Category.LICENSING})
@LoginAs(user="admin")
public class TestAtlassianApplication
extends BaseJiraFuncTest {
    private static final String ADMIN_GROUP = "jira-administrators";

    @Test
    public void testCoreExists() {
        this.backdoor.restoreBlankInstance();
        ApplicationControl applicationControl = this.backdoor.getApplicationControl();
        this.backdoor.license().replace(LicenseKeys.CORE_ROLE_DC);
        PlatformApplicationBean core = applicationControl.getCore();
        MatcherAssert.assertThat((Object)core.getKey(), (Matcher)Matchers.equalTo((Object)"jira-core"));
        ServerInfoControl.ServerInfo info = this.backdoor.serverInfo().get();
        MatcherAssert.assertThat((Object)core.getVersion(), (Matcher)Matchers.equalTo((Object)info.getVersion()));
        MatcherAssert.assertThat((Object)core.getBuildDate(), (Matcher)Matchers.equalTo((Object)info.getBuildDate()));
        SingleProductLicenseDetailsViewTO license = core.getLicense();
        MatcherAssert.assertThat((Object)license, (Matcher)Matchers.notNullValue(SingleProductLicenseDetailsViewTO.class));
        MatcherAssert.assertThat((Object)license.productKey, (Matcher)Matchers.equalTo((Object)"jira-core"));
        this.backdoor.license().replace(LicenseKeys.SOFTWARE_ROLE_DC);
        core = applicationControl.getCore();
        MatcherAssert.assertThat((Object)core.getKey(), (Matcher)Matchers.equalTo((Object)"jira-core"));
        MatcherAssert.assertThat((Object)core.getLicense(), (Matcher)Matchers.nullValue(SingleProductLicenseDetailsViewTO.class));
        MatcherAssert.assertThat((Object)applicationControl.getCount("jira-core", (Option<Integer>)Option.some((Object)0)), (Matcher)Matchers.equalTo((Object)"users"));
        MatcherAssert.assertThat((Object)applicationControl.getCount("jira-core", (Option<Integer>)Option.some((Object)1)), (Matcher)Matchers.equalTo((Object)"user"));
        MatcherAssert.assertThat((Object)applicationControl.getCount("jira-core", (Option<Integer>)Option.some((Object)2)), (Matcher)Matchers.equalTo((Object)"users"));
        MatcherAssert.assertThat((Object)applicationControl.getCount("jira-core", (Option<Integer>)Option.none(Integer.class)), (Matcher)Matchers.equalTo((Object)"users"));
    }

    @Test
    public void testCoreApplicationAccess() {
        this.backdoor.restoreBlankInstance(LicenseKeys.CORE_ROLE_DC);
        ApplicationControl applicationControl = this.backdoor.getApplicationControl();
        this.backdoor.applicationRoles().putRoleWithDefaults("jira-core", Sets.newHashSet((Object[])new String[]{"jira-developers", ADMIN_GROUP}), Sets.newHashSet((Object[])new String[]{"jira-developers"}));
        ApplicationBean application = applicationControl.getApplication("jira-core");
        MatcherAssert.assertThat((Object)application.getMaxUserCount(), (Matcher)Matchers.equalTo((Object)5));
        MatcherAssert.assertThat((Object)application.getCurrentUserCount(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((Object)applicationControl.getApplicationAccess("jira-core", "admin")), (Matcher)Matchers.equalTo((Object)((Object)ApplicationAccessStatus.OK)));
        MatcherAssert.assertThat((Object)((Object)applicationControl.getApplicationAccess("jira-core", "fred")), (Matcher)Matchers.equalTo((Object)((Object)ApplicationAccessStatus.NO_ACCESS)));
    }

    @Test
    public void testDummyApplicationExists() {
        this.backdoor.restoreBlankInstance();
        this.backdoor.license().replace(LicenseKeys.SOFTWARE_ROLE_DC);
        ApplicationControl applicationControl = this.backdoor.getApplicationControl();
        PluginApplicationBean testApp = applicationControl.getPlugin("jira-func-test");
        this.assertTestApplicationState(testApp);
        MatcherAssert.assertThat((Object)testApp.getLicense(), (Matcher)Matchers.nullValue(SingleProductLicenseDetailsViewTO.class));
        this.backdoor.license().replace(LicenseKeys.TEST_ROLE_DC);
        testApp = applicationControl.getPlugin("jira-func-test");
        this.assertTestApplicationState(testApp);
        MatcherAssert.assertThat((Object)testApp.getLicense(), (Matcher)Matchers.notNullValue(SingleProductLicenseDetailsViewTO.class));
        MatcherAssert.assertThat((Object)testApp.getLicense().productKey, (Matcher)Matchers.equalTo((Object)"jira-func-test"));
        MatcherAssert.assertThat((Object)applicationControl.getCount("jira-func-test", (Option<Integer>)Option.some((Object)0)), (Matcher)Matchers.equalTo((Object)"testers"));
        MatcherAssert.assertThat((Object)applicationControl.getCount("jira-func-test", (Option<Integer>)Option.some((Object)1)), (Matcher)Matchers.equalTo((Object)"tester"));
        MatcherAssert.assertThat((Object)applicationControl.getCount("jira-func-test", (Option<Integer>)Option.some((Object)2)), (Matcher)Matchers.equalTo((Object)"too many testers"));
    }

    @Test
    public void testDummyApplicationAccess() {
        this.backdoor.restoreBlankInstance(LicenseKeys.CORE_ROLE_DC);
        UsersAndGroupsControl usersAndGroups = this.backdoor.usersAndGroups();
        ApplicationRoleControl roles = this.backdoor.applicationRoles();
        LicenseControl license = this.backdoor.license();
        ApplicationControl applicationControl = this.backdoor.getApplicationControl();
        roles.putRoleWithDefaults("jira-core", Sets.newHashSet((Object[])new String[]{"jira-users", ADMIN_GROUP}), Sets.newHashSet((Object[])new String[]{"jira-users"}));
        license.set(LicenseKeys.TEST_ROLE_DC.getLicenseString());
        ApplicationBean application = applicationControl.getApplication("jira-func-test");
        MatcherAssert.assertThat((Object)application.getMaxUserCount(), (Matcher)Matchers.equalTo((Object)10));
        MatcherAssert.assertThat((Object)application.getCurrentUserCount(), (Matcher)Matchers.equalTo((Object)1));
        String testGroup = "test-group";
        String testuser = "testuser";
        usersAndGroups.addGroup("test-group");
        usersAndGroups.addUser("testuser");
        usersAndGroups.addUserToGroup("testuser", "test-group");
        String testuserKey = usersAndGroups.getUserByName("testuser").getKey();
        roles.putRoleAndSetDefault("jira-func-test", "test-group");
        application = applicationControl.getApplication("jira-func-test");
        MatcherAssert.assertThat((Object)application.getMaxUserCount(), (Matcher)Matchers.equalTo((Object)10));
        MatcherAssert.assertThat((Object)application.getCurrentUserCount(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((Object)applicationControl.getApplicationAccess("jira-func-test", testuserKey)), (Matcher)Matchers.equalTo((Object)((Object)ApplicationAccessStatus.OK)));
        MatcherAssert.assertThat((Object)((Object)applicationControl.getApplicationAccess("jira-func-test", "admin")), (Matcher)Matchers.equalTo((Object)((Object)ApplicationAccessStatus.NO_ACCESS)));
        license.replace(LicenseKeys.CORE_ROLE_DC);
        MatcherAssert.assertThat((Object)((Object)applicationControl.getApplicationAccess("jira-func-test", testuserKey)), (Matcher)Matchers.equalTo((Object)((Object)ApplicationAccessStatus.UNLICENSED)));
        MatcherAssert.assertThat((Object)((Object)applicationControl.getApplicationAccess("jira-func-test", "admin")), (Matcher)Matchers.equalTo((Object)((Object)ApplicationAccessStatus.UNLICENSED)));
        MatcherAssert.assertThat((Object)((Object)applicationControl.getApplicationAccess("jira-func-test", "admin")), (Matcher)Matchers.equalTo((Object)((Object)ApplicationAccessStatus.UNLICENSED)));
    }

    @Test
    public void testClearApplicationConfiguration() {
        this.backdoor.restoreBlankInstance();
        this.backdoor.license().replace(LicenseKeys.TEST_ROLE_DC);
        ApplicationControl appControl = this.backdoor.getApplicationControl();
        ApplicationRoleControl appRoleControl = this.backdoor.applicationRoles();
        String grpA = "test-group-a";
        String grpB = "test-group-b";
        this.backdoor.usersAndGroups().addGroup("test-group-a");
        this.backdoor.usersAndGroups().addGroup("test-group-b");
        appRoleControl.putRoleWithDefaultsSelectedByDefault("jira-func-test", true, this.groups("test-group-a", "test-group-b"), this.groups("test-group-a"));
        MatcherAssert.assertThat((Object)appRoleControl.getRole("jira-func-test"), (Matcher)this.matcherForTestRole().setDefaultGroups("test-group-a").setGroups("test-group-a", "test-group-b").setSelectedByDefault(true).setNumberOfSeats(10).setRemainingSeats(10).setUserCount(0));
        appControl.clearConfiguration("jira-func-test");
        MatcherAssert.assertThat((Object)appRoleControl.getRole("jira-func-test"), (Matcher)this.matcherForTestRole());
    }

    private HashSet<String> groups(String ... groupsNames) {
        return Sets.newHashSet((Object[])groupsNames);
    }

    private ApplicationRoleBeanMatcher matcherForTestRole() {
        return new ApplicationRoleBeanMatcher("jira-func-test", "Test Product");
    }

    private void assertTestApplicationState(PluginApplicationBean application) {
        MatcherAssert.assertThat((Object)application.getKey(), (Matcher)Matchers.equalTo((Object)"jira-func-test"));
        MatcherAssert.assertThat((Object)application.getName(), (Matcher)Matchers.equalTo((Object)"Test Product"));
        MatcherAssert.assertThat((Object)application.getDefinitionModuleKey(), (Matcher)Matchers.equalTo((Object)"com.atlassian.jira.dev.func-test-plugin:application"));
        MatcherAssert.assertThat((Object)application.getConfigurationURI(), (Matcher)Matchers.equalTo((Object)"/configureMe"));
        MatcherAssert.assertThat((Object)application.getPostInstallURI(), (Matcher)Matchers.equalTo((Object)"/Dashboard.jspa?plugin=jira-func-test-plugin"));
        MatcherAssert.assertThat((Object)application.getPostUpdateURI(), (Matcher)Matchers.equalTo((Object)"/postUpdate/actions.do"));
        MatcherAssert.assertThat((Object)application.getDescription(), (Matcher)Matchers.equalTo((Object)"Description about the test application."));
        MatcherAssert.assertThat((Object)application.getAccessURI(), (Matcher)Matchers.equalTo((Object)String.format("/secure/admin/user/UserBrowser.jspa?applicationFilter=%s", "jira-func-test")));
        MatcherAssert.assertThat((Object)application.getDefaultGroup(), (Matcher)Matchers.equalTo((Object)"jira-test-group"));
        MatcherAssert.assertThat(this.getPluginTypes(application.getPlugins(), PluginApplicationBean.PluginType.PRIMARY), (Matcher)Matchers.contains((Object[])new String[]{"com.atlassian.jira.dev.func-test-plugin"}));
        MatcherAssert.assertThat(this.getPluginTypes(application.getPlugins(), PluginApplicationBean.PluginType.APPLICATION), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"one", "two", "three"}));
        MatcherAssert.assertThat(this.getPluginTypes(application.getPlugins(), PluginApplicationBean.PluginType.UTILITY), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"four", "five", "six"}));
    }

    private Iterable<String> getPluginTypes(Iterable<PluginApplicationBean.PluginBean> beans, PluginApplicationBean.PluginType type) {
        return Iterables.transform((Iterable)Iterables.filter(beans, TestAtlassianApplication.typePredicate(type)), PluginApplicationBean.PluginBean::getKey);
    }

    private static Predicate<PluginApplicationBean.PluginBean> typePredicate(PluginApplicationBean.PluginType type) {
        return input -> input.getType() == type;
    }
}

