/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.meterware.httpunit.HttpUnitOptions;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS})
@Restore(value="TestFullAnonymousPermissions.xml")
public class TestAttachFile
extends BaseJiraFuncTest {
    private static final String LOGIN = "log in";
    private static final String SIGNUP = "sign up";
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.backdoor.attachments().enable();
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    @After
    public void tearDownTest() {
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    @Test
    public void testAttachFileLoggedIn() {
        this.disallowAnonymousAttachmentCreation();
        this.navigation.login("fred");
        this.navigation.issue().gotoIssue("MKY-2");
        this.tester.clickLink("attach-file");
        this.tester.assertElementPresent("attach-file-submit");
    }

    @Test
    public void testAttachNoFileError() {
        this.navigation.issue().gotoIssue("MKY-2");
        this.tester.clickLink("attach-file");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "<h1>Errors</h1>");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Please indicate the file you wish to upload");
        this.tester.setWorkingForm("attach-file");
        this.tester.submit();
        this.textAssertions.assertTextPresent(this.locator.page(), "Please indicate the file you wish to upload");
    }

    @Test
    public void testAttachFileLoggedOutNoAnonymousPermission() {
        this.disallowAnonymousAttachmentCreation();
        this.navigation.logout();
        this.navigation.issue().gotoIssue("MKY-2");
        this.tester.assertLinkNotPresent("attach-file");
        this.tester.gotoPage("/secure/AttachFile!default.jspa?id=10011");
        this.textAssertions.assertTextPresent(this.locator.page(), "You do not have permission to create attachments for this issue.");
        this.textAssertions.assertTextPresent(this.locator.page(), "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.tester.assertLinkPresentWithText(LOGIN);
        this.tester.assertLinkPresentWithText(SIGNUP);
        this.tester.assertElementNotPresent("attach-file-submit");
        this.tester.gotoPage("/secure/AttachFile!default.jspa?id=99999");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "You do not have permission to create attachments for this issue.");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.tester.assertElementNotPresent("attach-file-submit");
    }

    @Test
    public void testAttachFileLoggedOutWithAnonymousPermission() {
        this.navigation.logout();
        this.navigation.issue().gotoIssue("MKY-2");
        this.tester.clickLink("attach-file");
        this.tester.gotoPage("/secure/AttachFile!default.jspa?id=10011");
        this.tester.assertElementPresent("attach-file-submit");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "You are not logged in, and do not have the permissions required to attach a file on the selected issue as a guest.");
        this.tester.gotoPage("/secure/AttachFile!default.jspa?id=99999");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "You do not have permission to create attachments for this issue.");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "You are not logged in, and do not have the permissions required to attach a file on the selected issue as a guest.");
        this.tester.assertElementNotPresent("attach-file-submit");
    }

    @Test
    public void testAttachFileLoggedInWithoutPermission() {
        this.disallowAnyoneAttachmentCreation();
        this.navigation.issue().gotoIssue("MKY-2");
        this.tester.assertLinkNotPresent("attach-file");
        this.tester.gotoPage("/secure/AttachFile!default.jspa?id=10011");
        this.textAssertions.assertTextPresent(this.locator.page(), "You do not have permission to create attachments for this issue.");
        this.tester.assertElementNotPresent("attach-file-submit");
        this.tester.gotoPage("/secure/AttachFile!default.jspa?id=99999");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "You do not have permission to create attachments for this issue.");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "You are not logged in, and do not have the permissions required to attach a file on the selected issue as a guest.");
        this.tester.assertElementNotPresent("attach-file-submit");
    }

    private void disallowAnonymousAttachmentCreation() {
        this.backdoor.getTestkit().permissionSchemes().removeEveryonePermission(Long.valueOf(0L), ProjectPermissions.CREATE_ATTACHMENTS);
    }

    private void disallowUsersAttachmentCreation() {
        this.backdoor.getTestkit().permissionSchemes().removeGroupPermission(0L, ProjectPermissions.CREATE_ATTACHMENTS, "jira-users");
    }

    private void disallowAnyoneAttachmentCreation() {
        this.disallowAnonymousAttachmentCreation();
        this.disallowUsersAttachmentCreation();
    }
}

