/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.navigation.issue.AttachmentsBlock;
import com.atlassian.jira.functest.framework.navigation.issue.FileAttachmentsList;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.Rules;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS})
@LoginAs(user="admin")
@Restore(value="TestAttachmentEncoding.xml")
public class TestAttachmentEncoding
extends BaseJiraFuncTest {
    @Rule
    public TestRule copyAttachmentsRule = Rules.prepareAttachments(this::getEnvironmentData, this::getBackdoor, "TestAttachmentEncoding/attachments");

    @Test
    public void testCheckVariousAttachmentFilenames() {
        AttachmentsBlock attachments = this.navigation.issue().attachments("HSP-1");
        List<FileAttachmentsList.FileAttachmentItem> attachmentsList = attachments.list().get();
        Assert.assertEquals((long)3L, (long)attachmentsList.size());
        this.tester.gotoPage("/secure/attachment/10000/clover.license");
        this.tester.gotoPage("/secure/attachment/10001/sqltool.rc");
        this.tester.gotoPage("/secure/attachment/10002/svn");
    }

    @Test
    public void testMoveIssue() throws Exception {
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("monkey");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.submit("Move");
        for (FileAttachmentsList.FileAttachmentItem fileAttachmentItem : this.navigation.issue().attachments("MKY-1").list().get()) {
            this.tester.gotoPage("/secure/attachment/" + fileAttachmentItem.getId() + "/" + fileAttachmentItem.getName());
        }
    }
}

