/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS, Category.BROWSING})
@Restore(value="TestEditAttachmentSettings.xml")
@LoginAs(user="admin")
public class TestEditAttachmentSettings
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testEditAttachmentSettingsValidation() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.tester.clickLinkWithText("Edit Settings");
        this.tester.checkCheckbox("attachmentsEnabled", "true");
        this.tester.setFormElement("maxAttachmentSize", "");
        this.tester.setFormElement("thumbnailsEnabled", "true");
        this.tester.submit("Save");
        this.tester.assertTextPresent("Please specify the attachment size.");
        this.tester.checkCheckbox("attachmentsEnabled", "true");
        this.tester.setFormElement("maxAttachmentSize", "-1");
        this.tester.setFormElement("thumbnailsEnabled", "true");
        this.tester.submit("Save");
        this.tester.assertTextPresent("Attachment size must be a positive number.");
        this.tester.checkCheckbox("attachmentsEnabled", "true");
        this.tester.setFormElement("maxAttachmentSize", "0");
        this.tester.setFormElement("thumbnailsEnabled", "true");
        this.tester.submit("Save");
        this.tester.assertTextPresent("Attachment size must be a positive number.");
        this.tester.checkCheckbox("attachmentsEnabled", "true");
        this.tester.setFormElement("maxAttachmentSize", "2147483648");
        this.tester.setFormElement("thumbnailsEnabled", "true");
        this.tester.submit("Save");
        this.tester.assertTextPresent("Attachment size must be a number between 1 and 2147483647");
        this.tester.checkCheckbox("attachmentsEnabled", "true");
        this.tester.setFormElement("maxAttachmentSize", "9999999999");
        this.tester.setFormElement("thumbnailsEnabled", "true");
        this.tester.submit("Save");
        this.tester.assertTextPresent("Attachment size must be a number between 1 and 2147483647");
        this.tester.checkCheckbox("attachmentsEnabled", "false");
        this.tester.setFormElement("maxAttachmentSize", "1");
        this.tester.setFormElement("thumbnailsEnabled", "true");
        this.tester.submit("Save");
        this.tester.assertTextPresent("Attachments must be enabled to enable thumbnails.");
        this.tester.checkCheckbox("attachmentsEnabled", "false");
        this.tester.setFormElement("maxAttachmentSize", "1");
        this.tester.setFormElement("thumbnailsEnabled", "false");
        this.tester.setFormElement("zipSupport", "true");
        this.tester.submit("Save");
        this.tester.assertTextPresent("Attachments must be enabled to enable ZIP support.");
    }

    @Test
    public void testSizeIsNotUpdatedIfAttachmentsDisabled() throws SAXException {
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.tester.clickLinkWithText("Edit Settings");
        this.tester.checkCheckbox("attachmentsEnabled", "true");
        this.tester.setFormElement("maxAttachmentSize", "12345");
        this.tester.submit("Save");
        this.tester.assertTextPresent("12 kB");
        this.tester.clickLinkWithText("Edit Settings");
        this.tester.checkCheckbox("attachmentsEnabled", "false");
        this.tester.setFormElement("maxAttachmentSize", "54321");
        this.tester.setFormElement("thumbnailsEnabled", "false");
        this.tester.setFormElement("zipSupport", "false");
        this.tester.submit("Save");
        this.tester.assertTextPresent("12 kB");
        this.tester.clickLinkWithText("Edit Settings");
        this.tester.assertTextPresent("12345");
        this.tester.assertTextNotPresent("54321");
    }

    @Test
    public void testEditAttachmentSettingsAttachmentLocationTitle() {
        this.navigation.logout();
        this.navigation.login("sysadmin", "sysadmin");
        this.administration.attachments().enable("2940");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.tester.clickLinkWithText("Edit Settings");
        this.tester.setFormElement("thumbnailsEnabled", "true");
        this.tester.submit("Save");
        String expectedStorageLocation = "<strong>" + (this.backdoor.attachmentFile().isInSharedHome() != false ? "Jira home" : "Amazon S3") + "</strong>";
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Allow attachments", "ON", "Attachments location", expectedStorageLocation, "Attachment size", "3 kB", "Enable thumbnails", "ON"});
    }

    @Test
    public void testEditAttachmentSettingsWithGlobalAdmin() {
        String attachmentPath = this.getEnvironmentData().getWorkingDirectory().getAbsolutePath() + FunctTestConstants.FS + "attachments";
        this.navigation.logout();
        this.navigation.login("sysadmin", "sysadmin");
        this.navigation.gotoAdmin();
        this.administration.attachments().enable("8765");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.tester.clickLinkWithText("Edit Settings");
        this.tester.checkCheckbox("attachmentsEnabled", "false");
        this.tester.setFormElement("thumbnailsEnabled", "false");
        this.tester.setFormElement("zipSupport", "false");
        this.tester.submit("Save");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Allow attachments", "OFF", "Attachments location", "Attachment size", "9 kB", "Enable thumbnails", "OFF"});
        this.navigation.logout();
        this.navigation.login("globaladmin", "globaladmin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.tester.assertTextPresent("You can not enable thumbnails unless attachments are enabled.");
        this.tester.assertLinkNotPresentWithText("Edit Settings");
        this.tester.gotoPage("/secure/admin/jira/EditAttachmentSettings!default.jspa");
        this.tester.assertFormElementNotPresent("attachmentsEnabled");
        this.tester.assertFormElementNotPresent("attachmentPath");
        this.tester.setFormElement("maxAttachmentSize", "5678");
        this.tester.setFormElement("thumbnailsEnabled", "true");
        this.tester.submit("Save");
        this.tester.assertTextPresent("Attachments must be enabled to enable thumbnails.");
        this.tester.setFormElement("thumbnailsEnabled", "false");
        this.tester.submit("Save");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Allow attachments", "OFF", "Attachments location", "Attachment size", "9 kB", "Enable thumbnails", "OFF"});
        this.navigation.logout();
        this.navigation.login("sysadmin", "sysadmin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.tester.clickLinkWithText("Edit Settings");
        this.tester.checkCheckbox("attachmentsEnabled", "true");
        this.tester.setFormElement("maxAttachmentSize", "1234");
        this.tester.setFormElement("thumbnailsEnabled", "false");
        this.tester.submit("Save");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Allow attachments", "ON", "Attachment size", "1 kB", "Enable thumbnails", "OFF"});
        this.navigation.logout();
        this.navigation.login("globaladmin", "globaladmin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ATTACHMENTS);
        this.tester.assertLinkPresentWithText("Edit Settings");
        this.tester.clickLinkWithText("Edit Settings");
        this.tester.assertFormElementNotPresent("attachmentsEnabled");
        this.tester.assertFormElementNotPresent("attachmentPath");
        this.tester.setFormElement("maxAttachmentSize", "3456");
        this.tester.setFormElement("thumbnailsEnabled", "true");
        this.tester.submit("Save");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Allow attachments", "ON", "Attachment size", "3 kB", "Enable thumbnails", "ON"});
    }

    @Test
    public void testEditAttachmentSize() {
        this.assertAttachmentSize(1, "0.0 kB");
        this.assertAttachmentSize(1024, "1.0 kB");
        this.assertAttachmentSize(2048, "2 kB");
        this.assertAttachmentSize(0x100000, "1024 kB");
        this.assertAttachmentSize(0x100001, "1.00 MB");
        this.assertAttachmentSize(0x18CCCC, "1.55 MB");
        this.assertAttachmentSize(0xA00000, "10.00 MB");
        this.assertAttachmentSize(Integer.MAX_VALUE, "2,048.00 MB");
    }

    private void assertAttachmentSize(int maxSizeInBytes, String maxSizePrettyFormat) {
        this.administration.attachments().enable(String.valueOf(maxSizeInBytes));
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Allow attachments", "ON", "Attachments location", "Attachment size", maxSizePrettyFormat, "Enable thumbnails"});
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.assertTextPresent("The maximum file upload size is " + maxSizePrettyFormat + ".");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("attach-file");
        this.tester.assertTextPresent("The maximum file upload size is " + maxSizePrettyFormat + ".");
    }
}

