/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.navigation.issue.AttachmentsBlock;
import com.atlassian.jira.functest.framework.navigation.issue.ImageAttachmentsGallery;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.webtests.ztests.attachment.AbstractTestAttachmentsBlockSortingOnViewIssue;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@LoginAs(user="admin")
public class TestImageAttachmentsGallerySorting
extends AbstractTestAttachmentsBlockSortingOnViewIssue {
    @Test
    public void testAttachmentsDefaultToSortingByNameInDescendingOrder() throws Exception {
        List<ImageAttachmentsGallery.ImageAttachmentItem> expectedImageAttachments = CollectionBuilder.newBuilder(new ImageAttachmentsGallery.ImageAttachmentItem("_fil\u00e5e", "0.0 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("[#JRA-18780] Test Issue 123 - Atlassian.pdf", "193 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("[#JRA-18780] Test Issue 123 - Printable.pdf", "98 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("200px-FCB.svg.png", "16 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("a", "0.0 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("a1k4BJwT.jpg.part", "22 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("\u00e1 file", "0.0 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("build.xml", "1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("catalina.sh", "12 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("license.txt", "1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("license.txt", "1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("pom.xml", "5 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("pom.xml", "2 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("Tickspot", "0.1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB")).asList();
        List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = this.navigation.issue().attachments("HSP-1", AttachmentsBlock.ViewMode.GALLERY).gallery().get();
        Assert.assertEquals(expectedImageAttachments, actualImageAttachments);
    }

    @Test
    public void testCanSortAttachmentsByFileNameInAscendingOrder() throws Exception {
        List<ImageAttachmentsGallery.ImageAttachmentItem> expectedImageAttachments = CollectionBuilder.newBuilder(new ImageAttachmentsGallery.ImageAttachmentItem("_fil\u00e5e", "0.0 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("[#JRA-18780] Test Issue 123 - Atlassian.pdf", "193 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("[#JRA-18780] Test Issue 123 - Printable.pdf", "98 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("200px-FCB.svg.png", "16 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("a", "0.0 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("a1k4BJwT.jpg.part", "22 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("\u00e1 file", "0.0 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("build.xml", "1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("catalina.sh", "12 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("license.txt", "1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("license.txt", "1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("pom.xml", "5 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("pom.xml", "2 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("Tickspot", "0.1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB")).asList();
        AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1", AttachmentsBlock.ViewMode.GALLERY);
        attachmentsBlock.sort(AttachmentsBlock.Sort.Key.NAME, AttachmentsBlock.Sort.Direction.ASCENDING);
        List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = attachmentsBlock.gallery().get();
        Assert.assertEquals(expectedImageAttachments, actualImageAttachments);
        this.verifySortingSettingIsStickyDuringTheSession(expectedImageAttachments);
    }

    @Test
    public void testCanSortAttachmentsByFileNameInDescendingOrder() throws Exception {
        List<ImageAttachmentsGallery.ImageAttachmentItem> expectedImageAttachments = CollectionBuilder.newBuilder(new ImageAttachmentsGallery.ImageAttachmentItem("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("Tickspot", "0.1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("pom.xml", "2 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("pom.xml", "5 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("license.txt", "1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("license.txt", "1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("catalina.sh", "12 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("build.xml", "1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("\u00e1 file", "0.0 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("a1k4BJwT.jpg.part", "22 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("a", "0.0 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("200px-FCB.svg.png", "16 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("[#JRA-18780] Test Issue 123 - Printable.pdf", "98 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("[#JRA-18780] Test Issue 123 - Atlassian.pdf", "193 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("_fil\u00e5e", "0.0 kB")).asList();
        AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1", AttachmentsBlock.ViewMode.GALLERY);
        attachmentsBlock.sort(AttachmentsBlock.Sort.Key.NAME, AttachmentsBlock.Sort.Direction.DESCENDING);
        List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = attachmentsBlock.gallery().get();
        Assert.assertEquals(expectedImageAttachments, actualImageAttachments);
        this.verifySortingSettingIsStickyDuringTheSession(expectedImageAttachments);
    }

    @Test
    public void testCanSortAttachmentsByDateInAscendingOrder() throws Exception {
        List<ImageAttachmentsGallery.ImageAttachmentItem> expectedImageAttachments = CollectionBuilder.newBuilder(new ImageAttachmentsGallery.ImageAttachmentItem("license.txt", "1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("pom.xml", "2 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("license.txt", "1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("200px-FCB.svg.png", "16 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("[#JRA-18780] Test Issue 123 - Atlassian.pdf", "193 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("pom.xml", "5 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("build.xml", "1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("a1k4BJwT.jpg.part", "22 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("[#JRA-18780] Test Issue 123 - Printable.pdf", "98 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("Tickspot", "0.1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("a", "0.0 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("_fil\u00e5e", "0.0 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("\u00e1 file", "0.0 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("catalina.sh", "12 kB")).asList();
        AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1", AttachmentsBlock.ViewMode.GALLERY);
        attachmentsBlock.sort(AttachmentsBlock.Sort.Key.DATE, AttachmentsBlock.Sort.Direction.ASCENDING);
        List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = attachmentsBlock.gallery().get();
        Assert.assertEquals(expectedImageAttachments, actualImageAttachments);
        this.verifySortingSettingIsStickyDuringTheSession(expectedImageAttachments);
    }

    @Test
    public void testCanSortAttachmentsByDateInDescendingOrder() throws Exception {
        List<ImageAttachmentsGallery.ImageAttachmentItem> expectedImageAttachments = CollectionBuilder.newBuilder(new ImageAttachmentsGallery.ImageAttachmentItem("catalina.sh", "12 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("\u00e1 file", "0.0 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("_fil\u00e5e", "0.0 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("a", "0.0 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("Tickspot", "0.1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("[#JRA-18780] Test Issue 123 - Printable.pdf", "98 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("a1k4BJwT.jpg.part", "22 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("build.xml", "1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("pom.xml", "5 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("[#JRA-18780] Test Issue 123 - Atlassian.pdf", "193 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("tropical-desktop-wallpaper-1280x1024.jpg", "115 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("200px-FCB.svg.png", "16 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("license.txt", "1 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("235px-Floppy_disk_2009_G1.jpg", "8 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("pom.xml", "2 kB"), new ImageAttachmentsGallery.ImageAttachmentItem("license.txt", "1 kB")).asList();
        AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1", AttachmentsBlock.ViewMode.GALLERY);
        attachmentsBlock.sort(AttachmentsBlock.Sort.Key.DATE, AttachmentsBlock.Sort.Direction.DESCENDING);
        List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = attachmentsBlock.gallery().get();
        Assert.assertEquals(expectedImageAttachments, actualImageAttachments);
        this.verifySortingSettingIsStickyDuringTheSession(expectedImageAttachments);
    }

    private void verifySortingSettingIsStickyDuringTheSession(List<ImageAttachmentsGallery.ImageAttachmentItem> expectedFileAttachmentsList) {
        this.navigation.gotoDashboard();
        AttachmentsBlock attachmentsBlock = this.navigation.issue().attachments("HSP-1", AttachmentsBlock.ViewMode.GALLERY);
        List<ImageAttachmentsGallery.ImageAttachmentItem> actualImageAttachments = attachmentsBlock.gallery().get();
        Assert.assertEquals(expectedFileAttachmentsList, actualImageAttachments);
    }
}

