/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HttpUnitConfiguration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.page.Error404;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS})
@HttpUnitConfiguration(throwOnErrorStatus=false, enableScripting=false)
@Restore(value="TestDeleteAttachments.xml")
@LoginAs(user="admin")
public class TestIssueFileAttachmentErrors
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private Assertions assertions;

    @Before
    public void setUpTest() {
        this.administration.attachments().enable();
    }

    @Test
    public void testViewAttachmentWithNonNumericId() {
        Assert.assertThat((Object)new Error404(this.tester).visit("/secure/attachment/idontparse/DummyAttachment"), Error404.isOn404Page());
    }

    @Test
    public void testViewAttachmentWithNoPath() {
        this.assertErrorResponse("/secure/attachment/", 400, "Invalid attachment path");
    }

    @Test
    public void testTryDownloadAsZipWhenZipDisabled() throws Exception {
        this.administration.attachments().disableZipSupport();
        Assert.assertThat((Object)new Error404(this.tester).visit("/secure/attachmentzip/10000.zip"), Error404.isOn404Page());
    }

    private void assertErrorResponse(String url, int errorCode, String message) {
        this.tester.beginAt(url);
        Assert.assertEquals((long)errorCode, (long)this.tester.getDialog().getResponse().getResponseCode());
        this.assertions.html().assertResponseContains(this.tester, message);
    }
}

