/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.attachment;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.Rules;
import com.google.common.io.LineReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@WebTest(value={Category.FUNC_TEST, Category.ATTACHMENTS, Category.SECURITY})
@LoginAs(user="admin")
@Restore(value="TestZipAttachmentSecurity/TestZipAttachmentSecurity.xml")
public class TestZipAttachmentSecurity
extends BaseJiraFuncTest {
    private final HttpClient client = new HttpClient();
    @Rule
    public TestRule copyAttachmentsRule = Rules.prepareAttachments(this::getEnvironmentData, this::getBackdoor, "TestZipAttachmentSecurity/attachments");

    @Before
    public void setUpTest() {
        this.client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        this.client.getParams().setAuthenticationPreemptive(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAttachmentUnzippingWithChrome() throws URISyntaxException, IOException {
        GetMethod request = new GetMethod(this.unzipFileUri().toString());
        request.setRequestHeader("User-Agent", "Mozilla/5.0 (X11; Linux x86_64)");
        int status = this.client.executeMethod((HttpMethod)request);
        Assert.assertEquals((long)200L, (long)status);
        InputStream is = request.getResponseBodyAsStream();
        try {
            LineReader lineReader = new LineReader((Readable)new InputStreamReader(is));
            Assert.assertEquals((Object)"1: This is a text file with 1000 lines.", (Object)lineReader.readLine());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAttachmentUnzuppingWithOldIE() throws IOException, URISyntaxException {
        GetMethod request = new GetMethod(this.unzipFileUri().toString());
        request.setRequestHeader("User-Agent", "Mozilla/5.0 (compatible; MSIE 7.01; Windows NT 5.0)");
        int status = this.client.executeMethod((HttpMethod)request);
        Assert.assertEquals((long)200L, (long)status);
        InputStream is = request.getResponseBodyAsStream();
        try {
            LineReader lineReader = new LineReader((Readable)new InputStreamReader(is));
            Assert.assertEquals((Object)"1: This is a text file with 1000 lines.", (Object)lineReader.readLine());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private URI unzipFileUri() throws URISyntaxException {
        return UriBuilder.fromUri((URI)this.environmentData.getBaseUrl().toURI()).path("secure/attachmentzip/unzip/10010/10000%5B0%5D/file.txt").build(new Object[0]);
    }
}

