/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.avatar;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestRestClient;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.UserClient;
import com.google.common.collect.Lists;
import com.meterware.httpunit.ClientProperties;
import com.meterware.httpunit.WebResponse;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST})
@RestoreBlankInstance
public class TestGravatarSupport
extends BaseJiraFuncTest {
    private static final String ADMIN_MD5 = "e64c7d89f26bd1972efa854d13d7dd61";
    private static final String FRED_MD5 = "6255165076a5e31273cbda50bb9f9636";
    private static final String ANON_AVATAR_ID = "10063";
    @Inject
    public FuncTestRestClient restRule;
    private String adminGravatarSmall;
    private String adminGravatarNormal;
    private String adminGravatarLarge;
    private String fredGravatarSmall;
    private String fredGravatarNormal;
    private String fredGravatarLarge;
    @Inject
    private LocatorFactory locator;

    @Before
    public void setUpTest() {
        String defaultUserAvatar = "mm";
        this.adminGravatarSmall = String.format("https://www.gravatar.com/avatar/%s?d=%s&s=16", ADMIN_MD5, defaultUserAvatar);
        this.adminGravatarNormal = String.format("https://www.gravatar.com/avatar/%s?d=%s&s=24", ADMIN_MD5, defaultUserAvatar);
        this.adminGravatarLarge = String.format("https://www.gravatar.com/avatar/%s?d=%s&s=48", ADMIN_MD5, defaultUserAvatar);
        this.fredGravatarSmall = String.format("https://www.gravatar.com/avatar/%s?d=%s&s=16", FRED_MD5, defaultUserAvatar);
        this.fredGravatarNormal = String.format("https://www.gravatar.com/avatar/%s?d=%s&s=24", FRED_MD5, defaultUserAvatar);
        this.fredGravatarLarge = String.format("https://www.gravatar.com/avatar/%s?d=%s&s=48", FRED_MD5, defaultUserAvatar);
        this.backdoor.generalConfiguration().useGravatars(true);
        this.navigation.login("admin");
    }

    @Test
    public void testGravatarShouldBeDisplayedInUserProfile() throws Exception {
        this.navigation.userProfile().gotoUserProfile("admin");
        CssLocator css = this.locator.css("img.avatar-image");
        Node node = css.getNode();
        NamedNodeMap attributes = node.getAttributes();
        Assert.assertThat((Object)attributes.getNamedItem("src").getTextContent(), (Matcher)CoreMatchers.equalTo((Object)this.adminGravatarLarge));
        Assert.assertThat((Object)this.locator.css("#content > header .aui-avatar img").getNode().getAttributes().getNamedItem("src").getTextContent(), (Matcher)CoreMatchers.equalTo((Object)this.adminGravatarLarge));
    }

    @Test
    public void testGravatarShouldBeDisplayedInIssueComments() throws Exception {
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "an issue");
        this.navigation.issue().addComment(key, "comment 10000");
        Node adminAvatarLink = this.locator.css("#commentauthor_10000_verbose").getNode();
        ArrayList adminAvatarChildClasses = Lists.newArrayList((Object[])adminAvatarLink.getFirstChild().getAttributes().getNamedItem("class").getTextContent().split("\\s+"));
        Node adminAvatarImage = this.locator.css("#commentauthor_10000_verbose img").getNode();
        Assert.assertThat((String)"An AUI avatar is output within the verbose author link", (Object)adminAvatarChildClasses, (Matcher)CoreMatchers.hasItem((Object)"aui-avatar"));
        Assert.assertEquals((Object)adminAvatarImage.getAttributes().getNamedItem("src").getTextContent(), (Object)this.adminGravatarSmall);
        this.navigation.login("fred");
        this.navigation.issue().addComment(key, "comment 10001");
        Node fredAvatarLink = this.locator.css("#commentauthor_10001_concise").getNode();
        ArrayList fredAvatarChildClasses = Lists.newArrayList((Object[])adminAvatarLink.getFirstChild().getAttributes().getNamedItem("class").getTextContent().split("\\s+"));
        Node fredAvatarImage = this.locator.css("#commentauthor_10001_concise img").getNode();
        Assert.assertThat((String)"An AUI avatar is output within the concise author link", (Object)fredAvatarChildClasses, (Matcher)CoreMatchers.hasItem((Object)"aui-avatar"));
        Assert.assertEquals((Object)fredAvatarImage.getAttributes().getNamedItem("src").getTextContent(), (Object)this.fredGravatarSmall);
    }

    @Test
    public void testGravatarShouldBeDisplayedInApplicationHeaderProfileLink() {
        Node adminAvatarLink = this.locator.css("#header-details-user-fullname img").getNode();
        Assert.assertEquals((Object)adminAvatarLink.getAttributes().getNamedItem("src").getTextContent(), (Object)this.adminGravatarNormal);
        this.navigation.login("fred");
        Node fredAvatarLink = this.locator.css("#header-details-user-fullname img").getNode();
        Assert.assertEquals((Object)fredAvatarLink.getAttributes().getNamedItem("src").getTextContent(), (Object)this.fredGravatarNormal);
    }

    @Test
    public void testGravatarShouldBeDisplayedInUserResource() throws Exception {
        UserClient userClient = new UserClient((JIRAEnvironmentData)this.environmentData);
        User fred = userClient.get("fred", new User.Expand[0]);
        Assert.assertThat((Object)fred.avatarUrls, (Matcher)Matchers.hasEntry((Object)"16x16", (Object)this.fredGravatarSmall));
        Assert.assertThat((Object)fred.avatarUrls, (Matcher)Matchers.hasEntry((Object)"24x24", (Object)this.fredGravatarNormal));
        Assert.assertThat((Object)fred.avatarUrls, (Matcher)Matchers.hasEntry((Object)"48x48", (Object)this.fredGravatarLarge));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAvatarServletShouldRedirectToGravatar() throws Exception {
        ClientProperties clientProperties = this.tester.getDialog().getWebClient().getClientProperties();
        boolean redirect = clientProperties.isAutoRedirect();
        clientProperties.setAutoRedirect(false);
        try {
            WebResponse largeAvatarResponse = this.restRule.GET(String.format("secure/useravatar?ownerId=%s", "fred"));
            Assert.assertThat((Object)largeAvatarResponse.getResponseCode(), (Matcher)CoreMatchers.equalTo((Object)302));
            Assert.assertThat((Object)largeAvatarResponse.getHeaderField("Location"), (Matcher)CoreMatchers.equalTo((Object)this.fredGravatarLarge));
            WebResponse smallAvatarResponse = this.restRule.GET(String.format("secure/useravatar?ownerId=%s&size=xsmall", "fred"));
            Assert.assertThat((Object)smallAvatarResponse.getResponseCode(), (Matcher)CoreMatchers.equalTo((Object)302));
            Assert.assertThat((Object)smallAvatarResponse.getHeaderField("Location"), (Matcher)CoreMatchers.equalTo((Object)this.fredGravatarSmall));
            WebResponse normalAvatarResponse = this.restRule.GET(String.format("secure/useravatar?ownerId=%s&size=small", "fred"));
            Assert.assertThat((Object)normalAvatarResponse.getResponseCode(), (Matcher)CoreMatchers.equalTo((Object)302));
            Assert.assertThat((Object)normalAvatarResponse.getHeaderField("Location"), (Matcher)CoreMatchers.equalTo((Object)this.fredGravatarNormal));
            this.navigation.logout();
            WebResponse anonAvatarResponse = this.restRule.GET(String.format("secure/useravatar?ownerId=%s", "fred"));
            Assert.assertThat((Object)anonAvatarResponse.getResponseCode(), (Matcher)CoreMatchers.equalTo((Object)200));
            Assert.assertThat((Object)anonAvatarResponse.getContentType(), (Matcher)Matchers.equalToIgnoringCase((String)"image/png"));
            WebResponse anonAvatarGuaranteedResponse = this.restRule.GET(String.format("secure/useravatar?avatarId=%s", ANON_AVATAR_ID));
            BufferedImage result = ImageIO.read(anonAvatarResponse.getInputStream());
            BufferedImage expected = ImageIO.read(anonAvatarGuaranteedResponse.getInputStream());
            Assert.assertEquals((long)expected.getWidth(), (long)result.getWidth());
            Assert.assertEquals((long)expected.getHeight(), (long)result.getHeight());
            for (int y = 0; y < result.getHeight(); ++y) {
                for (int x = 0; x < result.getWidth(); ++x) {
                    Assert.assertEquals((long)expected.getRGB(x, y), (long)result.getRGB(x, y));
                }
            }
        }
        finally {
            clientProperties.setAutoRedirect(redirect);
        }
    }
}

