/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.Priority;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.google.common.collect.Sets;
import com.meterware.httpunit.HttpUnitOptions;
import java.util.HashSet;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.ISSUES})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestBulkChangeIssues
extends BaseJiraFuncTest {
    private static final String ERROR_NEXT_CHOOSE_ISSUE = "You must select at least one issue to bulk edit.";
    private static final String ERROR_NEXT_CHOOSE_OPERATION = "Please choose an operation from the list below.";
    private static final String ERROR_NEXT_OPERATION_DETAILS = "You must select at least one bulk action to perform";
    private static final String NOTE_NO_VERSIONS = "The project of the selected issue(s) does not have any versions.";
    private static final String NOTE_NO_COMPONENTS = "The project of the selected issue(s) does not have any components.";
    private static final String NOTE_NO_CUSTOM_FIELDS = "There are no available custom fields for the selected issues.";
    private static final int SETUP_ISSUE_COUNT = 11;
    private static final int PAGE_SIZE = 50;
    private static final String MY_OPTION_VERSION_ONE_UNESCAPED = "New Version 1 &trade;";
    private static final String MY_OPTION_COMPONENT_ONE_UNESCAPED = "New Component 1 &trade;";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.produceIssues("HSP", 11);
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    private void produceIssues(String projectKey, int howMany) {
        for (int i = 0; i < howMany; ++i) {
            String summary = Integer.toBinaryString(i);
            if (this.backdoor.issues().createIssue(projectKey, summary).id() != null) continue;
            Assert.fail((String)String.format("Failed at adding issue: '%s' while adding %d out of %d issues.", summary, i + 1, 11));
        }
    }

    @Test
    public void testCheckLabelsSelectAllIssuesMultipleProject() {
        this.logger.log((Object)"Bulk Change - Check Labels: select ALL known issues");
        this.backdoor.issues().createIssue("MKY", "OneIssueFromAnotherProject");
        this.navigation.issueNavigator().displayAllIssues();
        BulkChangeWizard wizard = this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        wizard.selectAllIssues();
        this.checkLabelForStepChooseOperation(12, 2);
        wizard.chooseOperation(BulkChangeWizard.BulkOperationsImpl.EDIT);
        this.checkLabelForStepOperationDetails(12, 2);
        wizard.checkActionForField("assignee").setFieldValue("assignee", "admin").checkActionForField("priority").setFieldValue("priority", "4").finaliseFields();
        this.checkLabelForStepConfirmationEdit(12, 2);
        wizard.revertTo(BulkChangeWizard.WizardState.CHOOSE_OPERATION);
        wizard.chooseOperation(BulkChangeWizard.BulkOperationsImpl.DELETE);
        this.checkLabelForStepConfirmationDelete(12, 2);
    }

    @Test
    public void testXssNonExistentVersionAndComponent() {
        this.logger.log((Object)"Bulk Change - test XSS on reported missing Component and Version.");
        Version version = this.backdoor.versions().create(new Version().name(MY_OPTION_VERSION_ONE_UNESCAPED).description("xss possible here").project("HSP"));
        Component component = this.backdoor.components().create(new Component().name(MY_OPTION_COMPONENT_ONE_UNESCAPED).description("xss possible here").project("HSP"));
        this.navigation.issueNavigator().displayAllIssues();
        BulkChangeWizard wizard = this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues();
        this.checkLabelForStepChooseOperation(11, 1);
        wizard.chooseOperation(BulkChangeWizard.BulkOperationsImpl.EDIT);
        this.checkLabelForStepOperationDetails(11, 1);
        wizard.checkActionForField("fixVersions").setFieldValue("fixVersions", Long.toString(version.id)).checkActionForField("components").setFieldValue("components", Long.toString(component.id)).finaliseFields();
        this.tester.assertTextNotPresent(MY_OPTION_COMPONENT_ONE_UNESCAPED);
        this.tester.assertTextNotPresent(MY_OPTION_VERSION_ONE_UNESCAPED);
        this.checkLabelForStepConfirmationEdit(11, 1);
    }

    @Test
    public void testComponentsAndVersionsNotSelectableInProjectWithoutSuch() {
        this.logger.log((Object)"Bulk Change - Check label & contents: Step Operation Details");
        String tmpProjectKey = "TMP";
        this.backdoor.project().addProject("prj_tmp", "TMP", "admin");
        this.backdoor.issues().createIssue("TMP", "someSummary");
        this.navigation.issueNavigator().runSearch("project = TMP");
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.EDIT);
        this.tester.assertTextPresent(NOTE_NO_VERSIONS);
        this.tester.assertTextPresent(NOTE_NO_COMPONENTS);
        this.tester.assertTextPresent(NOTE_NO_CUSTOM_FIELDS);
        this.tester.assertFormElementNotPresent("fixVersions");
        this.tester.assertFormElementNotPresent("versions");
        this.tester.assertFormElementNotPresent("components");
        this.tester.assertFormElementPresent("assignee");
        this.tester.assertFormElementPresent("priority");
    }

    @Test
    public void testClickNextWithoutFormCompletion() {
        this.logger.log((Object)"Bulk Change - Errors: Click NEXT without form completion");
        this.navigation.issueNavigator().displayAllIssues();
        BulkChangeWizard wizard = this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.tester.submit("Next");
        this.assertErrorNodeWithText(ERROR_NEXT_CHOOSE_ISSUE);
        wizard.selectAllIssues();
        this.tester.submit("Next");
        this.assertErrorNodeWithText(ERROR_NEXT_CHOOSE_OPERATION);
        wizard.chooseOperation(BulkChangeWizard.BulkOperationsImpl.EDIT);
        this.tester.submit("Next");
        this.assertErrorNodeWithText(ERROR_NEXT_OPERATION_DETAILS);
    }

    private void assertErrorNodeWithText(String text) {
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-message.aui-message-error"), text);
    }

    @Test
    public void testCancelLink() {
        this.navigation.issueNavigator().displayAllIssues();
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        Priority priority = this.backdoor.issues().getIssue((String)"HSP-1").fields.priority;
        this.logger.log((Object)"Bulk Change - Navigation: Click CANCEL at step CONFIRMATION EDIT");
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.EDIT).checkActionForField("priority").setFieldValue("priority", "2").finaliseFields().cancel();
        this.tester.assertTextPresent("Issue Navigator");
        Assert.assertEquals((String)"Issue should not have been changed by the cancelled form(s).", (Object)this.backdoor.issues().getIssue((String)"HSP-1").fields.priority, (Object)priority);
        this.logger.log((Object)"Bulk Change - Navigation: Click CANCEL at step OPERATION DETAILS");
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.EDIT).cancel();
        this.tester.assertTextPresent("Issue Navigator");
        this.logger.log((Object)"Bulk Change - Navigation: Click CANCEL at step CHOOSE OPERATION");
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().cancel();
        this.tester.assertTextPresent("Issue Navigator");
        this.logger.log((Object)"Bulk Change - Navigation: Click CANCEL at step CHOOSE ISSUES");
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).cancel();
        this.tester.assertTextPresent("Issue Navigator");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    @Test
    public void testCancelLinkForStepConfirmationDelete() {
        this.navigation.issueNavigator().displayAllIssues();
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.logger.log((Object)"Bulk Change - Navigation: Click CANCEL at step CONFIRM DELETE");
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.DELETE).cancel();
        this.tester.assertTextPresent("Issue Navigator");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        Assert.assertNotNull((String)"Issue should not have been deleted by the cancelled form.", (Object)this.backdoor.issues().getIssue((String)"HSP-1").id);
    }

    @Test
    public void testRevertingToPreviousStagesInWizard() {
        this.navigation.issueNavigator().displayAllIssues();
        BulkChangeWizard wizard = this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.logger.log((Object)"Bulk Change - Navigation: left navigation links: step 1");
        this.assertWizardStepLinks(wizard.getState());
        wizard.selectAllIssues();
        this.logger.log((Object)"Bulk Change - Navigation: left navigation links: step 2");
        this.assertWizardStepLinks(wizard.getState());
        wizard.revertTo(BulkChangeWizard.WizardState.SELECT_ISSUES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.EDIT);
        this.logger.log((Object)"Bulk Change - Navigation: left navigation links: step 3");
        this.assertWizardStepLinks(wizard.getState());
        wizard.revertTo(BulkChangeWizard.WizardState.SELECT_ISSUES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.EDIT);
        wizard.revertTo(BulkChangeWizard.WizardState.CHOOSE_OPERATION).chooseOperation(BulkChangeWizard.BulkOperationsImpl.EDIT).checkActionForField("assignee").setFieldValue("assignee", "admin").finaliseFields();
        this.logger.log((Object)"Bulk Change - Navigation: left navigation links: step 4");
        this.assertWizardStepLinks(wizard.getState());
        wizard.revertTo(BulkChangeWizard.WizardState.SELECT_ISSUES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.EDIT).checkActionForField("assignee").setFieldValue("assignee", "admin").finaliseFields();
        wizard.revertTo(BulkChangeWizard.WizardState.CHOOSE_OPERATION).chooseOperation(BulkChangeWizard.BulkOperationsImpl.EDIT).checkActionForField("assignee").setFieldValue("assignee", "admin").finaliseFields();
        wizard.revertTo(BulkChangeWizard.WizardState.SET_FIELDS).checkActionForField("assignee").setFieldValue("assignee", "admin").finaliseFields();
        this.assertWizardStepLinks(wizard.getState());
    }

    private void assertWizardStepLinks(BulkChangeWizard.WizardState forState) {
        for (BulkChangeWizard.WizardState state : BulkChangeWizard.WizardState.valuesWithLinks()) {
            if (state.getStage() < forState.getStage()) {
                this.logger.log((Object)(state.getLinkText() + " should be a link."));
                this.tester.assertLinkPresentWithText(state.getLinkText());
                continue;
            }
            this.logger.log((Object)(state.getLinkText() + " should not be a link."));
            this.tester.assertLinkNotPresentWithText(state.getLinkText());
        }
    }

    @Test
    public void testCheckIssueContent() {
        String nextPageSummary = "on next page";
        String firstPageSummary = Integer.toBinaryString(49);
        this.produceIssues("MKY", 50);
        this.backdoor.issues().createIssue("MKY", "on next page");
        this.logger.log((Object)"Bulk Change - Issue Content: Check correct issues are displayed, Include CURRENT page from CURRENT page");
        this.navigation.issueNavigator().runSearch(String.format("project = %s order by issuekey", "monkey"));
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.CURRENT_PAGE);
        this.tester.assertLinkNotPresentWithText("on next page");
        this.tester.assertLinkPresentWithText(firstPageSummary);
        this.logger.log((Object)"Bulk Change - Issue Content: Check correct issues are displayed, Include ALL page from NEXT page");
        this.navigation.issueNavigator().runSearch(String.format("project = %s order by issuekey", "monkey"));
        this.navigation.gotoPage(this.navigation.getCurrentPage() + "&startIndex=50");
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.tester.assertLinkPresentWithText("on next page");
        this.tester.assertLinkPresentWithText(firstPageSummary);
        this.logger.log((Object)"Bulk Change - Issue Content: Check correct issues are displayed, Include CURRENT page from NEXT page");
        this.navigation.issueNavigator().runSearch(String.format("project = %s order by issuekey", "monkey"));
        this.navigation.gotoPage(this.navigation.getCurrentPage() + "&startIndex=50");
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.CURRENT_PAGE);
        this.tester.assertLinkPresentWithText("on next page");
        this.tester.assertLinkNotPresentWithText(firstPageSummary);
    }

    private void checkLabelForStepChooseOperation(int numOfSelectedIssues, int numOfSelectedProjects) {
        this.checkSideMenuLabel(numOfSelectedIssues, numOfSelectedProjects);
        this.tester.assertTextPresent("Choose the operation you wish to perform on the selected <strong>" + numOfSelectedIssues + "</strong> issue(s).");
    }

    private void checkLabelForStepOperationDetails(int numOfSelectedIssues, int numOfSelectedProjects) {
        this.checkSideMenuLabel(numOfSelectedIssues, numOfSelectedProjects);
        this.tester.assertTextPresent("Choose the bulk action(s) you wish to perform on the selected <b>" + numOfSelectedIssues + "</b> issue(s).");
    }

    private void checkLabelForStepConfirmationEdit(int numOfSelectedIssues, int numOfSelectedProjects) {
        this.checkSideMenuLabel(numOfSelectedIssues, numOfSelectedProjects);
        String firstOption = String.format("The above table summarises the changes you are about to make to the following <strong>%d</strong> issues. Do you wish to continue?", numOfSelectedIssues);
        String secondOption = String.format("The above table summarizes the changes you are about to make to the following <strong>%d</strong> issues. Do you wish to continue?", numOfSelectedIssues);
        HashSet expectedValues = Sets.newHashSet((Object[])new String[]{firstOption, secondOption});
        String dialogText = this.tester.getDialog().getResponseText();
        boolean matched = expectedValues.stream().anyMatch(option -> dialogText.indexOf((String)option) >= 0);
        if (!matched) {
            Assert.fail((String)String.format("Expected text not found in response: [%s or %s]", firstOption, secondOption));
        }
    }

    private void checkLabelForStepConfirmationDelete(int numOfSelectedIssues, int numOfSelectedProjects) {
        this.checkSideMenuLabel(numOfSelectedIssues, numOfSelectedProjects);
        this.textAssertions.assertTextSequence(this.locator.css("#content .aui-page-panel-content"), "Please confirm that you wish to delete the following", String.valueOf(numOfSelectedIssues), "issues");
    }

    private void checkSideMenuLabel(int numOfSelectedIssues, int numOfSelectedProjects) {
        this.textAssertions.assertTextSequence(this.locator.css(".steps li"), "Selected ", String.valueOf(numOfSelectedIssues), " issues from ", String.valueOf(numOfSelectedProjects), " project(s)");
    }
}

