/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperationProgress;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebTable;
import java.util.Arrays;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS})
@LoginAs(user="admin")
public class TestBulkEditTimeTrackingModern
extends BaseJiraFuncTest {
    private static final String COW_15 = "COW-15";
    private static final String COW_16 = "COW-16";
    private static final String COW_17 = "COW-17";
    private static final String TIMETRACKING_MODULE_ID = "timetrackingmodule_heading";
    private static final String TIMETRACKING_TARGETSUBFIELD = "timetracking_targetsubfield";
    private static final String TIMETRACKING_FIELD = "timetracking";
    private static final String TIMETRACKING_ORIGINALESTIMATE_FIELD = "timetracking_originalestimate";
    private static final String TIMETRACKING_REMAININGESTIMATE_FIELD = "timetracking_remainingestimate";
    private static final String NOT_SPECIFIED = "Not Specified";
    private static final String UPDATE_VALUE = "10h";
    private static final String DISPLAY_VALUE = "1d 2h";
    private static final String TIME_TRACKING_DISPLAY_NAME = "Time Tracking";
    private static final String OPERATION_NAME = "Change to";
    private static final String PAGE_HEADER_SELECTOR = ".aui-page-header-main";
    private static final String COW_15_CHECKBOX = "bulkedit_10020";
    private static final String COW_16_CHECKBOX = "bulkedit_10021";
    private static final String COW_17_CHECKBOX = "bulkedit_10030";
    @Inject
    private BulkOperationProgress bulkOperationProgress;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestBulkEditEnvironment.xml");
        this.administration.backdoor().applicationProperties().setOption("jira.timetracking.estimates.legacy.behaviour", false);
    }

    @Test
    public void testUpdateBothEstimates() {
        this.entryConditions();
        this.navigateToStep3();
        this.tester.checkCheckbox("actions", TIMETRACKING_FIELD);
        this.tester.checkCheckbox(TIMETRACKING_TARGETSUBFIELD, TIMETRACKING_ORIGINALESTIMATE_FIELD);
        this.tester.checkCheckbox(TIMETRACKING_TARGETSUBFIELD, TIMETRACKING_REMAININGESTIMATE_FIELD);
        this.tester.setFormElement(TIMETRACKING_ORIGINALESTIMATE_FIELD, UPDATE_VALUE);
        this.tester.submit("Next");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, PAGE_HEADER_SELECTOR), "Step 4 of 4: Confirmation");
        this.tester.assertTextPresent("Updated Fields");
        WebTable updatedfields = this.tester.getDialog().getWebTableBySummaryOrId("updatedfields");
        Assert.assertEquals((String)"Cell (1, 0) in table 'updatedfields' should be 'Time Tracking'.", (Object)TIME_TRACKING_DISPLAY_NAME, (Object)updatedfields.getCellAsText(1, 0).trim());
        Assert.assertEquals((String)"Cell (1, 1) in table 'updatedfields' should be 'Change to'.", (Object)OPERATION_NAME, (Object)updatedfields.getCellAsText(1, 1).trim());
        Assert.assertThat((String)"Cell (1, 2) in table 'updatedfields' should match 'Original Estimate : 1d 2h Remaining Estimate : 1d 2h'.", (Object)updatedfields.getCellAsText(1, 2).trim(), (Matcher)Matchers.stringContainsInOrder(Arrays.asList("Original Estimate", DISPLAY_VALUE, "Remaining Estimate", DISPLAY_VALUE)));
        this.tester.submit("Confirm");
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().viewIssue(COW_15);
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo(DISPLAY_VALUE, DISPLAY_VALUE, NOT_SPECIFIED);
        this.navigation.issue().viewIssue(COW_16);
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo(DISPLAY_VALUE, DISPLAY_VALUE, NOT_SPECIFIED);
        this.navigation.issue().viewIssue(COW_17);
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo(DISPLAY_VALUE, DISPLAY_VALUE, NOT_SPECIFIED);
    }

    @Test
    public void testUpdateOnlyOriginalEstimate() {
        this.entryConditions();
        this.navigateToStep3();
        this.tester.checkCheckbox("actions", TIMETRACKING_FIELD);
        this.tester.checkCheckbox(TIMETRACKING_TARGETSUBFIELD, TIMETRACKING_ORIGINALESTIMATE_FIELD);
        this.tester.setFormElement(TIMETRACKING_ORIGINALESTIMATE_FIELD, UPDATE_VALUE);
        this.tester.submit("Next");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, PAGE_HEADER_SELECTOR), "Step 4 of 4: Confirmation");
        this.tester.assertTextPresent("Updated Fields");
        WebTable updatedfields = this.tester.getDialog().getWebTableBySummaryOrId("updatedfields");
        Assert.assertEquals((String)"Cell (1, 0) in table 'updatedfields' should be 'Time Tracking'.", (Object)TIME_TRACKING_DISPLAY_NAME, (Object)updatedfields.getCellAsText(1, 0).trim());
        Assert.assertEquals((String)"Cell (1, 1) in table 'updatedfields' should be 'Change to'.", (Object)OPERATION_NAME, (Object)updatedfields.getCellAsText(1, 1).trim());
        Assert.assertThat((String)"Cell (1, 2) in table 'updatedfields' should match 'Original Estimate : 1d 2h'.", (Object)updatedfields.getCellAsText(1, 2).trim(), (Matcher)Matchers.stringContainsInOrder(Arrays.asList("Original Estimate", DISPLAY_VALUE)));
        Assert.assertThat((String)"Cell (1, 2) in table 'updatedfields' should not match 'Remaining Estimate : 1d 2h'.", (Object)updatedfields.getCellAsText(1, 2).trim(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Remaining Estimate")));
        this.tester.submit("Confirm");
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().viewIssue(COW_15);
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo(DISPLAY_VALUE, NOT_SPECIFIED, NOT_SPECIFIED);
        this.navigation.issue().viewIssue(COW_16);
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo(DISPLAY_VALUE, NOT_SPECIFIED, NOT_SPECIFIED);
        this.navigation.issue().viewIssue(COW_17);
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo(DISPLAY_VALUE, NOT_SPECIFIED, NOT_SPECIFIED);
    }

    @Test
    public void testUpdateOnlyRemainingEstimate() {
        this.entryConditions();
        this.navigateToStep3();
        this.tester.checkCheckbox("actions", TIMETRACKING_FIELD);
        this.tester.checkCheckbox(TIMETRACKING_TARGETSUBFIELD, TIMETRACKING_REMAININGESTIMATE_FIELD);
        this.tester.setFormElement(TIMETRACKING_REMAININGESTIMATE_FIELD, UPDATE_VALUE);
        this.tester.submit("Next");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, PAGE_HEADER_SELECTOR), "Step 4 of 4: Confirmation");
        this.tester.assertTextPresent("Updated Fields");
        WebTable updatedfields = this.tester.getDialog().getWebTableBySummaryOrId("updatedfields");
        Assert.assertEquals((String)"Cell (1, 0) in table 'updatedfields' should be 'Time Tracking'.", (Object)TIME_TRACKING_DISPLAY_NAME, (Object)updatedfields.getCellAsText(1, 0).trim());
        Assert.assertEquals((String)"Cell (1, 1) in table 'updatedfields' should be 'Change to'.", (Object)OPERATION_NAME, (Object)updatedfields.getCellAsText(1, 1).trim());
        Assert.assertThat((String)"Cell (1, 2) in table 'updatedfields' should match 'Remaining Estimate : 1d 2h'.", (Object)updatedfields.getCellAsText(1, 2).trim(), (Matcher)Matchers.stringContainsInOrder(Arrays.asList("Remaining Estimate", DISPLAY_VALUE)));
        Assert.assertThat((String)"Cell (1, 2) in table 'updatedfields' should not match 'Original Estimate : 1d 2h'.", (Object)updatedfields.getCellAsText(1, 2).trim(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Original Estimate")));
        this.tester.submit("Confirm");
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().viewIssue(COW_15);
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo(NOT_SPECIFIED, DISPLAY_VALUE, NOT_SPECIFIED);
        this.navigation.issue().viewIssue(COW_16);
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo(NOT_SPECIFIED, DISPLAY_VALUE, NOT_SPECIFIED);
        this.navigation.issue().viewIssue(COW_17);
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo(NOT_SPECIFIED, DISPLAY_VALUE, NOT_SPECIFIED);
    }

    private void entryConditions() {
        this.navigation.issue().viewIssue(COW_15);
        this.tester.assertElementNotPresent(TIMETRACKING_MODULE_ID);
        this.navigation.issue().viewIssue(COW_16);
        this.tester.assertElementNotPresent(TIMETRACKING_MODULE_ID);
        this.navigation.issue().viewIssue(COW_17);
        this.tester.assertElementNotPresent(TIMETRACKING_MODULE_ID);
    }

    private void navigateToStep3() {
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.tester.assertTextPresent("Step 1 of 4: Choose Issues");
        this.tester.checkCheckbox(COW_15_CHECKBOX, "on");
        this.tester.checkCheckbox(COW_16_CHECKBOX, "on");
        this.tester.checkCheckbox(COW_17_CHECKBOX, "on");
        this.tester.submit("Next");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, PAGE_HEADER_SELECTOR), "Step 2 of 4: Choose Operation");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, PAGE_HEADER_SELECTOR), "Step 3 of 4: Operation Details");
        this.tester.assertTextPresent("Change Time Tracking");
        this.tester.assertTextPresent("Change Original Estimate");
        this.tester.assertTextPresent("Change Remaining Estimate");
    }
}

