/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.backdoor.GroupManagerControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.permission.GlobalPermissionKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
public class TestBulkEditUserGroups
extends BaseJiraFuncTest {
    private static final String BULK_EDIT_GROUP_MEMBERS_ERRORS_CONTAINER_LOCATOR = ".aui-message.aui-message-error";
    private static final String ERROR_LEAVING_ALL_ADMIN_GROUPS = "You are trying to leave all of the administration groups jira-administrators. You cannot delete your own administration permission";
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    @Restore(value="TestWithSystemAdmin.xml")
    public void testBulkEditUserGroupsWithNoSysAdminPermRemoveLastAdmin() {
        try {
            this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
            this.tester.clickLink("edit_members_of_jira-administrators");
            this.tester.selectOption("usersToUnassign", "admin");
            this.tester.submit("unassign");
            this.tester.assertTextPresent(ERROR_LEAVING_ALL_ADMIN_GROUPS);
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    @Restore(value="TestWithSystemAdmin.xml")
    public void testBulkEditUserGroupsWithNoSysAdminPermRemoveAdmin() {
        try {
            this.backdoor.usersAndGroups().addGroup("admin-group2");
            this.administration.addGlobalPermission(0, "admin-group2");
            this.backdoor.usersAndGroups().addUserToGroup("admin", "admin-group2");
            this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
            this.tester.clickLink("edit_members_of_jira-administrators");
            this.tester.selectOption("usersToUnassign", "admin");
            this.tester.submit("unassign");
            this.tester.clickLink("view_profile");
            this.tester.assertTextNotPresent("jira-administrators");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.usersAndGroups().addUserToGroup("admin", "jira-administrators");
            this.administration.addGlobalPermission(GlobalPermissionKey.SYSTEM_ADMIN, "jira-administrators");
        }
    }

    @Test
    @Restore(value="TestBulkEditGroupMembers.xml")
    public void testBulkEditUserGroupsInvalidGroups() {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/BulkEditUserGroups.jspa?selectedGroupsStr=invalid&assign=true&usersToAssignStr=admin"));
        this.textAssertions.assertTextPresent(this.locator.css(BULK_EDIT_GROUP_MEMBERS_ERRORS_CONTAINER_LOCATOR), "The group 'invalid' is not a valid group.");
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/BulkEditUserGroups.jspa?selectedGroupsStr=invalid&unassign=true&usersToUnassign=admin"));
        this.textAssertions.assertTextPresent(this.locator.css(BULK_EDIT_GROUP_MEMBERS_ERRORS_CONTAINER_LOCATOR), "The group 'invalid' is not a valid group.");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    @Restore(value="TestWithSystemAdmin.xml")
    public void testFredEditGroups() {
        try {
            this.navigation.login("fred", "fred");
            this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/BulkEditUserGroups.jspa?selectedGroupsStr=jira-sys-admins&assign=true&usersToAssignStr=fred"));
            this.tester.assertTextPresent("my login on this computer");
            this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/BulkEditUserGroups.jspa?selectedGroupsStr=jira-sys-admins&unassign=true&usersToUnassign=root"));
            this.tester.assertTextPresent("my login on this computer");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    @Restore(value="TestWithSystemAdmin.xml")
    public void testBulkEditUserGroupsHappyPathSysAdmin() {
        try {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.backdoor.usersAndGroups().addGroup("sys-admin-group2");
            this.administration.addGlobalPermission(44, "sys-admin-group2");
            this.backdoor.usersAndGroups().addUserToGroup("root", "sys-admin-group2");
            this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
            this.tester.clickLink("edit_members_of_jira-sys-admins");
            this.tester.selectOption("usersToUnassign", "root");
            this.tester.submit("unassign");
            this.navigation.userProfile().gotoCurrentUserProfile();
            this.tester.assertTextNotPresent("jira-sys-admins");
            this.tester.assertTextPresent("sys-admin-group2");
            this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
            this.tester.clickLink("edit_members_of_jira-sys-admins");
            this.tester.setFormElement("usersToAssignStr", "root");
            this.tester.submit("assign");
            this.navigation.userProfile().gotoCurrentUserProfile();
            this.tester.assertTextPresent("jira-sys-admins");
            this.tester.assertTextPresent("sys-admin-group2");
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    @Restore(value="TestWithSystemAdmin.xml")
    public void testBulkEditUserGroupsHappyPathAdmin() {
        try {
            this.backdoor.usersAndGroups().addGroup("admin-group2");
            this.administration.addGlobalPermission(0, "admin-group2");
            this.backdoor.usersAndGroups().addUserToGroup("admin", "admin-group2");
            this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
            this.tester.clickLink("edit_members_of_jira-administrators");
            this.tester.selectOption("usersToUnassign", "admin");
            this.tester.submit("unassign");
            this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
            this.tester.clickLink("editgroups_admin");
            this.tester.assertOptionsEqual("groupsToLeave", new String[]{"admin-group2", "jira-developers", "jira-users"});
            this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
            this.tester.clickLink("edit_members_of_jira-administrators");
            this.tester.setFormElement("usersToAssignStr", "admin");
            this.tester.submit("assign");
            this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
            this.tester.clickLink("editgroups_admin");
            this.tester.assertOptionsEqual("groupsToLeave", new String[]{"admin-group2", "jira-administrators", "jira-developers", "jira-users"});
        }
        finally {
            this.restoreAdminPermission();
        }
    }

    @SinceBuildRule.SinceBuild(buildNumber=807000)
    @Test
    @Restore(value="TestGroupResourceCountUsers.xml")
    public void testGetMembersList() {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/BulkEditUserGroups.jspa?selectedGroupsStr=jira-users"));
        this.tester.assertFormElementPresentWithLabel("21 Group member(s)");
        this.assertGroupMembers(Arrays.asList("DiamondTop", "DiamondBottom"), "Yellow,DiamondBottom", "White,DiamondTop");
        this.assertGroupMembers(Arrays.asList("DiamondBottom", "DiamondTop"), "Yellow,DiamondBottom", "White,DiamondTop");
        this.assertGroupMembers(Collections.singletonList("Wombats"), "Catherine,Wombats", "David,Wombats");
        this.assertGroupMembers(Collections.singletonList("Sealife"), "Anna,Sealife", "David,Sealife");
        this.assertGroupMembers(Arrays.asList("Wombats", "Sealife"), "David", "Anna,Sealife", "Catherine,Wombats");
        this.assertGroupMembers(Arrays.asList("Sealife", "Wombats"), "David", "Anna,Sealife", "Catherine,Wombats");
        this.assertGroupMembers(Arrays.asList("Koalas", "Sealife", "Wombats"), "David", "Anna,Koalas", "Betty,Koalas", "Anna,Sealife", "Catherine,Wombats");
    }

    private void assertGroupMembers(List<String> groupNames, String ... members) {
        String url = "/secure/admin/user/BulkEditUserGroups.jspa?selectedGroupsStr=" + String.join((CharSequence)"&selectedGroupsStr=", groupNames);
        this.tester.gotoPage(this.page.addXsrfToken(url));
        this.tester.assertOptionValuesEqual("usersToUnassign", members);
    }

    @SinceBuildRule.SinceBuild(buildNumber=807000)
    @Test
    @Restore(value="TestGroupResourceCountUsers.xml")
    public void testUserFiltering() {
        GroupManagerControl groupManager = this.backdoor.groupManager();
        Assert.assertThat(groupManager.filterUsersInAllGroupsDirect(Arrays.asList("Bill", "Andie", "Troy"), Arrays.asList("hog", "day")), (Matcher)Matchers.contains((Object[])new String[]{"Bill"}));
        Assert.assertThat(groupManager.filterUsersInAllGroupsDirect(Arrays.asList("Andie", "Troy"), Arrays.asList("hog", "day")), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat(groupManager.filterUsersInAllGroupsDirect(Arrays.asList("Bill", "Andie", "Troy"), Collections.singletonList("day")), (Matcher)Matchers.contains((Object[])new String[]{"Andie", "Bill"}));
        Assert.assertThat(groupManager.filterUsersInAllGroupsDirect(Arrays.asList("Bill", "Andie", "Troy"), Arrays.asList("jira-users", "day")), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(groupManager.filterUsersInAllGroupsDirect(Collections.emptyList(), Arrays.asList("jira-users", "day")), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat(groupManager.filterUsersInAllGroupsDirect(Arrays.asList("Bill", "Andie", "Troy"), Collections.emptyList()), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat(groupManager.filterUsersInAllGroupsDirect(Arrays.asList("David", "Anna", "Betty", "Anna", "Catherine"), Arrays.asList("Koalas", "Sealife", "Wombats")), (Matcher)Matchers.contains((Object[])new String[]{"David"}));
    }

    @SinceBuildRule.SinceBuild(buildNumber=807000)
    @Test
    @Restore(value="TestGroupResourceCountUsers.xml")
    public void testFindingMembers() {
        GroupManagerControl groupManager = this.backdoor.groupManager();
        Assert.assertThat(groupManager.getNamesOfDirectMembersOfGroups(Collections.emptyList(), 100), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat(groupManager.getNamesOfDirectMembersOfGroups(Collections.singletonList("DiamondTop"), 100), (Matcher)Matchers.contains((Object[])new String[]{"White"}));
        Assert.assertThat(groupManager.getNamesOfDirectMembersOfGroups(Collections.singletonList("DiamondBottom"), 100), (Matcher)Matchers.contains((Object[])new String[]{"Yellow"}));
        Assert.assertThat(groupManager.getNamesOfDirectMembersOfGroups(Arrays.asList("DiamondTop", "DiamondBottom"), 100), (Matcher)Matchers.contains((Object[])new String[]{"White", "Yellow"}));
        Assert.assertThat(groupManager.getNamesOfDirectMembersOfGroups(Arrays.asList("Sealife", "Koalas"), 100), (Matcher)Matchers.contains((Object[])new String[]{"Anna", "Betty", "David"}));
        Assert.assertThat(groupManager.getNamesOfDirectMembersOfGroups(Collections.singletonList("jira-users"), 1), (Matcher)Matchers.contains((Object[])new String[]{"Andie"}));
        Assert.assertThat(groupManager.getNamesOfDirectMembersOfGroups(Collections.singletonList("jira-users"), 4), (Matcher)Matchers.contains((Object[])new String[]{"Andie", "Anna", "Betty", "Bill"}));
        Assert.assertThat(groupManager.getNamesOfDirectMembersOfGroups(Collections.singletonList("jira-users"), 8), (Matcher)Matchers.contains((Object[])new String[]{"Andie", "Anna", "Betty", "Bill", "Blue", "Catherine", "David", "Ernie"}));
        Assert.assertThat((Object)groupManager.getNamesOfDirectMembersOfGroups(Collections.singletonList("jira-users"), 100).size(), (Matcher)Matchers.equalTo((Object)21));
        Assert.assertThat(groupManager.getNamesOfDirectMembersOfGroups(Arrays.asList("Koalas", "Sealife", "Wombats"), 100), (Matcher)Matchers.contains((Object[])new String[]{"Anna", "Betty", "Catherine", "David"}));
    }

    private void restoreAdminPermission() {
        this.navigation.logout();
        this.navigation.login("root", "root");
        this.administration.addGlobalPermission(GlobalPermissionKey.SYSTEM_ADMIN, "jira-administrators");
    }
}

