/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.EditIssueFieldVisibility;
import com.atlassian.jira.functest.framework.Indexing;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.ISSUES})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestBulkMoveIssues
extends BaseJiraFuncTest {
    private static final String ERROR_MOVE_PERMISSION = "You do not have the permission to move one or more of the selected issues";
    private static final String HSP1 = "HSP-1";
    private static final String HSP2 = "HSP-2";
    private static final String HSP3 = "HSP-3";
    private static final String HSP4 = "HSP-4";
    private static final String MKY1 = "MKY-1";
    @Inject
    private Indexing indexing;
    @Inject
    private EditIssueFieldVisibility editIssueFieldVisibility;
    private IssueClient issueClient = null;
    private Component hspComponentOne;
    private Component hspComponentTwo;
    private Component hspComponentThree;
    private Version hsp1dot0;
    private Version hsp2dot0;
    private Version hsp3dot0;
    private Version mky1dot0;
    private Version mky1dot1;
    private Version mky1dot2;
    private Component mkyWrench;
    private Component hspWrench;
    @Inject
    private BulkOperations bulkOperations;
    @Inject
    private FuncTestLogger logger;

    @Before
    public void setUp() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.hspComponentOne = this.createComponent("ONE", "component one", "HSP");
        this.hspComponentTwo = this.createComponent("TWO", "component two", "HSP");
        this.hspComponentThree = this.createComponent("THREE", "component three", "HSP");
        this.hspWrench = this.createComponent("wrench", "lowercase", "HSP");
        this.mkyWrench = this.createComponent("WRENCH", "uppercase", "MKY");
        this.hsp1dot0 = this.createVersion("1.0", "one", "HSP");
        this.hsp2dot0 = this.createVersion("2.0", "two", "HSP");
        this.hsp3dot0 = this.createVersion("3.0", "three", "HSP");
        this.mky1dot0 = this.createVersion("1.0", "first", "MKY");
        this.mky1dot1 = this.createVersion("1.1", "second", "MKY");
        this.mky1dot2 = this.createVersion("1.2", "third", "MKY");
    }

    @After
    public void restoreDefaultUserPicker() {
        this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
    }

    @Test
    public void testErrorVisibleWhenOperationNotPermitted() {
        this.logger.log((Object)"Bulk Move - move operation is not available without the move permission");
        this.setupIssues(1);
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.MOVE_ISSUES, "jira-developers");
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues();
        this.tester.assertTextPresent(ERROR_MOVE_PERMISSION);
    }

    @Test
    public void testNavigatorCanShowMovedIssue() {
        this.logger.log((Object)"Bulk Move - navigator can follow changed issue key.");
        this.setupIssues(1);
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll("monkey").finaliseFields().complete();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().gotoIssue(HSP1);
        this.assertions.getViewIssueAssertions().assertOnViewIssuePage(MKY1);
    }

    @Test
    public void testBulkMoveMatchesComponentsOrVersionsWithChangedCase() throws Exception {
        this.logger.log((Object)"Bulk Move - matching fields and remembering decisions for target context");
        this.setupIssues(4);
        this.updateIssue(HSP1, this.hspWrench, this.hsp1dot0);
        this.updateIssue(HSP2, this.hspWrench, this.hsp2dot0);
        this.updateIssue(HSP3, this.hspWrench, this.hsp1dot0, "New Feature");
        this.updateIssue(HSP4, this.hspWrench, this.hsp3dot0, "New Feature");
        this.navigation.issueNavigator().displayAllIssues();
        BulkChangeWizard wizard = this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForEach(2, "monkey");
        this.logger.log((Object)"Bulk Move - checking matched fields for bug type");
        this.tester.assertFormElementEquals(this.targetComponentFieldName(this.hspWrench), "-1");
        this.tester.assertFormElementEquals(this.targetFixVersionName(this.hsp1dot0), this.mky1dot0.id.toString());
        this.tester.assertFormElementEquals(this.targetFixVersionName(this.hsp2dot0), "-1");
        this.tester.assertFormElementNotPresent(this.targetFixVersionName(this.hsp3dot0));
        wizard.setFieldValue(this.targetFixVersionName(this.hsp2dot0), this.mky1dot1.id.toString()).setFieldValue(this.targetComponentFieldName(this.hspWrench), this.mkyWrench.id.toString()).finaliseFields();
        this.logger.log((Object)"Bulk Move - checking matched fields for new feature type");
        this.tester.assertFormElementEquals(this.targetComponentFieldName(this.hspWrench), this.mkyWrench.id.toString());
        this.tester.assertFormElementEquals(this.targetFixVersionName(this.hsp1dot0), this.mky1dot0.id.toString());
        this.tester.assertFormElementNotPresent(this.targetFixVersionName(this.hsp2dot0));
        this.tester.assertFormElementEquals(this.targetFixVersionName(this.hsp3dot0), "-1");
        wizard.setFieldValue(this.targetFixVersionName(this.hsp3dot0), this.mky1dot1.id.toString()).finaliseFields();
        Assert.assertThat((String)"all selections should be accepted.", (Object)((Object)wizard.getState()), (Matcher)Matchers.is((Object)((Object)BulkChangeWizard.WizardState.CONFIRMATION)));
    }

    @Test
    public void testChangeAssigneeWithoutAssignablePermission() {
        this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
        String monkeyGroup = "monkey-users";
        this.backdoor.usersAndGroups().addGroup("monkey-users");
        String monkeyUser = "monkey";
        this.backdoor.usersAndGroups().addUser("monkey");
        this.backdoor.usersAndGroups().addUserToGroup("monkey", "monkey-users");
        this.backdoor.usersAndGroups().addUserToGroup("monkey", "jira-developers");
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
        this.backdoor.usersAndGroups().addUserToGroup("admin", "monkey-users");
        Long monkeyPermissionScheme = this.backdoor.permissionSchemes().copyDefaultScheme("monkey-scheme");
        this.backdoor.permissionSchemes().removeGroupPermission(monkeyPermissionScheme.longValue(), ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
        this.backdoor.permissionSchemes().addGroupPermission(monkeyPermissionScheme, ProjectPermissions.ASSIGNABLE_USER, "monkey-users");
        this.backdoor.project().setPermissionScheme(this.backdoor.project().getProjectId("MKY"), monkeyPermissionScheme);
        this.backdoor.issues().createIssue("HSP", "retain the assignee", "monkey");
        this.backdoor.issues().createIssue("HSP", "change the assignee", "fred");
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll("monkey").checkRetainForField("assignee").finaliseFields().complete();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        String sameAssignee = this.backdoor.issueNavControl().getIssueKeyForSummary("retain the assignee");
        Assert.assertEquals((Object)"monkey", (Object)this.backdoor.issues().getIssue((String)sameAssignee).fields.assignee.name);
        String changedAssignee = this.backdoor.issueNavControl().getIssueKeyForSummary("change the assignee");
        Assert.assertEquals((Object)"admin", (Object)this.backdoor.issues().getIssue((String)changedAssignee).fields.assignee.name);
    }

    @Test
    public void testMoveIssueWithInactiveAssignee() {
        this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
        this.backdoor.usersAndGroups().addUserToGroup("admin", "jira-developers");
        this.backdoor.issues().createIssue("HSP", "admin's issue", "admin");
        this.backdoor.issues().createIssue("HSP", "fred's issue", "fred");
        this.backdoor.userManager().setActive("fred", false);
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll("monkey").finaliseFields().complete();
        String adminsIssue = this.backdoor.issueNavControl().getIssueKeyForSummary("admin's issue");
        Assert.assertEquals((Object)"admin", (Object)this.backdoor.issues().getIssue((String)adminsIssue).fields.assignee.name);
        String fredsIssue = this.backdoor.issueNavControl().getIssueKeyForSummary("fred's issue");
        Assert.assertEquals((Object)"fred", (Object)this.backdoor.issues().getIssue((String)fredsIssue).fields.assignee.name);
    }

    @Test
    public void testMoveSTDComponentsAndVersionsRequiredFailure() {
        this.logger.log((Object)"Bulk Move - STD - components and versions required - failure");
        this.setupIssues(2);
        this.backdoor.versions().delete(this.mky1dot0.id.toString());
        this.backdoor.versions().delete(this.mky1dot1.id.toString());
        this.backdoor.versions().delete(this.mky1dot2.id.toString());
        this.backdoor.components().delete(this.mkyWrench.id.toString());
        this.editIssueFieldVisibility.setRequiredFields();
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll("monkey").finaliseFields();
        this.tester.assertTextPresent("&quot;Component/s&quot; field is required and the project &quot;monkey&quot; does not have any components");
        this.tester.assertTextPresent("&quot;Fix Version/s&quot; field is required and the project &quot;monkey&quot; does not have any versions");
        this.tester.assertTextPresent("&quot;Affects Version/s&quot; field is required and the project &quot;monkey&quot; does not have any versions");
    }

    @Test
    public void testDontRetainRequiredComponentAndVersions() {
        this.logger.log((Object)"Bulk Move - STD - No retain, components and versions Required, Select new values");
        this.backdoor.issues().createIssue("HSP", "issue that stays 1");
        this.backdoor.issues().createIssue("HSP", "issue that stays 2");
        this.backdoor.issues().createIssue("MKY", "issue to move");
        this.updateIssue(HSP1, this.hspComponentOne, this.hsp2dot0);
        this.updateIssue(HSP2, this.hspComponentTwo, this.hsp3dot0);
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)HSP1, (Object)"component", (Object)this.hspComponentOne.name, (Object)"fixVersion", (Object)this.hsp2dot0.name), null, HSP1);
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)HSP2, (Object)"component", (Object)this.hspComponentTwo.name, (Object)"fixVersion", (Object)this.hsp3dot0.name), null, HSP2);
        this.editIssueFieldVisibility.setRequiredFields();
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll("homosapien").setFieldValue(this.targetFieldName("components", "-1"), this.hspComponentThree.id.toString()).setFieldValue(this.targetFieldName("fixVersions", "-1"), this.hsp1dot0.id.toString()).finaliseFields().complete();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().gotoIssue(HSP1);
        this.assertions.getViewIssueAssertions().assertComponents(this.hspComponentOne.name);
        this.assertions.getViewIssueAssertions().assertFixVersions(this.hsp2dot0.name);
        this.assertions.getViewIssueAssertions().assertAffectsVersions("New Version 1");
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)HSP1, (Object)"component", (Object)this.hspComponentOne.name, (Object)"fixVersion", (Object)this.hsp2dot0.name, (Object)"version", (Object)"New Version 1"), null, HSP1);
        this.navigation.issue().gotoIssue(HSP2);
        this.assertions.getViewIssueAssertions().assertComponents(this.hspComponentTwo.name);
        this.assertions.getViewIssueAssertions().assertFixVersions(this.hsp3dot0.name);
        this.assertions.getViewIssueAssertions().assertAffectsVersions("New Version 1");
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)HSP2, (Object)"component", (Object)this.hspComponentTwo.name, (Object)"fixVersion", (Object)this.hsp3dot0.name, (Object)"version", (Object)"New Version 1"), null, HSP2);
        this.navigation.issue().gotoIssue(MKY1);
        this.tester.assertLinkPresentWithText("homosapien");
        this.tester.assertLinkNotPresentWithText("monkey");
        this.assertions.getViewIssueAssertions().assertComponents(this.hspComponentThree.name);
        this.assertions.getViewIssueAssertions().assertFixVersions(this.hsp1dot0.name);
        this.assertions.getViewIssueAssertions().assertAffectsVersions("New Version 1");
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"key", (Object)HSP3, (Object)"component", (Object)this.hspComponentThree.name, (Object)"fixVersion", (Object)this.hsp1dot0.name, (Object)"version", (Object)"New Version 1"), null, HSP3);
    }

    @Test
    public void testDontRetainNotRequiredComponentAndVersions() {
        this.logger.log((Object)"Bulk Move - STD - Dont Retain, components and versions Not Required, Select new values");
        this.backdoor.issues().createIssue("HSP", "issue to move 1");
        this.backdoor.issues().createIssue("HSP", "issue to move 2");
        this.backdoor.issues().createIssue("MKY", "issue that stays");
        this.updateIssue(HSP1, this.hspComponentOne, this.hsp2dot0);
        this.updateIssue(HSP2, this.hspComponentTwo, this.hsp3dot0);
        this.updateIssue(MKY1, this.mkyWrench, this.mky1dot1);
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll("monkey").setFieldValue(this.targetComponentFieldName(this.hspComponentOne), this.mkyWrench.id.toString()).setFieldValue(this.targetFixVersionName(this.hsp2dot0), this.mky1dot2.id.toString()).finaliseFields().complete();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().gotoIssue(MKY1);
        this.assertions.getViewIssueAssertions().assertComponents(this.mkyWrench.name);
        this.assertions.getViewIssueAssertions().assertFixVersions(this.mky1dot1.name);
        this.navigation.issue().gotoIssue(HSP1);
        this.tester.assertLinkNotPresentWithText("homosapien");
        this.tester.assertLinkPresentWithText("monkey");
        this.assertions.getViewIssueAssertions().assertComponents(this.mkyWrench.name);
        this.assertions.getViewIssueAssertions().assertFixVersions(this.mky1dot2.name);
        this.navigation.issue().gotoIssue(HSP2);
        this.tester.assertLinkNotPresentWithText("homosapien");
        this.tester.assertLinkPresentWithText("monkey");
        this.assertions.getViewIssueAssertions().assertComponentsNone();
        this.assertions.getViewIssueAssertions().assertFixVersionsNone();
    }

    @Test
    public void testDontRetainNotRequiredNotSelectedComponentAndVersions() {
        this.logger.log((Object)"Bulk Move - STD - Dont Retain, components and versions Not Required, Dont Select new values");
        this.backdoor.issues().createIssue("HSP", "issue to move 1");
        this.backdoor.issues().createIssue("HSP", "issue to move 2");
        this.backdoor.issues().createIssue("MKY", "issue that stays");
        this.updateIssue(HSP1, this.hspComponentOne, this.hsp2dot0);
        this.updateIssue(HSP2, this.hspComponentTwo, this.hsp3dot0);
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll("monkey").finaliseFields().complete();
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().gotoIssue(MKY1);
        this.assertions.getViewIssueAssertions().assertComponentsNone();
        this.assertions.getViewIssueAssertions().assertFixVersionsNone();
        this.navigation.issue().gotoIssue(HSP1);
        this.tester.assertLinkNotPresentWithText("homosapien");
        this.tester.assertLinkPresentWithText("monkey");
        this.assertions.getViewIssueAssertions().assertComponentsNone();
        this.assertions.getViewIssueAssertions().assertFixVersionsNone();
        this.navigation.issue().gotoIssue(HSP2);
        this.tester.assertLinkNotPresentWithText("homosapien");
        this.tester.assertLinkPresentWithText("monkey");
        this.assertions.getViewIssueAssertions().assertComponentsNone();
        this.assertions.getViewIssueAssertions().assertFixVersionsNone();
    }

    private void setupIssues(int howMany) {
        for (int i = 0; i < howMany; ++i) {
            String summary = Integer.toBinaryString(i);
            Assert.assertNotNull((Object)this.backdoor.issues().createIssue((String)"HSP", (String)summary).id);
        }
    }

    private String targetComponentFieldName(Component forComponent) {
        return this.targetFieldName("components", forComponent.id.toString());
    }

    private String targetFixVersionName(Version forVersion) {
        return this.targetFieldName("fixVersions", forVersion.id.toString());
    }

    private String targetFieldName(String fieldTypeName, String id) {
        return StringUtils.join((Object[])new String[]{fieldTypeName, id}, (String)"_");
    }

    private Version createVersion(String name, String description, String project) {
        return this.backdoor.versions().create(new Version().name(name).description(description).project(project));
    }

    private Component createComponent(String name, String description, String projectKey) {
        return this.backdoor.components().create(new Component().name(name).description(description).project(projectKey));
    }

    private void updateIssue(String issueKey, Component component, Version version) {
        this.updateIssue(issueKey, component, version, null);
    }

    private void updateIssue(String issueKey, Component component, Version version, String issueType) {
        IssueFields fields = new IssueFields().fixVersions(new ResourceRef[]{ResourceRef.withId((String)version.id.toString())}).components(new ResourceRef[]{ResourceRef.withId((String)component.id.toString())});
        if (issueType != null) {
            fields.issueType(ResourceRef.withName((String)issueType));
        }
        this.issueClient.update(issueKey, new IssueUpdateRequest().fields(fields));
    }
}

