/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperationProgress;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING, Category.WORKLOGS})
@LoginAs(user="admin")
public class TestBulkMoveTimeTracking
extends BaseJiraFuncTest {
    @Inject
    private BulkOperationProgress bulkOperationProgress;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestTimeTrackingBulkMove.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testValidationInModernMode() throws Exception {
        this.administration.fieldConfigurations().defaultFieldConfiguration().requireField("Log Work");
        BulkChangeWizard wizard = this.bulkMoveAllIssuesToProject("monkey");
        this.textAssertions.assertTextNotPresent(new WebPageLocator(this.tester), "Log Work");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "Time Tracking");
        wizard.finaliseFields();
        WebPageLocator pageLocator = new WebPageLocator(this.tester);
        this.textAssertions.assertTextPresent(pageLocator, "Original Estimate is required");
        this.textAssertions.assertTextPresent(pageLocator, "Remaining Estimate is required");
        wizard.setFieldValue("timetracking_originalestimate", "xxx").setFieldValue("timetracking_remainingestimate", "6h").finaliseFields();
        pageLocator = new WebPageLocator(this.tester);
        this.textAssertions.assertTextPresent(pageLocator, "The original estimate specified is not valid.");
        this.textAssertions.assertTextNotPresent(pageLocator, "The remaining estimate specified is not valid.");
        wizard.setFieldValue("timetracking_originalestimate", "6h").setFieldValue("timetracking_remainingestimate", "xxx").finaliseFields();
        pageLocator = new WebPageLocator(this.tester);
        this.textAssertions.assertTextNotPresent(pageLocator, "The original estimate specified is not valid.");
        this.textAssertions.assertTextPresent(pageLocator, "The remaining estimate specified is not valid.");
    }

    @Test
    public void testValidationInLegacyMode() throws Exception {
        this.administration.timeTracking().switchMode(TimeTracking.Mode.LEGACY);
        BulkChangeWizard wizard = this.bulkMoveAllIssuesToProject("monkey");
        wizard.finaliseFields();
        WebPageLocator pageLocator = new WebPageLocator(this.tester);
        this.textAssertions.assertTextPresent(pageLocator, "Time Tracking is required.");
        wizard.setFieldValue("timetracking", "xxx").finaliseFields();
        pageLocator = new WebPageLocator(this.tester);
        this.textAssertions.assertAtLeastOneTextPresent(pageLocator, "The original estimate specified is not valid.", "The remaining estimate specified is not valid.");
    }

    @Test
    public void testOnlyOriginalEstimateSpecifiedNoRetainInModernMode() throws Exception {
        this.bulkMoveAllIssuesToProject("monkey").setFieldValue("timetracking_originalestimate", "6h").finaliseFields().complete();
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.tester.clickLinkWithText("Issue 1");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("6h", "6h", "3d");
        this.navigation.issue().returnToSearch();
        this.tester.clickLinkWithText("Issue to move with no Time Tracking");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("6h", "6h", "Not Specified");
    }

    @Test
    public void testOnlyOriginalEstimateSpecifiedRetainCheckedInModernMode() throws Exception {
        this.bulkMoveAllIssuesToProject("monkey").setFieldValue("timetracking_originalestimate", "6h").checkRetainForField("timetracking").finaliseFields().complete();
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.tester.clickLinkWithText("Issue 1");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("1w", "1d", "3d");
        this.navigation.issue().returnToSearch();
        this.tester.clickLinkWithText("Issue to move with no Time Tracking");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("6h", "6h", "Not Specified");
    }

    @Test
    public void testOnlyRemainingEstimateSpecifiedNoRetainInModernMode() throws Exception {
        this.bulkMoveAllIssuesToProject("monkey").setFieldValue("timetracking_remainingestimate", "3h").finaliseFields().complete();
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.tester.clickLinkWithText("Issue 1");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("3h", "3h", "3d");
        this.navigation.issue().returnToSearch();
        this.tester.clickLinkWithText("Issue to move with no Time Tracking");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("3h", "3h", "Not Specified");
    }

    @Test
    public void testOnlyRemainingEstimateSpecifiedRetainCheckedInModernMode() throws Exception {
        this.bulkMoveAllIssuesToProject("monkey").setFieldValue("timetracking_remainingestimate", "3h").checkRetainForField("timetracking").finaliseFields().complete();
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.tester.clickLinkWithText("Issue 1");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("1w", "1d", "3d");
        this.navigation.issue().returnToSearch();
        this.tester.clickLinkWithText("Issue to move with no Time Tracking");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("3h", "3h", "Not Specified");
    }

    @Test
    public void testBothSpecifiedNoRetainInModernMode() throws Exception {
        this.bulkMoveAllIssuesToProject("monkey").setFieldValue("timetracking_originalestimate", "4h").setFieldValue("timetracking_remainingestimate", "2h").finaliseFields().complete();
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.tester.clickLinkWithText("Issue 1");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("4h", "2h", "3d");
        this.navigation.issue().returnToSearch();
        this.tester.clickLinkWithText("Issue to move with no Time Tracking");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("4h", "2h", "Not Specified");
    }

    @Test
    public void testBothSpecifiedRetainCheckedInModernMode() throws Exception {
        this.bulkMoveAllIssuesToProject("monkey").setFieldValue("timetracking_originalestimate", "4h").setFieldValue("timetracking_remainingestimate", "2h").checkRetainForField("timetracking").finaliseFields().complete();
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.tester.clickLinkWithText("Issue 1");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("1w", "1d", "3d");
        this.navigation.issue().returnToSearch();
        this.tester.clickLinkWithText("Issue to move with no Time Tracking");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("4h", "2h", "Not Specified");
    }

    @Test
    public void testEstimateSpecifiedNoRetainInLegacyMode() throws Exception {
        this.administration.timeTracking().switchMode(TimeTracking.Mode.LEGACY);
        this.bulkMoveAllIssuesToProject("monkey").setFieldValue("timetracking", "1h").finaliseFields().complete();
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.tester.clickLinkWithText("Issue 1");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("1w", "1h", "3d");
        this.navigation.issue().returnToSearch();
        this.tester.clickLinkWithText("Issue to move with no Time Tracking");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("1h", "1h", "Not Specified");
    }

    @Test
    public void testEstimateSpecifiedRetainCheckedInLegacyMode() throws Exception {
        this.administration.timeTracking().switchMode(TimeTracking.Mode.LEGACY);
        this.bulkMoveAllIssuesToProject("monkey").setFieldValue("timetracking", "1h").checkRetainForField("timetracking").finaliseFields().complete();
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.tester.clickLinkWithText("Issue 1");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("1w", "1d", "3d");
        this.navigation.issue().returnToSearch();
        this.tester.clickLinkWithText("Issue to move with no Time Tracking");
        this.assertions.getViewIssueAssertions().assertTimeTrackingInfo("1h", "1h", "Not Specified");
    }

    private BulkChangeWizard bulkMoveAllIssuesToProject(String projectName) {
        this.navigation.issueNavigator().displayAllIssues();
        return this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES).selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.MOVE).chooseTargetContextForAll(projectName);
    }
}

