/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.HttpUnitConfiguration;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.FIELDS})
@HttpUnitConfiguration(enableScripting=true)
@Restore(value="TestBulkOperationCustomField.xml")
@LoginAs(user="admin")
public class TestBulkOperationCustomField
extends BaseJiraFuncTest {
    private static final String TABLE_EDITFIELDS_ID = "screen-tab-1-editfields";
    private static final String CHANGE_CF_FOR_PROJECT_A = "Change CF for project A";
    private static final String CHANGE_CF_FOR_PROJECT_B = "Change CF for project B";
    private static final String FIELD_NOT_AVAILABLE = "The field is not available for all issues with the same configuration.";
    private static final String TABLE_UNAVAILABLE_ACTIONS_ID = "unavailableActionsTable";
    @Inject
    private BulkOperations bulkOperations;

    @Test
    public void testBulkEdit() {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.selectAllIssuesToEdit();
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.assertRadioOptionSelected("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextNotInElement(TABLE_UNAVAILABLE_ACTIONS_ID, CHANGE_CF_FOR_PROJECT_A);
        this.tester.assertTextNotInElement(TABLE_UNAVAILABLE_ACTIONS_ID, CHANGE_CF_FOR_PROJECT_B);
        this.tester.assertTextNotInElement(TABLE_UNAVAILABLE_ACTIONS_ID, FIELD_NOT_AVAILABLE);
    }

    private void selectAllIssuesToEdit() {
        String[] parameterNames;
        this.tester.setWorkingForm("bulkedit");
        WebForm form = this.tester.getDialog().getForm();
        for (String name : parameterNames = form.getParameterNames()) {
            if (!name.startsWith("bulkedit_")) continue;
            this.tester.checkCheckbox(name);
        }
    }

    @Test
    public void testBulkTransition() {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.selectAllIssuesToEdit();
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.tester.assertRadioOptionSelected("operation", "bulk.workflowtransition.operation.name");
        this.tester.submit("Next");
        this.tester.checkCheckbox("wftransition", "classic default workflow_5_5");
        this.tester.submit("Next");
        try {
            WebTable editFieldsTable = this.tester.getDialog().getResponse().getTableWithID(TABLE_EDITFIELDS_ID);
            this.tester.assertTextInTable(TABLE_EDITFIELDS_ID, CHANGE_CF_FOR_PROJECT_A);
            this.tester.assertTextInTable(TABLE_EDITFIELDS_ID, CHANGE_CF_FOR_PROJECT_B);
            this.tester.assertTextInTable(TABLE_EDITFIELDS_ID, FIELD_NOT_AVAILABLE);
            for (int i = 0; i < editFieldsTable.getRowCount(); ++i) {
                String field = editFieldsTable.getCellAsText(i, 1).trim();
                if (field.equals(CHANGE_CF_FOR_PROJECT_A)) {
                    Assert.assertTrue((boolean)editFieldsTable.getCellAsText(i, 2).trim().contains(FIELD_NOT_AVAILABLE));
                    continue;
                }
                if (!field.equals(CHANGE_CF_FOR_PROJECT_B)) continue;
                Assert.assertTrue((boolean)editFieldsTable.getCellAsText(i, 2).trim().contains(FIELD_NOT_AVAILABLE));
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }
}

