/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.Lists;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.ISSUE_NAVIGATOR, Category.ISSUES})
@RestoreOnce(value="TestBulkOperationIssueNavigator.xml")
@LoginAs(user="admin")
public class TestBulkOperationIssueNavigator
extends BaseJiraFuncTest {
    @Before
    public void setUp() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testUnsavedFilter() {
        this.navigation.issueNavigator().displayAllIssues();
        this.assertColumnsInBulkWizard("T", "Key", "Summary", "Assignee", "Reporter", "Status", "Resolution", "Created", "Updated");
    }

    @Test
    public void testCustomFilterCustomColumns() {
        this.navigation.issueNavigator().loadFilterAndAssert(10011L);
        this.assertColumnsInBulkWizard("T", "Key", "Summary");
    }

    @Test
    public void testCustomFilterStandardColumns() {
        this.navigation.issueNavigator().loadFilterAndAssert(10010L);
        this.assertColumnsInBulkWizard("T", "Key", "Summary", "Assignee", "Reporter", "Status", "Resolution", "Created", "Updated");
    }

    private void assertColumnsInBulkWizard(String ... headerRow) {
        this.assertions.getTableAssertions().assertTableContainsRow(this.getWebTableWithID("issuetable"), headerRow);
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        ArrayList list = Lists.newArrayList();
        list.add(null);
        list.addAll(Arrays.asList(headerRow));
        this.assertions.getTableAssertions().assertTableContainsRow(this.getWebTableWithID("issuetable"), list.toArray(new String[list.size()]));
        this.tester.checkCheckbox("bulkedit_10030", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.checkCheckbox("actions", "comment");
        this.tester.setFormElement("comment", "Test");
        this.tester.submit("Next");
        this.assertions.getTableAssertions().assertTableContainsRow(this.getWebTableWithID("issuetable"), headerRow);
    }

    private WebTable getWebTableWithID(String id) {
        return this.tester.getDialog().getWebTableBySummaryOrId(id);
    }
}

