/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.net.URL;
import java.net.URLEncoder;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.ISSUES})
@LoginAs(user="admin")
public class TestBulkOperationRedirections
extends BaseJiraFuncTest {
    private static final int HSP_2_ID = 10020;
    private String returnUrl;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestBulkEditIssues.xml");
        this.returnUrl = "/secure/AboutPage.jspa";
    }

    @Test
    public void testFlowForBulkMigrateWithRedirect() throws Exception {
        this.gotoPageWithReturnUrl("/views/bulkedit/BulkMigrateDetails.jspa?singleIssueId=10020");
        this.getTester().assertSubmitButtonPresent("Next");
        this.getTester().assertLinkPresent("cancel");
        this.getTester().clickLink("cancel");
        this.assertAtPage(this.returnUrl);
        this.gotoPageWithReturnUrl("/views/bulkedit/BulkMigrateDetails.jspa?singleIssueId=10020");
        this.getTester().submit("Next");
        this.assertNotAtPage(this.returnUrl);
        this.assertAtPage("BulkMigrateSetFields!default.jspa");
        this.getTester().assertSubmitButtonPresent("Next");
        this.getTester().assertLinkPresent("cancel");
        this.getTester().clickLink("cancel");
        this.assertAtPage(this.returnUrl);
    }

    private void gotoPageWithReturnUrl(String url) throws Exception {
        this.getTester().gotoPage(url + "&returnUrl=" + URLEncoder.encode(this.returnUrl, "UTF-8"));
    }

    private void assertAtPage(String page) {
        this.getAssertions().getTextAssertions().assertTextPresent(this.getUrl().getPath(), page);
    }

    private void assertNotAtPage(String page) {
        this.getAssertions().getTextAssertions().assertTextNotPresent(this.getUrl().getPath(), page);
    }

    private URL getUrl() {
        return this.getTester().getDialog().getResponse().getURL();
    }
}

