/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS})
@Restore(value="TestBulkOperationsIndexing.xml")
@LoginAs(user="admin")
public class TestBulkOperationsIndexing
extends BaseJiraFuncTest {
    @Inject
    private BulkOperations bulkOperations;

    @Test
    public void testBulkEditIndexing() {
        this.findAndVerifyIssuesArePresent(false);
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.tester.checkCheckbox("bulkedit_10003", "on");
        this.tester.checkCheckbox("bulkedit_10002", "on");
        this.tester.checkCheckbox("bulkedit_10001", "on");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.checkCheckbox("actions", "comment");
        this.tester.setFormElement("comment", "whatsminesay");
        this.tester.submit("Next");
        this.tester.submit("Confirm");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issueNavigator().createSearch("comment~whatsminesay");
        this.tester.assertTextPresent("HSP-1");
        this.tester.assertTextPresent("HSP-2");
        this.tester.assertTextPresent("Test issue 1");
        this.tester.assertTextPresent("Test Issue 2");
        this.tester.assertTextPresent("HSP-3");
        this.tester.assertTextPresent("HSP-4");
        this.tester.assertTextPresent("Subtask 1");
        this.tester.assertTextPresent("Subtask 2");
    }

    @Test
    public void testBulkMoveIndexing() {
        this.findAndVerifyIssuesArePresent(true);
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.tester.checkCheckbox("bulkedit_10003", "on");
        this.tester.checkCheckbox("bulkedit_10002", "on");
        this.tester.checkCheckbox("bulkedit_10001", "on");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.checkCheckbox("bulkedit_10010", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.navigation.issue().selectProject("monkey", "10010_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issueNavigator().createSearch("project=monkey");
        this.tester.assertTextPresent("MKY-1");
        this.tester.assertTextPresent("MKY-2");
        this.tester.assertTextPresent("MKY-3");
        this.tester.assertTextPresent("Test issue 1");
        this.tester.assertTextPresent("Test Issue 2");
        this.tester.assertTextPresent("MKY-4");
        this.tester.assertTextPresent("MKY-5");
        this.tester.assertTextPresent("Subtask 1");
        this.tester.assertTextPresent("Subtask 2");
        this.tester.assertTextPresent("Test Monkey Issue 1");
        this.navigation.issueNavigator().createSearch("project=homosapian");
        this.assertions.assertNodeByIdDoesNotExist("issuetable");
    }

    @Test
    public void testBulkWorkflowTransitionIndexing() {
        this.findAndVerifyIssuesArePresent(true);
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.tester.checkCheckbox("bulkedit_10003", "on");
        this.tester.checkCheckbox("bulkedit_10002", "on");
        this.tester.checkCheckbox("bulkedit_10001", "on");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.checkCheckbox("bulkedit_10010", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.tester.submit("Next");
        this.tester.checkCheckbox("wftransition", "classic default workflow_5_5");
        this.tester.submit("Next");
        this.tester.selectOption("resolution", "Fixed");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issueNavigator().createSearch("resolution=Fixed AND status = Resolved");
        this.tester.assertTextPresent("HSP-1");
        this.tester.assertTextPresent("HSP-2");
        this.tester.assertTextPresent("Test issue 1");
        this.tester.assertTextPresent("Test Issue 2");
        this.tester.assertTextPresent("HSP-3");
        this.tester.assertTextPresent("HSP-4");
        this.tester.assertTextPresent("Subtask 1");
        this.tester.assertTextPresent("Subtask 2");
        this.tester.assertTextPresent("MKY-1");
        this.tester.assertTextPresent("Test Monkey Issue 1");
    }

    private void findAndVerifyIssuesArePresent(boolean all) {
        if (!all) {
            this.navigation.issueNavigator().createSearch("project=homosapien");
        } else {
            this.navigation.issueNavigator().displayAllIssues();
        }
        this.tester.assertTextPresent("HSP-1");
        this.tester.assertTextPresent("HSP-2");
        this.tester.assertTextPresent("Test issue 1");
        this.tester.assertTextPresent("Test Issue 2");
        this.tester.assertTextPresent("HSP-3");
        this.tester.assertTextPresent("HSP-4");
        this.tester.assertTextPresent("Subtask 1");
        this.tester.assertTextPresent("Subtask 2");
        if (all) {
            this.tester.assertTextPresent("MKY-1");
            this.tester.assertTextPresent("Test Monkey Issue 1");
        }
    }
}

