/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS})
@LoginAs(user="admin")
public class TestBulkTransition
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testBulkTransitionDuplicateWorkflows() {
        this.administration.restoreData("TestBulkTransitionDuplicateWorkflows.xml");
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.checkCheckbox("bulkedit_10001", "on");
        this.tester.checkCheckbox("bulkedit_10002", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.tester.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.tester.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.tester.assertTextPresent("Step 2 of 4: Choose Operation");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Step 3 of 4: Operation Details");
        this.tester.assertTextPresent("Select the workflow transition to execute on the associated issues.");
        this.textAssertions.assertTextPresentNumOccurences("Workflow: classic default workflow", 1);
    }
}

