/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.EditIssueFieldVisibility;
import com.atlassian.jira.functest.framework.Indexing;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.SessionFactory;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BULK_OPERATIONS, Category.WORKFLOW})
@LoginAs(user="admin")
public class TestBulkWorkflowTransition
extends BaseJiraFuncTest {
    private static final String NOT_AVAILABLE_BULK_EDIT = "NOTE: This field is not available for bulk update operations.";
    private static final String WORKFLOW_TRANSITION_CHOOSE_ERROR_TEXT = "Please select a transition to execute";
    private static final String WORKFLOW_TRANSITION_EDIT_TEXT = "Select and edit the fields available on this transition.";
    private static final String WORKFLOW_TRANSITION_MULTI_PROJECT_ERROR = "NOTE: This operation can be performed only on issues from ONE project.";
    private static final String WORKFLOW_TRANSITION_SELECTION_TEXT = "Select the workflow transition to execute on the associated issues";
    private static final String COMMENT_1 = "This issue is resolved now.";
    private static final String COMMENT_2 = "Viewable by developers group.";
    private static final String COMMENT_3 = "Viewable by Developers role.";
    private static final String TABLE_EDITFIELDS_ID = "screen-tab-1-editfields";
    @Inject
    protected TextAssertions textAssertions;
    @Inject
    private Indexing indexing;
    @Inject
    private EditIssueFieldVisibility editIssueFieldVisibility;
    @Inject
    private BulkOperations bulkOperations;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private SessionFactory sessionFactory;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUp() {
        this.backdoor.darkFeatures().enableForSite("jira.no.frother.userpicker.field");
        this.backdoor.darkFeatures().enableForSite(JiraFeatureFlagRegistrar.NO_FROTHER_MULTIUSERPICKER.featureKey());
    }

    @After
    public void tearDown() {
        this.backdoor.darkFeatures().disableForSite("jira.no.frother.reporter.field");
        this.backdoor.darkFeatures().disableForSite("jira.no.frother.userpicker.field");
        this.backdoor.darkFeatures().disableForSite(JiraFeatureFlagRegistrar.NO_FROTHER_MULTIUSERPICKER.featureKey());
        this.navigation.login("admin", "admin");
        this.administration.removeGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
    }

    @Test
    @RestoreBlankInstance
    public void testBulkTransitionSessionTimeouts() {
        this.logger.log((Object)"Bulk Transition - Test that you get redirected to the session timeout page when jumping into the wizard");
        this.tester.beginAt("secure/views/bulkedit/BulkWorkflowTransitionDetails.jspa");
        this.verifyAtSessionTimeoutPage();
        this.tester.beginAt("secure/views/bulkedit/BulkWorkflowTransitionEditValidation.jspa");
        this.verifyAtSessionTimeoutPage();
    }

    @Test
    @Restore(value="TestBulkWorkflowTransition.xml")
    public void testNotAvailableFields() {
        this.administration.addGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
        this._testToOperationDetailsWorkflowTranisition();
        this.navigation.workflows().chooseWorkflowAction("classic default workflow_2_6");
        this.tester.assertTextPresent(WORKFLOW_TRANSITION_EDIT_TEXT);
        this.tester.assertTableRowsEqual(TABLE_EDITFIELDS_ID, 14, (String[][])new String[][]{{"N/A", "Change Attachment", NOT_AVAILABLE_BULK_EDIT}});
        this.tester.assertTableRowsEqual(TABLE_EDITFIELDS_ID, 25, (String[][])new String[][]{{"N/A", "Change Summary", NOT_AVAILABLE_BULK_EDIT}});
        this.tester.assertTableRowsEqual(TABLE_EDITFIELDS_ID, 1, (String[][])new String[][]{{"N/A", "Change Fix Version/s", WORKFLOW_TRANSITION_MULTI_PROJECT_ERROR}});
        this.tester.assertTableRowsEqual(TABLE_EDITFIELDS_ID, 5, (String[][])new String[][]{{"N/A", "Change Patched Version", WORKFLOW_TRANSITION_MULTI_PROJECT_ERROR}});
        this.tester.assertTableRowsEqual(TABLE_EDITFIELDS_ID, 15, (String[][])new String[][]{{"N/A", "Change Component/s", WORKFLOW_TRANSITION_MULTI_PROJECT_ERROR}});
        this.administration.removeGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
    }

    @Test
    @Restore(value="TestBulkWorkflowTransition.xml")
    public void testWorkflowTransitionCompleteWalkthrough() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), new ProjectPermissionKey(41));
        this.backdoor.darkFeatures().enableForSite("jira.no.frother.reporter.field");
        this.administration.attachments().enable();
        this.editIssueFieldVisibility.setShownFields("Attachment");
        this.administration.addGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
        this._testToOperationDetailsWorkflowTranisition();
        this.navigation.workflows().chooseWorkflowAction("classic default workflow_5_5");
        this.tester.assertTextPresent(WORKFLOW_TRANSITION_EDIT_TEXT);
        this.assertAllFieldsPresent();
        this.assertWikiRendererCommentField();
        this.editAllFields();
        this.tester.submit("Next");
        this.tester.assertTextPresent("Please confirm the details of this operation");
        this.assertAllEditFieldsInUpdatedFieldTable();
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.tester.assertTextInTable("issuetable", "Resolved");
        this.tester.assertTextInTable("issuetable", "Fixed");
        this.navigation.issue().gotoIssue("TSTWO-6");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "customfield_10000-val"), "29/Nov/05 4:27 PM");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "customfield_10002-val"), "Linux");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "customfield_10003-val"), "1");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "customfield_10004-val"), "http://www.atlassian.com");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "customfield_10007-val"), "Functional test - management comment");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "customfield_10008-val"), "Development");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "customfield_10009-val"), "Administrator");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "customfield_10010-val"), "Test Project 1");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "customfield_10013-val"), "Administrator");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "customfield_10014-val"), "Func Test - Limited text Field");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "customfield_10006-val"), "21/Dec/05");
        IdLocator locator = new IdLocator(this.tester, "type-val");
        this.textAssertions.assertTextPresent(locator, "New Feature");
        locator = new IdLocator(this.tester, "opsbar-transitions_more");
        this.textAssertions.assertTextPresent(locator, "Resolved");
        locator = new IdLocator(this.tester, "resolution-val");
        this.textAssertions.assertTextPresent(locator, "Fixed");
        locator = new IdLocator(this.tester, "priority-val");
        this.textAssertions.assertTextPresent(locator, "Critical");
        locator = new IdLocator(this.tester, "tt_single_values_orig");
        this.textAssertions.assertTextPresent(locator, "20m");
        locator = new IdLocator(this.tester, "tt_single_values_remain");
        this.textAssertions.assertTextPresent(locator, "20m");
        this.tester.assertTextPresent("Bulk Edit Comment");
        this.administration.removeGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"status", (Object)"Resolved", (Object)"resolution", (Object)"Fixed"), null, "TSTWO-6");
        this.indexing.assertIndexedFieldCorrect("//comments", (Map<String, String>)ImmutableMap.of((Object)"comment", (Object)"&lt;p&gt;Bulk Edit Comment&lt;/p&gt;"), null, "TSTWO-6");
        this.indexing.assertIndexedFieldCorrect("//customfield/customfieldvalues", (Map<String, String>)ImmutableMap.of((Object)"customfieldvalue", (Object)"Linux"), null, "TSTWO-6");
    }

    @Test
    @Restore(value="TestBulkTransition.xml")
    public void testWorkflowTransitionConcurrentIssueUpdate() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.checkCheckbox("bulkedit_10011", "on");
        this.tester.checkCheckbox("bulkedit_10010", "on");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.tester.submit("Next");
        this.tester.checkCheckbox("wftransition", "classic default workflow_2_6");
        this.tester.submit("Next");
        this.tester.selectOption("resolution", "Won't Fix");
        this.tester.submit("Next");
        this.changeOneOfTheIssuesConcurrently();
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.tester.assertTextNotInTable("issuetable", new String[]{"Open", "Reopen"});
    }

    private void changeOneOfTheIssuesConcurrently() {
        this.sessionFactory.begin().withSession(() -> {
            this.tester.beginAt("/");
            this.navigation.login("admin");
            this.navigation.issue().gotoIssue("HSP-2");
            this.workflowUtil.clickAction("action_id_2");
            this.tester.setWorkingForm("issue-workflow-transition");
            this.tester.submit("Transition");
        });
    }

    @Test
    @Restore(value="TestBulkWorkflowTransition.xml")
    public void testWorkflowTransitionEditFieldErrors() {
        this.administration.addGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
        this._testToOperationDetailsWorkflowTranisition();
        this.navigation.workflows().chooseWorkflowAction("classic default workflow_5_5");
        this.tester.assertTextPresent(WORKFLOW_TRANSITION_EDIT_TEXT);
        this.generateMultipleInputErrors();
        this.administration.removeGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
    }

    @Test
    @Restore(value="TestBulkWorkflowTransition.xml")
    public void testWorkflowTransitionErrorOnWorkflowSelection() {
        this.administration.addGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
        this._testToOperationDetailsWorkflowTranisition();
        this.tester.submit("Next");
        this.tester.assertTextPresent(WORKFLOW_TRANSITION_CHOOSE_ERROR_TEXT);
        this.administration.removeGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
    }

    @Test
    @Restore(value="TestBulkWorkflowTransition.xml")
    public void testBulkTransitionWithCommentVisibility() {
        this.navigation.comment().enableCommentGroupVisibility(Boolean.TRUE);
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.checkCheckbox("bulkedit_10009", "on");
        this.tester.checkCheckbox("bulkedit_10008", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Choose the operation you wish to perform");
        this.bulkOperations.chooseOperationExecuteWorfklowTransition();
        this.navigation.workflows().assertStepOperationDetails();
        this.tester.assertTextPresent(WORKFLOW_TRANSITION_SELECTION_TEXT);
        this.navigation.workflows().chooseWorkflowAction("classic default workflow_5_5");
        this.tester.selectOption("resolution", "Fixed");
        this.tester.checkCheckbox("commentaction", "comment");
        this.tester.setFormElement("comment", COMMENT_1);
        this.tester.submit("Next");
        this.tester.assertTextPresent("Please confirm the details of this operation");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.checkCheckbox("bulkedit_10009", "on");
        this.tester.checkCheckbox("bulkedit_10008", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Choose the operation you wish to perform");
        this.bulkOperations.chooseOperationExecuteWorfklowTransition();
        this.navigation.workflows().assertStepOperationDetails();
        this.tester.assertTextPresent(WORKFLOW_TRANSITION_SELECTION_TEXT);
        this.navigation.workflows().chooseWorkflowAction("classic default workflow_3_4");
        this.tester.checkCheckbox("commentaction", "comment");
        this.tester.selectOption("commentLevel", "jira-developers");
        this.tester.setFormElement("comment", COMMENT_2);
        this.tester.submit("Next");
        this.tester.assertTextPresent("Please confirm the details of this operation");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.checkCheckbox("bulkedit_10009", "on");
        this.tester.checkCheckbox("bulkedit_10008", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Choose the operation you wish to perform");
        this.bulkOperations.chooseOperationExecuteWorfklowTransition();
        this.navigation.workflows().assertStepOperationDetails();
        this.tester.assertTextPresent(WORKFLOW_TRANSITION_SELECTION_TEXT);
        this.navigation.workflows().chooseWorkflowAction("classic default workflow_5_5");
        this.tester.selectOption("resolution", "Fixed");
        this.tester.checkCheckbox("commentaction", "comment");
        this.tester.selectOption("commentLevel", "Developers");
        this.tester.setFormElement("comment", COMMENT_3);
        this.tester.submit("Next");
        this.tester.assertTextPresent("Please confirm the details of this operation");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue("TSTWO-4");
        this.tester.assertTextPresent(COMMENT_1);
        this.tester.assertTextNotPresent(COMMENT_2);
        this.tester.assertTextNotPresent(COMMENT_3);
        this.navigation.issue().gotoIssue("TSTWO-5");
        this.tester.assertTextPresent(COMMENT_1);
        this.tester.assertTextNotPresent(COMMENT_2);
        this.tester.assertTextNotPresent(COMMENT_3);
        this.navigation.issue().gotoIssue("TSTWO-6");
        this.tester.assertTextNotPresent(COMMENT_1);
        this.tester.assertTextNotPresent(COMMENT_2);
        this.tester.assertTextNotPresent(COMMENT_3);
        String xpathFormat = "//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]";
        this.indexing.assertIndexContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_1), "TSTWO-4");
        this.indexing.assertIndexNotContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_2), "TSTWO-4");
        this.indexing.assertIndexNotContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_3), "TSTWO-4");
        this.indexing.assertIndexContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_1), "TSTWO-5");
        this.indexing.assertIndexNotContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_2), "TSTWO-5");
        this.indexing.assertIndexNotContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_3), "TSTWO-5");
        this.indexing.assertIndexNotContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_1), "TSTWO-6");
        this.indexing.assertIndexNotContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_2), "TSTWO-6");
        this.indexing.assertIndexNotContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_3), "TSTWO-6");
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue("TSTWO-4");
        this.tester.assertTextPresent(COMMENT_1);
        this.tester.assertTextPresent(COMMENT_2);
        this.tester.assertTextPresent(COMMENT_3);
        this.navigation.issue().gotoIssue("TSTWO-5");
        this.tester.assertTextPresent(COMMENT_1);
        this.tester.assertTextPresent(COMMENT_2);
        this.tester.assertTextPresent(COMMENT_3);
        this.navigation.issue().gotoIssue("TSTWO-6");
        this.tester.assertTextNotPresent(COMMENT_1);
        this.tester.assertTextNotPresent(COMMENT_2);
        this.tester.assertTextNotPresent(COMMENT_3);
        this.indexing.assertIndexContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_1), "TSTWO-4");
        this.indexing.assertIndexContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_2), "TSTWO-4");
        this.indexing.assertIndexContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_3), "TSTWO-4");
        this.indexing.assertIndexContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_1), "TSTWO-5");
        this.indexing.assertIndexContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_2), "TSTWO-5");
        this.indexing.assertIndexContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_3), "TSTWO-5");
        this.indexing.assertIndexNotContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_1), "TSTWO-6");
        this.indexing.assertIndexNotContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_2), "TSTWO-6");
        this.indexing.assertIndexNotContainsItem(String.format("//comments/comment[.=&quot;&lt;p&gt;%s&lt;/p&gt;&quot;]", COMMENT_3), "TSTWO-6");
    }

    private void assertAllEditFieldsInUpdatedFieldTable() {
        this.tester.assertTableRowsEqual("updatedfields", 1, (String[][])new String[][]{{"Assignee", "Administrator"}});
        this.tester.assertTableRowsEqual("updatedfields", 2, (String[][])new String[][]{{"Test Run Date", "29/Nov/05 4:27 PM"}});
        this.tester.assertTableRowsEqual("updatedfields", 3, (String[][])new String[][]{{"Test Run Number", "1"}});
        this.tester.assertTableRowsEqual("updatedfields", 4, (String[][])new String[][]{{"Release Date", "21/Dec/05"}});
        this.tester.assertTableRowsEqual("updatedfields", 5, (String[][])new String[][]{{"Management Comments", "Functional test - management comment"}});
        this.tester.assertTableRowsEqual("updatedfields", 6, (String[][])new String[][]{{"Affected Business Units", "Development"}});
        this.tester.assertTableRowsEqual("updatedfields", 7, (String[][])new String[][]{{"Affected Users", "Administrator"}});
        this.tester.assertTableRowsEqual("updatedfields", 8, (String[][])new String[][]{{"Related Projects", "Test Project 1"}});
        this.tester.assertTableRowsEqual("updatedfields", 9, (String[][])new String[][]{{"End User", "Administrator"}});
        this.tester.assertTableRowsEqual("updatedfields", 10, (String[][])new String[][]{{"LImtied Text Field", "Func Test - Limited text Field"}});
        this.tester.assertTableRowsEqual("updatedfields", 11, (String[][])new String[][]{{"Description", "Func Test - Description"}});
        this.tester.assertTableRowsEqual("updatedfields", 12, (String[][])new String[][]{{"Due Date", "29/Dec/05"}});
        this.tester.assertTableRowsEqual("updatedfields", 13, (String[][])new String[][]{{"Environment", "Func test environment"}});
        this.tester.assertTableRowsEqual("updatedfields", 14, (String[][])new String[][]{{"Issue Type", "New Feature"}});
        this.tester.assertTableRowsEqual("updatedfields", 15, (String[][])new String[][]{{"Operating System", "Linux"}});
        this.tester.assertTableRowsEqual("updatedfields", 16, (String[][])new String[][]{{"Priority", "Critical"}});
        this.tester.assertTableRowsEqual("updatedfields", 17, (String[][])new String[][]{{"Reporter", "Administrator"}});
        this.tester.assertTableRowsEqual("updatedfields", 18, (String[][])new String[][]{{"Web Address", "http://www.atlassian.com"}});
        this.tester.assertTableRowsEqual("updatedfields", 19, (String[][])new String[][]{{"Time Tracking", "20m"}});
        this.tester.assertTableRowsEqual("updatedfields", 20, (String[][])new String[][]{{"Resolution", "Fixed"}});
        this.tester.assertTableRowsEqual("updatedfields", 21, (String[][])new String[][]{{"Comment", "Bulk Edit Comment"}});
    }

    private void assertAllFieldsPresent() {
        this.tester.assertTextPresent("Change Resolution");
        this.tester.assertTextPresent("Change Fix Version/s");
        this.tester.assertTextPresent("Change Assignee");
        this.tester.assertTextPresent("Change Test Run Date");
        this.tester.assertTextPresent("Change Test Run Number");
        this.tester.assertTextPresent("Change Patched Version");
        this.tester.assertTextPresent("Change Release Date");
        this.tester.assertTextPresent("Change Management Comments");
        this.tester.assertTextPresent("Change Affected Business Units");
        this.tester.assertTextPresent("Change Affected Users");
        this.tester.assertTextPresent("Change Related Projects");
        this.tester.assertTextPresent("Change End User");
        this.tester.assertTextPresent("Change LImtied Text Field");
        this.tester.assertTextPresent("Change Affects Version/s");
        this.tester.assertTextPresent("Change Component/s");
        this.tester.assertTextPresent("Change Description");
        this.tester.assertTextPresent("Change Due Date");
        this.tester.assertTextPresent("Change Environment");
        this.tester.assertTextPresent("Change Import Id");
        this.tester.assertTextPresent("Change Issue Type");
        this.tester.assertTextPresent("Change Operating System");
        this.tester.assertTextPresent("Change Priority");
        this.tester.assertTextPresent("Change Read Only Field");
        this.tester.assertTextPresent("Change Reporter");
        this.tester.assertTextPresent("Change Summary");
        this.tester.assertTextPresent("Change Web Address");
        this.tester.assertTextPresent("Change Time Tracking");
        this.tester.assertTextPresent("Change Comment");
    }

    private void assertWikiRendererCommentField() {
        this.tester.assertTextPresent("comment-preview_link");
        this.tester.assertLinkPresent("viewHelp");
    }

    private void editAllFields() {
        this.tester.checkCheckbox("actions", "resolution");
        this.tester.selectOption("resolution", "Fixed");
        this.tester.checkCheckbox("actions", "assignee");
        this.tester.selectOption("assignee", "Administrator");
        this.tester.checkCheckbox("actions", "customfield_10000");
        this.tester.setFormElement("customfield_10000", "29/Nov/2005 04:27 PM");
        this.tester.checkCheckbox("actions", "customfield_10003");
        this.tester.setFormElement("customfield_10003", "1");
        this.tester.checkCheckbox("actions", "customfield_10006");
        this.tester.setFormElement("customfield_10006", "21/Dec/2005");
        this.tester.checkCheckbox("actions", "customfield_10007");
        this.tester.setFormElement("customfield_10007", "Functional test - management comment");
        this.tester.checkCheckbox("actions", "customfield_10008");
        this.tester.checkCheckbox("customfield_10008", "10006");
        this.tester.checkCheckbox("actions", "customfield_10009");
        this.tester.setFormElement("customfield_10009", "admin");
        this.tester.checkCheckbox("actions", "customfield_10010");
        this.tester.selectOption("customfield_10010", "Test Project 1");
        this.tester.checkCheckbox("actions", "customfield_10013");
        this.tester.setFormElement("customfield_10013", "admin");
        this.tester.checkCheckbox("actions", "customfield_10014");
        this.tester.setFormElement("customfield_10014", "Func Test - Limited text Field");
        this.tester.checkCheckbox("actions", "description");
        this.tester.setFormElement("description", "Func Test - Description");
        this.tester.checkCheckbox("actions", "duedate");
        this.tester.setFormElement("duedate", "29/Dec/2005");
        this.tester.checkCheckbox("actions", "environment");
        this.tester.setFormElement("environment", "Func test environment");
        this.tester.checkCheckbox("actions", "issuetype");
        this.navigation.issue().selectIssueType("New Feature", "issuetype");
        this.tester.checkCheckbox("actions", "customfield_10002");
        this.tester.selectOption("customfield_10002", "Linux");
        this.tester.checkCheckbox("actions", "priority");
        this.tester.selectOption("priority", "Critical");
        this.tester.checkCheckbox("actions", "reporter");
        this.tester.setFormElement("reporter", "admin");
        this.tester.checkCheckbox("actions", "customfield_10004");
        this.tester.setFormElement("customfield_10004", "http://www.atlassian.com");
        this.tester.checkCheckbox("commentaction", "comment");
        this.tester.setFormElement("comment", "Bulk Edit Comment");
        this.tester.checkCheckbox("actions", "timetracking");
        this.tester.setFormElement("timetracking", "20");
    }

    private void generateMultipleInputErrors() {
        this.tester.checkCheckbox("actions", "resolution");
        this.tester.selectOption("resolution", "Fixed");
        this.tester.checkCheckbox("actions", "duedate");
        this.tester.setFormElement("duedate", "functest");
        this.tester.checkCheckbox("actions", "customfield_10000");
        this.tester.setFormElement("customfield_10000", "functest");
        this.tester.checkCheckbox("actions", "customfield_10004");
        this.tester.setFormElement("customfield_10004", "functest");
        this.tester.checkCheckbox("actions", "customfield_10006");
        this.tester.setFormElement("customfield_10006", "functest");
        this.tester.checkCheckbox("actions", "customfield_10009");
        this.tester.setFormElement("customfield_10009", "functest");
        this.tester.submit("Next");
        this.tester.assertTextPresent("You did not enter a valid date. Please enter the date in the format");
        this.tester.assertTextPresent("Not a valid URL");
        this.tester.assertTextPresent("Invalid date format. Please enter the date in the format &quot;d/MMM/yy&quot;.");
    }

    private void verifyAtSessionTimeoutPage() {
        this.tester.assertTextPresent("Your session timed out while performing bulk operation on issues.");
    }

    private void _testToOperationDetailsWorkflowTranisition() {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.assertTextPresent("Step 1 of 4: Choose Issues");
        this.bulkOperations.bulkChangeChooseIssuesAll();
        this.tester.assertTextPresent("Choose the operation you wish to perform");
        this.bulkOperations.chooseOperationExecuteWorfklowTransition();
        this.navigation.workflows().assertStepOperationDetails();
        this.tester.assertTextPresent(WORKFLOW_TRANSITION_SELECTION_TEXT);
    }

    @Test
    @Restore(value="TestBulkWorkflowTransitionEnterprise.xml")
    public void testBulkWorkFlowTransitionMultipleWorkflowsExists() {
        this.navigation.gotoDashboard();
        this.administration.addGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
        this._testToOperationDetailsWorkflowTranisition();
        this.tester.submit("Next");
        this.navigation.workflows().assertStepOperationDetails();
        this.tester.assertTablePresent("workflow_0");
        this.tester.assertTablePresent("workflow_1");
    }

    @Test
    @Restore(value="TestBulkWorkflowTransitionEnterprise4.xml")
    public void testFunkyWorkflowName() {
        this.navigation.gotoDashboard();
        this.administration.addGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
        this._testToOperationDetailsWorkflowTranisition();
        this.tester.checkCheckbox("wftransition", "Second_Workflow_4_3");
        this.tester.submit("Next");
        this.tester.assertTextPresent(WORKFLOW_TRANSITION_EDIT_TEXT);
    }

    @Test
    @Restore(value="TestBulkWorkflowTranistionForCustomFieldContextAndIssueType.xml")
    public void testCustomFieldContextAndIssueTypeBehaviour() {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.checkCheckbox("bulkedit_10002", "on");
        this.tester.checkCheckbox("bulkedit_10001", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.tester.submit("Next");
        this.navigation.workflows().chooseWorkflowAction("classic default workflow_5_5");
        this.tester.assertTextPresent(WORKFLOW_TRANSITION_EDIT_TEXT);
        this.tester.checkCheckbox("actions", "resolution");
        this.tester.selectOption("resolution", "Fixed");
        this.tester.checkCheckbox("actions", "customfield_10000");
        this.tester.setFormElement("customfield_10000", "Setting Monkey Custom Field");
        this.tester.assertTableRowsEqual(TABLE_EDITFIELDS_ID, 4, (String[][])new String[][]{{"N/A", "Change Man Custom Field", "NOTE: The field is not available for all issues with the same configuration."}});
        this.tester.checkCheckbox("actions", "customfield_10010");
        this.tester.checkCheckbox("customfield_10010", "10001");
        this.tester.checkCheckbox("actions", "customfield_10011");
        this.tester.setFormElement("customfield_10011", "Setting the global field");
        this.tester.checkCheckbox("actions", "customfield_10012");
        this.tester.setFormElement("customfield_10012", "8/Sep/06");
        this.tester.submit("Next");
        this.tester.assertTextInTable("updatedfields", "Fixed");
        this.tester.assertTextInTable("updatedfields", "Setting Monkey Custom Field");
        this.tester.assertTextInTable("updatedfields", "Monkey");
        this.tester.assertTextInTable("updatedfields", "Setting the global field");
        this.tester.assertTextInTable("updatedfields", "08/Sep/06");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().gotoIssue("MKY-2");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "rowForcustomfield_10000"), "Setting Monkey Custom Field");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "rowForcustomfield_10010"), "Monkey");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "rowForcustomfield_10011"), "Setting the global field");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "customfield_10012-val"), "08/Sep/06");
        this.indexing.assertIndexContainsItem("//customfields/customfield/customfieldvalues/customfieldvalue[.=&quot;Setting Monkey Custom Field&quot;]", "MKY-2");
        this.indexing.assertIndexContainsItem("//customfields/customfield/customfieldvalues/customfieldvalue[.=&quot;Setting the global field&quot;]", "MKY-2");
        this.indexing.assertIndexedFieldCorrect("//item", (Map<String, String>)ImmutableMap.of((Object)"resolution", (Object)"Fixed", (Object)"status", (Object)"Resolved"), null, "MKY-2");
    }

    @Test
    @Restore(value="TestBulkWorkflowTransition.xml")
    public void testMultipleOriginStatusesShownDuringTransitionScreen() {
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.checkCheckbox("bulkedit_10010", "on");
        this.tester.checkCheckbox("bulkedit_10008", "on");
        this.tester.checkCheckbox("bulkedit_10002", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.tester.submit("Next");
        IdLocator row0 = new IdLocator(this.tester, "origin_0");
        this.textAssertions.assertTextPresent(row0.getNodes()[0].getChildNodes().item(1).getTextContent(), "Open");
        this.textAssertions.assertTextPresent(row0.getNodes()[0].getChildNodes().item(3).getTextContent(), "In Progress");
        this.textAssertions.assertTextPresent(row0.getNodes()[0].getChildNodes().item(5).getTextContent(), "Reopened");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "target_0"), "Closed");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "short_classic default workflow_2_6"), "TSTWO-4");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "short_classic default workflow_2_6"), "TSTWO-6");
        IdLocator row1 = new IdLocator(this.tester, "origin_1");
        this.textAssertions.assertTextPresent(row1.getNodes()[0].getChildNodes().item(1).getTextContent(), "Resolved");
        this.textAssertions.assertTextPresent(row1.getNodes()[0].getChildNodes().item(3).getTextContent(), "Closed");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "target_1"), "Reopened");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "short_classic default workflow_3_4"), "TST-3");
        IdLocator row2 = new IdLocator(this.tester, "origin_2");
        this.textAssertions.assertTextPresent(row2.getNodes()[0].getChildNodes().item(1).getTextContent(), "Open");
        this.textAssertions.assertTextPresent(row2.getNodes()[0].getChildNodes().item(3).getTextContent(), "Reopened");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "target_2"), "In Progress");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "short_classic default workflow_4_3"), "TSTWO-4");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "short_classic default workflow_4_3"), "TSTWO-6");
        IdLocator row3 = new IdLocator(this.tester, "origin_3");
        this.textAssertions.assertTextPresent(row3.getNodes()[0].getChildNodes().item(1).getTextContent(), "Open");
        this.textAssertions.assertTextPresent(row3.getNodes()[0].getChildNodes().item(3).getTextContent(), "In Progress");
        this.textAssertions.assertTextPresent(row3.getNodes()[0].getChildNodes().item(5).getTextContent(), "Reopened");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "target_3"), "Resolved");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "short_classic default workflow_5_5"), "TSTWO-4");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "short_classic default workflow_5_5"), "TSTWO-6");
        IdLocator row4 = new IdLocator(this.tester, "origin_4");
        this.textAssertions.assertTextPresent(row4.getNodes()[0].getChildNodes().item(1).getTextContent(), "Resolved");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "target_4"), "Closed");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "short_classic default workflow_701_6"), "TST-3");
        this.tester.assertTableRowsEqual("workflow_0", 5, (String[][])new String[][]{{"Close Issue", "Resolved", "Closed", "TST-3"}});
        this.navigation.workflows().chooseWorkflowAction("classic default workflow_2_6");
        IdLocator editsRow = new IdLocator(this.tester, "workflow-transition-edit-fields-status-list");
        this.textAssertions.assertTextPresent(editsRow.getNodes()[0].getChildNodes().item(1).getTextContent(), "Open");
        this.textAssertions.assertTextPresent(editsRow.getNodes()[0].getChildNodes().item(3).getTextContent(), "In Progress");
        this.textAssertions.assertTextPresent(editsRow.getNodes()[0].getChildNodes().item(5).getTextContent(), "Reopened");
        this.textAssertions.assertTextPresent(editsRow.getNodes()[0].getChildNodes().item(9).getTextContent(), "Closed");
        this.tester.checkCheckbox("actions", "resolution");
        this.tester.selectOption("resolution", "Fixed");
        this.tester.submit("Next");
        IdLocator confirmationRow = new IdLocator(this.tester, "workflow-transition-confirmation-status-list");
        this.textAssertions.assertTextPresent(confirmationRow.getNodes()[0].getChildNodes().item(1).getTextContent(), "Open");
        this.textAssertions.assertTextPresent(confirmationRow.getNodes()[0].getChildNodes().item(3).getTextContent(), "In Progress");
        this.textAssertions.assertTextPresent(confirmationRow.getNodes()[0].getChildNodes().item(5).getTextContent(), "Reopened");
        this.textAssertions.assertTextPresent(confirmationRow.getNodes()[0].getChildNodes().item(9).getTextContent(), "Closed");
    }
}

