/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.HttpUnitOptions;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
public class TestEditNestedGroups
extends BaseJiraFuncTest {
    private static final String PLEASE_REFRESH_MEMBERS_LIST = "Newly selected group(s) may have different members.";
    private static final String UNASSIGN = "unassign";
    private static final String ASSIGN = "assign";
    private static final String FIELD_GROUPS_TO_UNASSIGN = "childrenToUnassign";
    private static final String FIELD_GROUPS_TO_ASSIGN = "childrenToAssignStr";
    private static final String FIELD_SELECTED_GROUPS = "selectedGroupsStr";
    private static final String ERROR_SELECT_GROUPS = "Please select group(s) to edit";
    private static final String ERROR_SELECT_GROUPS_TO_REMOVE = "Please select groups to remove from the selected group(s)";
    private static final String ERROR_SELECT_GROUPS_TO_ADD = "Please select groups to add to all the selected group(s)";
    @Inject
    private Form form;
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;

    @Before
    public void setUp() {
        this.administration.restoreData("TestEditNestedGroups.xml");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
    }

    @After
    public void tearDown() {
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    @Test
    public void testEditNestedGroupGroupsInvalidGroups() {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/group/EditNestedGroups.jspa?selectedGroupsStr=invalid&assign=true&childrenToAssignStr=group200"));
        this.tester.assertTextPresent("The group &#39;invalid&#39; is not a valid group.");
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/group/EditNestedGroups.jspa?selectedGroupsStr=invalid&unassign=true&childrenToUnassign=group200"));
        this.tester.assertTextPresent("The group &#39;invalid&#39; is not a valid group.");
    }

    @Test
    public void testUnassignGroupsFromGroups() {
        String[] options;
        this.gotoEditNestedGroups();
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, "group202", new String[0]);
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_ASSIGN, "jira-developers", "jira-users", "group203");
        this.tester.submit(ASSIGN);
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, "group202", new String[0]);
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_UNASSIGN, "jira-developers", new String[0]);
        this.tester.submit(UNASSIGN);
        this.tester.assertTextPresent("Selected 1 of 5 Groups");
        this.tester.assertTextPresent("2 Group Member(s)");
        this.tester.setWorkingForm("jiraform");
        for (String option : options = this.tester.getDialog().getOptionValuesFor(FIELD_GROUPS_TO_UNASSIGN)) {
            Assert.assertFalse((boolean)option.equals("jira-developers______group202"));
        }
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, "group200", new String[0]);
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_ASSIGN, "jira-users", new String[0]);
        this.tester.submit(ASSIGN);
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, "group200", "group202");
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_ASSIGN, "jira-developers", "group203");
        this.tester.submit(ASSIGN);
        this.selectGroup200And202();
        this.tester.setWorkingForm("jiraform");
        options = this.tester.getDialog().getOptionValuesFor(FIELD_GROUPS_TO_UNASSIGN);
        Assert.assertTrue((options.length == 3 ? 1 : 0) != 0);
        this.form.selectOptionsByValue(FIELD_GROUPS_TO_UNASSIGN, "jira-users", "jira-developers");
        this.tester.submit(UNASSIGN);
        this.tester.assertTextPresent("Selected 2 of 5 Groups");
        this.tester.setWorkingForm("jiraform");
        options = this.tester.getDialog().getOptionValuesFor(FIELD_GROUPS_TO_UNASSIGN);
        Assert.assertTrue((options.length == 1 ? 1 : 0) != 0);
        for (String option : options) {
            Assert.assertFalse((boolean)option.equals("jira-developers______group202"));
            Assert.assertFalse((boolean)option.equals("jira-users"));
        }
    }

    @Test
    public void testAssignGroupsFromGroups() {
        this.gotoEditNestedGroups();
        this.selectDeveloperGroupOnly();
        this.tester.assertTextPresent("No groups in selected group(s)");
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_ASSIGN, "group200", new String[0]);
        this.tester.submit(ASSIGN);
        this.tester.assertTextPresent("Selected 1 of 5 Groups");
        this.tester.assertTextPresent("1 Group Member(s)");
        this.tester.setWorkingForm("jiraform");
        String[] options = this.tester.getDialog().getOptionValuesFor(FIELD_GROUPS_TO_UNASSIGN);
        boolean found = false;
        for (String option : options) {
            if (!option.equals("group200______jira-developers")) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
        this.selectGroupsAndDevelopersGroup();
        this.tester.setWorkingForm("jiraform");
        options = this.tester.getDialog().getOptionValuesFor(FIELD_GROUPS_TO_UNASSIGN);
        Assert.assertTrue((options.length == 1 ? 1 : 0) != 0);
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_ASSIGN, "group200", "group202");
        this.tester.submit(ASSIGN);
        this.tester.assertTextPresent("Selected 2 of 5 Groups");
        this.tester.setWorkingForm("jiraform");
        options = this.tester.getDialog().getOptionValuesFor(FIELD_GROUPS_TO_UNASSIGN);
        Assert.assertEquals((long)2L, (long)options.length);
        boolean found2 = false;
        found = false;
        for (String option : options) {
            if (option.equals("group200")) {
                found = true;
            }
            if (!option.equals("group202")) continue;
            found2 = true;
        }
        Assert.assertTrue((found && found2 ? 1 : 0) != 0);
    }

    @Test
    public void testUnassignGroupsFromGroupsValidation() {
        this.gotoEditNestedGroups();
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, "group200", new String[0]);
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_ASSIGN, "jira-users", new String[0]);
        this.tester.submit(ASSIGN);
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, "group200", "group202");
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_ASSIGN, "jira-developers", "group203");
        this.tester.submit(ASSIGN);
        this.gotoEditNestedGroups();
        this.tester.submit(UNASSIGN);
        this.tester.assertTextPresent(ERROR_SELECT_GROUPS);
        this.selectGroupsAndDevelopersGroup();
        this.tester.submit(UNASSIGN);
        this.tester.assertTextPresent(ERROR_SELECT_GROUPS_TO_REMOVE);
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, "group200", "group202");
        this.refreshMembersList();
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_UNASSIGN, "jira-developers", new String[0]);
        this.tester.selectOption(FIELD_SELECTED_GROUPS, "group203");
        this.tester.assertTextPresent(PLEASE_REFRESH_MEMBERS_LIST);
        this.tester.submit(UNASSIGN);
        this.tester.assertTextPresent("Cannot remove group &#39;jira-developers&#39; from group &#39;group203&#39; since group is not a member of &#39;group203&#39;");
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, "group200", "group202");
        this.refreshMembersList();
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_UNASSIGN, "jira-users", new String[0]);
        this.tester.selectOption(FIELD_SELECTED_GROUPS, "group202");
        this.tester.assertTextPresent(PLEASE_REFRESH_MEMBERS_LIST);
        this.tester.submit(UNASSIGN);
        this.tester.assertTextPresent("Cannot remove group &#39;jira-users&#39; from group &#39;group200&#39; since the group was not selected. Please make sure to refresh after selecting new group(s)");
    }

    @Test
    public void testAssignGroupsFromGroupsValidation() {
        this.gotoEditNestedGroups();
        this.tester.assertTextPresent("Selected 0 of 5 Groups");
        this.tester.submit(ASSIGN);
        this.tester.assertTextPresent(ERROR_SELECT_GROUPS);
        this.gotoEditNestedGroups();
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_ASSIGN, "group200", new String[0]);
        this.tester.assertTextPresent("Selected 0 of 5 Groups");
        this.tester.submit(ASSIGN);
        this.tester.assertTextPresent(ERROR_SELECT_GROUPS);
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, "group200", "group202");
        this.tester.submit(ASSIGN);
        this.tester.assertTextPresent(ERROR_SELECT_GROUPS_TO_ADD);
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, "group200", new String[0]);
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_ASSIGN, "group202", new String[0]);
        this.tester.submit(ASSIGN);
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, "group200", new String[0]);
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_ASSIGN, "group202", new String[0]);
        this.tester.submit(ASSIGN);
        this.tester.assertTextPresent("Cannot add group &#39;group202&#39;, group is already a member of &#39;group200&#39;");
        this.tester.selectOption(FIELD_SELECTED_GROUPS, "jira-users");
        this.tester.selectOption(FIELD_GROUPS_TO_ASSIGN, "group202");
        this.tester.submit(ASSIGN);
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, "jira-users", "group200");
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_ASSIGN, "group202", new String[0]);
        this.tester.submit(ASSIGN);
        this.tester.assertTextPresent("Cannot add group &#39;group202&#39;, group is already a member of all the selected group(s)");
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, "group200", new String[0]);
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_ASSIGN, "group200", new String[0]);
        this.tester.submit(ASSIGN);
        this.tester.assertTextPresent("Cannot add a group to itself.");
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, "group202", new String[0]);
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_ASSIGN, "group200", new String[0]);
        this.tester.submit(ASSIGN);
        this.tester.assertTextPresent("Cannot add child group &#39;group200&#39; to parent group &#39;group202&#39; - this would cause a circular dependency.");
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, "group202", new String[0]);
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_ASSIGN, "jira-developers", new String[0]);
        this.tester.submit(ASSIGN);
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, "jira-developers", new String[0]);
        this.form.selectOptionsByDisplayName(FIELD_GROUPS_TO_ASSIGN, "group200", new String[0]);
        this.tester.submit(ASSIGN);
        this.tester.assertTextPresent("Cannot add child group &#39;group200&#39; to parent group &#39;jira-developers&#39; - this would cause a circular dependency.");
    }

    private void gotoEditNestedGroups() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.clickLink("edit_nested_groups");
        this.tester.assertTextPresent("This page allows you to edit nested group memberships.");
        this.tester.assertTextPresent("Selected 0 of 5 Groups");
        this.tester.assertTextPresent("No groups in selected group(s)");
    }

    private void selectDeveloperGroupOnly() {
        this.selectSingleGroupOnly(this.getDeveloperOption());
    }

    private void selectAdminGroupOnly() {
        this.selectSingleGroupOnly(this.getAdminOption());
    }

    private void selectGroupsAndDevelopersGroup() {
        this.selectTwoGroups(this.getGroupOption(), this.getDeveloperOption());
    }

    private void selectGroup200And202() {
        this.selectTwoGroups(this.getGroup200Option(), this.getGroup202Option());
    }

    private void selectSingleGroupOnly(String group) {
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, group, new String[0]);
        this.tester.assertTextPresent(PLEASE_REFRESH_MEMBERS_LIST);
        this.refreshMembersList();
        this.tester.assertTextPresent("Selected 1 of 5 Groups");
    }

    private void selectTwoGroups(String group1, String group2) {
        this.tester.setWorkingForm("jiraform");
        this.form.selectOptionsByDisplayName(FIELD_SELECTED_GROUPS, group1, group2);
        this.tester.assertTextPresent(PLEASE_REFRESH_MEMBERS_LIST);
        this.refreshMembersList();
        this.tester.assertTextPresent("Selected 2 of 5 Groups");
    }

    private void refreshMembersList() {
        if (HttpUnitOptions.isScriptingEnabled()) {
            this.tester.clickLink("refresh-dependant-fields");
        } else {
            this.tester.submit("refresh");
        }
    }

    private String getAdminOption() {
        return "group203";
    }

    private String getDeveloperOption() {
        return "jira-developers";
    }

    private String getGroupOption() {
        return "jira-users";
    }

    private String getGroup200Option() {
        return "group200";
    }

    private String getGroup202Option() {
        return "group202";
    }
}

