/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
public class TestIssueTabPanels
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestIssueTabPanels.xml");
    }

    @Test
    public void testActivityStreamIsNotSortable() {
        this.tester.gotoPage("browse/MKY-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Acomment-tabpanel");
        this.tester.assertTextNotPresent("<li id=\"activity-stream-issue-tab\" class=\"active\"><strong>Activity</strong></li>");
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "Newest first");
        this.tester.gotoPage("browse/MKY-1?page=com.atlassian.streams.streams-jira-plugin%3Aactivity-stream-issue-tab");
        Assert.assertThat((Object)this.locator.css("li#activity-stream-issue-tab.active").getText(), (Matcher)IsEqual.equalTo((Object)"Activity"));
        Assert.assertThat((Object)this.locator.css("iframe#gadget-0").getNode(), (Matcher)CoreMatchers.not((Matcher)IsEqual.equalTo(null)));
        this.textAssertions.assertTextNotPresent(new WebPageLocator(this.tester), "Newest first");
    }
}

