/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.gadget;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.gadget.PickerClient;
import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.GADGETS, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestPickerResource
extends BaseJiraRestTest {
    private static final List<String> LETTERS = Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K");
    private PickerClient pickerClient;
    private static final List<String> RESERVED_LUCENE_OPERATORS = ImmutableList.of((Object)"+", (Object)"&", (Object)"|", (Object)"!", (Object)"(", (Object)")", (Object)"{", (Object)"}", (Object)"[", (Object)"]", (Object)"^", (Object)"~", (Object[])new String[]{"*", "?", ":", "'", "\"", "\\"});

    @Before
    public void setupFilters() {
        this.pickerClient = new PickerClient(this.environmentData);
    }

    private List<String> generateList(String prefix, List<String> infixes, String suffix) {
        return infixes.stream().map(infix -> MessageFormat.format("{0}{1}{2}", prefix, infix, suffix)).collect(Collectors.toList());
    }

    private List<String> generateListFromInt(String prefix, int startInclusive, int endExclusive, String suffix) {
        return this.generateList(prefix, IntStream.range(startInclusive, endExclusive).mapToObj(Integer::toString).collect(Collectors.toList()), suffix);
    }

    private List<String> createFilters(List<String> names) {
        ImmutableList.Builder ids = ImmutableList.builder();
        names.forEach(name -> ids.add((Object)this.backdoor.filters().createFilter("text ~ test", (String)name)));
        return ids.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    private final void generateAndCleanupFilters(Runnable runnable, List<String> ... filters) {
        List<String> filtersNames = Arrays.stream(filters).flatMap(Collection::stream).collect(Collectors.toList());
        List<String> filtersIds = this.createFilters(filtersNames);
        try {
            runnable.run();
        }
        finally {
            filtersIds.forEach(id -> this.backdoor.filters().deleteFilter((String)id));
        }
    }

    @Test
    public void filterWithWhitespacesAndDotsShouldBeSearchable() {
        this.generateAndCleanupFilters(() -> {
            List<String> filters = this.pickerClient.getMatchedFiltersNames("My JIRA 4.0.2 Bugs");
            Assert.assertThat((String)"Result should be My JIRA 4.0.2 Bugs", filters, (Matcher)Matchers.contains((Object[])new String[]{"My JIRA 4.0.2 Bugs"}));
        }, Arrays.asList("My JIRA 4.0.2 Bugs"));
    }

    @Test
    public void filterShouldBeSearchableIfFullNameIsPassedEvenIfIsAboveResultsSizeLimit1() {
        this.generateAndCleanupFilters(() -> {
            List<String> filters = this.pickerClient.getMatchedFiltersNames("Filter K");
            Assert.assertThat((String)"Should contain the exact match 'Filter K", filters, (Matcher)CoreMatchers.hasItem((Object)"Filter K"));
            filters = this.pickerClient.getMatchedFiltersNames("Filter-K");
            Assert.assertThat((String)"Should contain the exact match 'Filter-K'", filters, (Matcher)CoreMatchers.hasItem((Object)"Filter-K"));
            filters = this.pickerClient.getMatchedFiltersNames("z-Filter K");
            Assert.assertThat((String)"Should contain the exact match 'z-Filter K'", filters, (Matcher)CoreMatchers.hasItem((Object)"z-Filter K"));
        }, this.generateList("Filter ", LETTERS, ""), this.generateList("Filter-", LETTERS, ""), this.generateList("z-Filter ", LETTERS, ""));
    }

    @Test
    public void shouldBeAbleToFindFilterWhichStartsWithDifferentLetter() {
        this.generateAndCleanupFilters(() -> {
            List<String> filters = this.pickerClient.getMatchedFiltersNames("K");
            Assert.assertThat((String)"Should contain three filters which contain 'K' after either a whitespace or dash", filters, (Matcher)Matchers.hasItems((Object[])new String[]{"Filter K", "Filter-K", "z-Filter K"}));
        }, this.generateList("Filter ", LETTERS, ""), this.generateList("Filter-", LETTERS, ""), this.generateList("z-Filter ", LETTERS, ""));
    }

    @Test
    public void shouldAllowToSearchFilterWithReservedLuceneCharacters() {
        this.generateAndCleanupFilters(() -> RESERVED_LUCENE_OPERATORS.forEach(operator -> {
            String filterString = "filter" + this.urlFriendlyOperator((String)operator);
            List<String> filters = this.pickerClient.getMatchedFiltersNames(filterString);
            Assert.assertThat((String)("Should match filter with reserved Lucene character " + operator), filters, (Matcher)CoreMatchers.hasItem((Object)("Filter" + operator)));
        }), RESERVED_LUCENE_OPERATORS.stream().map(operator -> "Filter" + this.urlFriendlyOperator((String)operator)).collect(Collectors.toList()));
    }

    @Test
    public void shouldAllowToSearchFilterWithReservedLuceneCharacters2() {
        this.generateAndCleanupFilters(() -> RESERVED_LUCENE_OPERATORS.forEach(operator -> {
            String filterString = "Filter" + this.urlFriendlyOperator((String)operator) + "suffix";
            List<String> filters = this.pickerClient.getMatchedFiltersNames(filterString);
            Assert.assertThat((String)("Should have filter with reserved Lucene character " + operator), filters, (Matcher)CoreMatchers.hasItem((Object)("Filter" + operator + "suffix")));
        }), RESERVED_LUCENE_OPERATORS.stream().map(operator -> "Filter" + this.urlFriendlyOperator((String)operator) + "suffix").collect(Collectors.toList()));
    }

    @Test
    public void shouldNotFailIfFirstCharacterIsReservedLuceneCharacter() {
        this.generateAndCleanupFilters(() -> RESERVED_LUCENE_OPERATORS.forEach(operator -> {
            String filterString = this.urlFriendlyOperator((String)operator) + "suffix";
            List<String> filters = this.pickerClient.getMatchedFiltersNames(filterString);
            Assert.assertThat((String)("Should have filter which starts with reserved Lucene character " + operator), filters, (Matcher)CoreMatchers.hasItem((Object)(operator + "suffix")));
        }), RESERVED_LUCENE_OPERATORS.stream().map(operator -> this.urlFriendlyOperator((String)operator) + "suffix").collect(Collectors.toList()));
    }

    @Test
    public void shouldWorkWithDashNamesAndNumbers() {
        this.generateAndCleanupFilters(() -> {
            List<String> filters = this.pickerClient.getMatchedFiltersNames("z-");
            Assert.assertThat(filters, (Matcher)Matchers.is(this.generateListFromInt("z-Filter", 0, 9, "")));
        }, this.generateListFromInt("z-Filter", 0, 9, ""));
    }

    private String urlFriendlyOperator(String operator) {
        if (Objects.equals(operator, "{")) {
            return "%7B";
        }
        if (Objects.equals(operator, "}")) {
            return "%7D";
        }
        return operator;
    }
}

