/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

class ProjectCategoryClient
extends RestApiClient<ProjectCategoryClient> {
    private static final String PROJECT_CATEGORY = "projectCategory";

    ProjectCategoryClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        super((JIRAEnvironmentData)environmentData);
    }

    public Response getAllCategories() {
        WebTarget webTarget = this.createResource().path(PROJECT_CATEGORY);
        return this.registerResponse((Response)webTarget.request().get(Response.class));
    }

    public Response getCategory(String id) {
        WebTarget webTarget = this.createResource().path("projectCategory/" + id);
        return this.registerResponse((Response)webTarget.request().get(Response.class));
    }

    public Response createCategory(String name, String description) {
        WebTarget webTarget = this.createResource().path(PROJECT_CATEGORY);
        HashMap postBody = Maps.newHashMap();
        postBody.put("name", name);
        postBody.put("description", description);
        return this.registerResponse((Response)webTarget.request(new String[]{"application/json"}).post(Entity.json((Object)postBody), Response.class));
    }

    public Long createCategoryAndReturnId(String name, String description) {
        Response response = this.createCategory(name, description);
        Map json = (Map)response.readEntity(Map.class);
        return Long.parseLong((String)json.get("id"));
    }

    public Response deleteCategory(String id) {
        WebTarget webTarget = this.createResource().path("projectCategory/" + id);
        return this.registerResponse((Response)webTarget.request().delete(Response.class));
    }
}

