/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.v2.monitoring.AppMonitoringController;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestAppMonitoringController
extends BaseJiraFuncTest {
    private AppMonitoringClient client;

    @Before
    public void setUp() {
        this.client = new AppMonitoringClient(this.getEnvironmentData());
    }

    @Test
    public void testSetAppMonitoringWithWebsudoEnabled() {
        ParsedResponse<AppMonitoringController.AppMonitoringRestEntity> appMonitoringResponse = this.client.getAppMonitoringState();
        AppMonitoringController.AppMonitoringRestEntity appMonitoringStateBefore = (AppMonitoringController.AppMonitoringRestEntity)appMonitoringResponse.body;
        this.backdoor.websudo().enable();
        ParsedResponse response = this.client.setAppMonitoringState(appMonitoringStateBefore.isEnabled() == false);
        Assert.assertEquals((long)401L, (long)response.statusCode);
        this.backdoor.websudo().disable();
        AppMonitoringController.AppMonitoringRestEntity appMonitoringStateAfter = (AppMonitoringController.AppMonitoringRestEntity)this.client.getAppMonitoringState().body;
        Assert.assertEquals((Object)appMonitoringStateBefore.isEnabled(), (Object)appMonitoringStateAfter.isEnabled());
    }

    @Test
    public void testSetAppMonitoringStartWithWebsudoDisabled() {
        ParsedResponse<AppMonitoringController.AppMonitoringRestEntity> appMonitoringResponse = this.client.getAppMonitoringState();
        AppMonitoringController.AppMonitoringRestEntity appMonitoringStateBefore = (AppMonitoringController.AppMonitoringRestEntity)appMonitoringResponse.body;
        ParsedResponse response = this.client.setAppMonitoringState(appMonitoringStateBefore.isEnabled() == false);
        Assert.assertEquals((long)204L, (long)response.statusCode);
        AppMonitoringController.AppMonitoringRestEntity appMonitoringStateAfter = (AppMonitoringController.AppMonitoringRestEntity)this.client.getAppMonitoringState().body;
        Assert.assertEquals((Object)appMonitoringStateBefore.isEnabled(), (Object)(appMonitoringStateAfter.isEnabled() == false ? 1 : 0));
    }

    @Test
    public void testGetAppMonitoringWithWebsudoEnabled() {
        this.backdoor.websudo().enable();
        ParsedResponse<AppMonitoringController.AppMonitoringRestEntity> response = this.client.getAppMonitoringState();
        Assert.assertEquals((long)401L, (long)response.statusCode);
        this.backdoor.websudo().disable();
    }

    @Test
    public void testGetAppMonitoringStartWithWebsudoDisabled() {
        ParsedResponse<AppMonitoringController.AppMonitoringRestEntity> response = this.client.getAppMonitoringState();
        Assert.assertEquals((long)200L, (long)response.statusCode);
    }

    public static class AppMonitoringClient
    extends RestApiClient<AppMonitoringClient> {
        public AppMonitoringClient(JIRAEnvironmentData environmentData) {
            super(environmentData);
        }

        public ParsedResponse setAppMonitoringState(boolean isAppMonitoringEnabled) {
            return this.toResponse(() -> (Response)this.createResource().path("monitoring").path("app").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)new GenericEntity((Object)new AppMonitoringController.AppMonitoringRestEntity(Boolean.valueOf(isAppMonitoringEnabled)), AppMonitoringController.AppMonitoringRestEntity.class)), Response.class));
        }

        public ParsedResponse<AppMonitoringController.AppMonitoringRestEntity> getAppMonitoringState() {
            return this.toResponse(() -> (Response)this.createResource().path("monitoring").path("app").request().get(Response.class), AppMonitoringController.AppMonitoringRestEntity.class);
        }
    }
}

