/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.EntityProperty;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util.PropertyAssertions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ENTITY_PROPERTIES, Category.REST})
@LoginAs(user="admin")
public class TestCommentPropertyResource
extends BaseJiraFuncTest {
    public static final String PROPERTY_KEY = "comment.meta";
    public static final String PROJECT_KEY = "HSP";
    private EntityPropertyClient client;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.client = new EntityPropertyClient((JIRAEnvironmentData)this.environmentData, "comment");
    }

    @Test
    public void testCreatingNewCommentProperty() {
        this.administration.restoreBlankInstance();
        this.setupPermissionsToEditComments();
        IssueCreateResponse issue = this.backdoor.issues().createIssue(PROJECT_KEY, "Issue with comment");
        final Comment comment = (Comment)this.backdoor.issues().commentIssue((String)issue.key, (String)"comment with property").body;
        Assert.assertThat((Object)this.client.getKeys((String)comment.id).keys, (Matcher)Matchers.empty());
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"visible", (Object)0));
        this.client.put(comment.id, PROPERTY_KEY, jsonObject);
        EntityProperty entityProperty = this.client.get(comment.id, PROPERTY_KEY);
        Assert.assertThat((Object)entityProperty.key, (Matcher)Matchers.is((Object)PROPERTY_KEY));
        Assert.assertThat((Object)jsonObject, (Matcher)Matchers.is((Object)new JSONObject(entityProperty.value)));
        List keys = this.client.getKeys((String)comment.id).keys;
        Assert.assertThat((Object)keys, (Matcher)Matchers.hasItem(PropertyAssertions.propertyKey(PROPERTY_KEY)));
        PropertyAssertions.assertWebApplicationException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((EntityPropertyClient)TestCommentPropertyResource.this.client.anonymous()).getKeys(comment.id);
                return null;
            }
        }, Response.Status.UNAUTHORIZED);
        PropertyAssertions.assertWebApplicationException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((EntityPropertyClient)TestCommentPropertyResource.this.client.anonymous()).get(comment.id, TestCommentPropertyResource.PROPERTY_KEY);
                return null;
            }
        }, Response.Status.UNAUTHORIZED);
    }

    @Test
    public void testDeletingProperties() {
        this.administration.restoreBlankInstance();
        this.setupPermissionsToEditComments();
        IssueCreateResponse issue = this.backdoor.issues().createIssue(PROJECT_KEY, "Issue with comment");
        final Comment comment = (Comment)this.backdoor.issues().commentIssue((String)issue.key, (String)"comment with property").body;
        Assert.assertThat((Object)this.client.getKeys((String)comment.id).keys, (Matcher)Matchers.empty());
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"visible", (Object)0));
        this.client.put(comment.id, PROPERTY_KEY, jsonObject);
        EntityProperty entityProperty = this.client.get(comment.id, PROPERTY_KEY);
        Assert.assertThat((Object)entityProperty.key, (Matcher)Matchers.is((Object)PROPERTY_KEY));
        Assert.assertThat((Object)jsonObject, (Matcher)Matchers.is((Object)new JSONObject(entityProperty.value)));
        this.client.delete(comment.id, PROPERTY_KEY);
        Assert.assertThat((Object)this.client.getKeys((String)comment.id).keys, (Matcher)Matchers.empty());
        PropertyAssertions.assertWebApplicationException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestCommentPropertyResource.this.client.get(comment.id, TestCommentPropertyResource.PROPERTY_KEY);
                return null;
            }
        }, Response.Status.NOT_FOUND);
    }

    @Test
    public void testForbiddenForUserWithoutPermissionsToProject() {
        this.backdoor.restoreBlankInstance();
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        IssueCreateResponse issue = this.backdoor.issues().createIssue(PROJECT_KEY, "Issue with comment");
        Comment comment = (Comment)this.backdoor.issues().commentIssue((String)issue.key, (String)"comment with property").body;
        ParsedResponse response = ((EntityPropertyClient)this.client.loginAs("bob", "bob")).put(comment.id, PROPERTY_KEY, new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"visible", (Object)0)));
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN.getStatusCode()));
    }

    @Test
    public void testCommentPropertyRemovedWhenCommentRemoved() {
        this.backdoor.restoreBlankInstance();
        this.setupPermissionsToEditComments();
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        IssueCreateResponse issue = this.backdoor.issues().createIssue(PROJECT_KEY, "Issue with comment");
        final Comment comment = (Comment)this.backdoor.issues().commentIssue((String)issue.key, (String)"comment with property").body;
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"visible", (Object)0));
        this.client.put(comment.id, PROPERTY_KEY, jsonObject);
        EntityProperty entityProperty = this.client.get(comment.id, PROPERTY_KEY);
        Assert.assertThat((Object)entityProperty.key, (Matcher)Matchers.is((Object)PROPERTY_KEY));
        Assert.assertThat((Object)jsonObject, (Matcher)Matchers.is((Object)new JSONObject(entityProperty.value)));
        this.backdoor.issues().deleteIssue(issue.key, true);
        PropertyAssertions.assertWebApplicationException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestCommentPropertyResource.this.client.get(comment.id, TestCommentPropertyResource.PROPERTY_KEY);
                return null;
            }
        }, Response.Status.NOT_FOUND);
    }

    @Test
    public void testCommentPropertyAnonymousAccessUnauthorized() {
        this.backdoor.restoreBlankInstance();
        this.setupPermissionsToEditComments();
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        IssueCreateResponse issue = this.backdoor.issues().createIssue(PROJECT_KEY, "Issue with comment");
        final Comment comment = (Comment)this.backdoor.issues().commentIssue((String)issue.key, (String)"comment with property").body;
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"visible", (Object)0));
        this.client.put(comment.id, PROPERTY_KEY, jsonObject);
        EntityProperty entityProperty = this.client.get(comment.id, PROPERTY_KEY);
        Assert.assertThat((Object)entityProperty.key, (Matcher)Matchers.is((Object)PROPERTY_KEY));
        Assert.assertThat((Object)jsonObject, (Matcher)Matchers.is((Object)new JSONObject(entityProperty.value)));
        PropertyAssertions.assertWebApplicationException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((EntityPropertyClient)TestCommentPropertyResource.this.client.anonymous()).get(comment.id, TestCommentPropertyResource.PROPERTY_KEY);
                return null;
            }
        }, Response.Status.UNAUTHORIZED);
    }

    private void setupPermissionsToEditComments() {
        Long permSchemeId = this.backdoor.permissionSchemes().copyDefaultScheme("comment perm scheme");
        Long projectId = this.backdoor.project().getProjectId(PROJECT_KEY);
        this.backdoor.permissionSchemes().addGroupPermission(permSchemeId, ProjectPermissions.EDIT_ALL_COMMENTS, "jira-administrators");
        this.backdoor.project().setPermissionScheme(projectId, permSchemeId);
    }
}

