/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.CommentClient;
import com.atlassian.jira.testkit.client.restclient.CommentsWithPaginationBean;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.util.BidiUtils;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestCommentResource
extends BaseJiraRestTest {
    private static final String ADMIN_USERNAME = "admin";
    private static final String ADMIN_FULLNAME = "Administrator";
    private static final FeatureFlag BIDI_ESCAPING = FeatureFlag.featureFlag((String)JiraFeatureFlagRegistrar.RTE_WARN_ABOUT_BIDI_CHARS.featureKey());
    private static final String TEST_EDIT_COMMENT_XML_RESOURCE = "TestEditComment.xml";
    private static final String ISSUE_KEY_HSP_1 = "HSP-1";
    private static final String ISSUE_KEY_HSP_2 = "HSP-2";
    private CommentClient commentClient;

    @Before
    public void setUpTest() {
        this.commentClient = new CommentClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testViewCommentNotFound() throws Exception {
        this.backdoor.restoreDataFromResource(TEST_EDIT_COMMENT_XML_RESOURCE);
        ParsedResponse content1 = this.commentClient.getResponse(ISSUE_KEY_HSP_1, "1");
        Assert.assertEquals((long)404L, (long)content1.statusCode);
        Assert.assertEquals((long)1L, (long)content1.entity.errorMessages.size());
        Assert.assertTrue((boolean)content1.entity.errorMessages.contains("Can not find a comment for the id: 1."));
        ParsedResponse contentPiolho = this.commentClient.getResponse(ISSUE_KEY_HSP_1, "piolho");
        Assert.assertEquals((long)404L, (long)contentPiolho.statusCode);
        Assert.assertEquals((long)1L, (long)contentPiolho.entity.errorMessages.size());
        Assert.assertTrue((boolean)contentPiolho.entity.errorMessages.contains("Can not find a comment for the id: piolho."));
    }

    @Test
    public void testAnonymousComment() throws Exception {
        this.backdoor.restoreDataFromResource("TestRESTAnonymous.xml");
        ParsedResponse comment = this.commentClient.get(ISSUE_KEY_HSP_1, "10000");
        Assert.assertNull((Object)((Comment)comment.body).author);
    }

    @Test
    public void testRestrictedByRole() throws Exception {
        this.backdoor.restoreBlankInstance();
        this.backdoor.projectRole().addActors("HSP", "Administrators", new String[0], new String[]{ADMIN_USERNAME});
        String key = this.backdoor.issues().createIssue((String)"HSP", (String)"First Test Issue").key;
        this.backdoor.issues().commentIssueWithVisibility(key, "aa", "role", "Administrators");
        Assert.assertThat((Object)((CommentClient)this.commentClient.loginAs((String)"fred")).get((String)ISSUE_KEY_HSP_1, (String)"10000").statusCode, (Matcher)Matchers.equalTo((Object)404));
    }

    @Test
    public void testViewCommentJson() throws Exception {
        this.backdoor.restoreBlankInstance();
        this.backdoor.projectRole().addActors("MKY", "Administrators", new String[0], new String[]{ADMIN_USERNAME});
        String key = this.backdoor.issues().createIssue((String)"MKY", (String)"First Test Issue").key;
        String commentId = ((Comment)this.backdoor.issues().commentIssueWithVisibility((String)key, (String)"comment", (String)"role", (String)"Administrators").body).id;
        ParsedResponse response = this.commentClient.get(key, commentId);
        Comment json = (Comment)response.body;
        Assert.assertNotNull((Object)json.created);
        Assert.assertNotNull((Object)json.updated);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/issue/10000/comment/10000"), (Object)json.self);
        Assert.assertEquals((Object)"10000", (Object)json.id);
        Assert.assertEquals((Object)"comment", (Object)json.body);
        Assert.assertEquals((Object)"role", (Object)json.visibility.type);
        Assert.assertEquals((Object)"Administrators", (Object)json.visibility.value);
        Assert.assertEquals((Object)ADMIN_USERNAME, (Object)json.author.name);
        Assert.assertEquals((Object)ADMIN_FULLNAME, (Object)json.author.displayName);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/user?username=admin"), (Object)json.author.self);
        Assert.assertEquals((Object)ADMIN_USERNAME, (Object)json.updateAuthor.name);
        Assert.assertEquals((Object)ADMIN_FULLNAME, (Object)json.updateAuthor.displayName);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/user?username=admin"), (Object)json.updateAuthor.self);
    }

    @Test
    public void testViewComments() {
        this.backdoor.restoreDataFromResource(TEST_EDIT_COMMENT_XML_RESOURCE);
        ParsedResponse response = this.commentClient.getComments(ISSUE_KEY_HSP_1);
        Assert.assertEquals((long)0x100000L, (long)((CommentsWithPaginationBean)response.body).getMaxResults().intValue());
        Assert.assertEquals((long)3L, (long)((CommentsWithPaginationBean)response.body).getTotal().intValue());
        Assert.assertEquals((long)3L, (long)((CommentsWithPaginationBean)response.body).getComments().size());
        Comment comment = (Comment)((CommentsWithPaginationBean)response.body).getComments().get(0);
        Assert.assertNotNull((Object)comment.created);
        Assert.assertNotNull((Object)comment.updated);
        Assert.assertEquals((Object)(this.environmentData.getBaseUrl() + "/rest/api/2/issue/10000/comment/10031"), (Object)comment.self);
        Assert.assertEquals((Object)"10031", (Object)comment.id);
        Assert.assertEquals((Object)"I'm a hero!", (Object)comment.body);
        Assert.assertNull((Object)comment.visibility);
        Assert.assertEquals((Object)ADMIN_USERNAME, (Object)comment.author.name);
        Assert.assertEquals((Object)ADMIN_USERNAME, (Object)comment.updateAuthor.name);
    }

    @Test
    public void testCommentOrderingAndPaging() {
        this.backdoor.restoreDataFromResource(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.containsComments((ParsedResponse<CommentsWithPaginationBean>)this.commentClient.getComments(ISSUE_KEY_HSP_1, Integer.valueOf(0), Integer.valueOf(1000), "created"), 10031, 10040, 10041);
        this.containsComments((ParsedResponse<CommentsWithPaginationBean>)this.commentClient.getComments(ISSUE_KEY_HSP_1, Integer.valueOf(0), Integer.valueOf(2), "-created"), 10041, 10040);
        this.containsComments((ParsedResponse<CommentsWithPaginationBean>)this.commentClient.getComments(ISSUE_KEY_HSP_1, Integer.valueOf(2), Integer.valueOf(2), "-created"), 10031);
    }

    private void containsComments(ParsedResponse<CommentsWithPaginationBean> comments, Integer ... ids) {
        List returnedComments = ((CommentsWithPaginationBean)comments.body).getComments().stream().map(comment -> comment.id).map(Integer::valueOf).collect(Collectors.toList());
        Assert.assertThat(returnedComments, (Matcher)Matchers.equalTo(Arrays.asList(ids)));
    }

    @Test
    public void testGetCommentExpandRendered() throws ParseException {
        String body = "*Bolded comment body*";
        String renderedBody = "<p><b>Bolded comment body</b></p>";
        this.backdoor.restoreDataFromResource(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.backdoor.fieldConfiguration().setFieldRenderer("Default Field Configuration", "comment", "Wiki Style Renderer");
        Comment newComment = new Comment();
        newComment.body = "*Bolded comment body*";
        ParsedResponse post = this.commentClient.post(ISSUE_KEY_HSP_1, newComment);
        ParsedResponse get = this.commentClient.get(ISSUE_KEY_HSP_1, ((Comment)post.body).id, "renderedBody");
        Assert.assertEquals((Object)"<p><b>Bolded comment body</b></p>", (Object)((Comment)get.body).renderedBody);
        this.assertTimeIsReturnedInIso8601((ParsedResponse<Comment>)get);
    }

    @Test
    public void testGetCommentsExpandRendered() throws ParseException {
        String body = "*Bolded comment body*";
        String renderedBody = "<p><b>Bolded comment body</b></p>";
        this.backdoor.restoreDataFromResource(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.backdoor.fieldConfiguration().setFieldRenderer("Default Field Configuration", "comment", "Wiki Style Renderer");
        Comment newComment = new Comment();
        newComment.body = "*Bolded comment body*";
        ParsedResponse post = this.commentClient.post(ISSUE_KEY_HSP_1, newComment);
        ParsedResponse response = this.commentClient.getComments(ISSUE_KEY_HSP_1, "renderedBody");
        Comment comment = (Comment)((CommentsWithPaginationBean)response.body).getComments().get(((CommentsWithPaginationBean)response.body).getComments().size() - 1);
        Assert.assertEquals((Object)"<p><b>Bolded comment body</b></p>", (Object)comment.renderedBody);
        this.assertTimeIsReturnedInIso8601((ParsedResponse<Comment>)post);
    }

    @Test
    public void testBidiEscapedInComment() {
        this.backdoor.restoreDataFromResource(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.backdoor.fieldConfiguration().setFieldRenderer("Default Field Configuration", "comment", "Wiki Style Renderer");
        Comment newComment = new Comment();
        newComment.body = String.format("{code}%1$s{code}{noformat}%1$s{noformat}", BidiUtils.getBidis());
        ParsedResponse created = this.commentClient.post(ISSUE_KEY_HSP_1, newComment);
        Assert.assertEquals((Object)(BidiUtils.getCodePanelWithEscapedBidis() + BidiUtils.getNoFormatPanelWithEscapedBidis()), (Object)((Comment)this.commentClient.get((String)ISSUE_KEY_HSP_1, (String)((Comment)created.body).id, (String)"renderedBody").body).renderedBody);
    }

    @Test
    public void testBidiNotEscapedInComment() {
        this.backdoor.restoreDataFromResource(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.backdoor.darkFeatures().disableForSite(BIDI_ESCAPING);
        this.backdoor.fieldConfiguration().setFieldRenderer("Default Field Configuration", "comment", "Wiki Style Renderer");
        Comment newComment = new Comment();
        newComment.body = String.format("{code}%1$s{code}{noformat}%1$s{noformat}", BidiUtils.getBidis());
        ParsedResponse created = this.commentClient.post(ISSUE_KEY_HSP_1, newComment);
        Assert.assertEquals((Object)(BidiUtils.getCodePanelWithUnescapedBidis() + BidiUtils.getNoFormatPanelWithUnescapedBidis()), (Object)((Comment)this.commentClient.get((String)ISSUE_KEY_HSP_1, (String)((Comment)created.body).id, (String)"renderedBody").body).renderedBody);
    }

    private void assertTimeIsReturnedInIso8601(ParsedResponse<Comment> get) throws ParseException {
        SimpleDateFormat isoFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        isoFormatter.parse(((Comment)get.body).created);
        isoFormatter.parse(((Comment)get.body).updated);
    }

    @Test
    public void testEditComment() {
        this.backdoor.restoreDataFromResource(TEST_EDIT_COMMENT_XML_RESOURCE);
        ParsedResponse comparison = this.commentClient.get(ISSUE_KEY_HSP_1, "10031");
        Comment newComment = new Comment();
        newComment.body = "new comment body";
        newComment.visibility = new Visibility("group", "jira-administrators");
        newComment.id = ((Comment)comparison.body).id;
        ((Comment)comparison.body).body = newComment.body;
        ((Comment)comparison.body).visibility = newComment.visibility;
        ParsedResponse put = this.commentClient.put(ISSUE_KEY_HSP_1, newComment);
        Assert.assertNotNull((Object)put);
        Assert.assertEquals((long)200L, (long)put.statusCode);
        this.assertCommentsEqual((Comment)comparison.body, (Comment)put.body);
        ParsedResponse reget = this.commentClient.get(ISSUE_KEY_HSP_1, "10031");
        this.assertCommentsEqual((Comment)comparison.body, (Comment)reget.body);
    }

    @Test
    public void testEditCommentExpandRendered() {
        String body = "*Bolded comment body*";
        String renderedBody = "<p><b>Bolded comment body</b></p>";
        this.backdoor.restoreDataFromResource(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.backdoor.fieldConfiguration().setFieldRenderer("Default Field Configuration", "comment", "Wiki Style Renderer");
        ParsedResponse comparison = this.commentClient.get(ISSUE_KEY_HSP_1, "10031");
        Comment newComment = new Comment();
        newComment.body = "*Bolded comment body*";
        newComment.id = ((Comment)comparison.body).id;
        ParsedResponse post = this.commentClient.put(ISSUE_KEY_HSP_1, newComment, "renderedBody");
        Assert.assertEquals((Object)"<p><b>Bolded comment body</b></p>", (Object)((Comment)post.body).renderedBody);
    }

    @Test
    public void testEditCommentWhenRoleDoesntExist() {
        this.backdoor.restoreDataFromResource(TEST_EDIT_COMMENT_XML_RESOURCE);
        ParsedResponse comment = this.commentClient.get(ISSUE_KEY_HSP_1, "10031");
        Comment newComment = new Comment();
        newComment.id = ((Comment)comment.body).id;
        newComment.body = "new comment body";
        newComment.visibility = new Visibility("role", "not-existing-role");
        ParsedResponse post = this.commentClient.put(ISSUE_KEY_HSP_1, newComment);
        Assert.assertEquals((long)400L, (long)post.statusCode);
        Assert.assertEquals((long)1L, (long)post.entity.errors.size());
    }

    @Test
    public void testEditCommentWhenGroupDoesntExist() {
        this.backdoor.restoreDataFromResource(TEST_EDIT_COMMENT_XML_RESOURCE);
        ParsedResponse comment = this.commentClient.get(ISSUE_KEY_HSP_1, "10031");
        Comment newComment = new Comment();
        newComment.id = ((Comment)comment.body).id;
        newComment.body = "new comment body";
        newComment.visibility = new Visibility("group", "not-existing-group");
        ParsedResponse post = this.commentClient.put(ISSUE_KEY_HSP_1, newComment);
        Assert.assertEquals((long)400L, (long)post.statusCode);
        Assert.assertEquals((long)1L, (long)post.entity.errors.size());
    }

    @Test
    public void testAddComment() {
        this.backdoor.restoreDataFromResource(TEST_EDIT_COMMENT_XML_RESOURCE);
        Comment newComment = new Comment();
        newComment.body = "new comment body";
        newComment.visibility = new Visibility("group", "jira-administrators");
        ParsedResponse post = this.commentClient.post(ISSUE_KEY_HSP_1, newComment);
        Assert.assertNotNull((Object)post);
        Assert.assertEquals((long)201L, (long)post.statusCode);
        Assert.assertNotNull((Object)post.body);
        Assert.assertEquals((Object)"new comment body", (Object)((Comment)post.body).body);
        Assert.assertEquals((Object)"group", (Object)((Comment)post.body).visibility.type);
        Assert.assertEquals((Object)"jira-administrators", (Object)((Comment)post.body).visibility.value);
        ParsedResponse reget = this.commentClient.get(ISSUE_KEY_HSP_1, ((Comment)post.body).id);
        this.assertCommentsEqual((Comment)post.body, (Comment)reget.body);
        newComment = new Comment();
        post = this.commentClient.post(ISSUE_KEY_HSP_1, newComment);
        Assert.assertEquals((long)400L, (long)post.statusCode);
        Assert.assertEquals((long)1L, (long)post.entity.errors.size());
    }

    @Test
    public void testAddCommentExpandRendered() {
        String body = "*Bolded comment body*";
        String renderedBody = "<p><b>Bolded comment body</b></p>";
        this.backdoor.restoreDataFromResource(TEST_EDIT_COMMENT_XML_RESOURCE);
        this.backdoor.fieldConfiguration().setFieldRenderer("Default Field Configuration", "comment", "Wiki Style Renderer");
        Comment newComment = new Comment();
        newComment.body = "*Bolded comment body*";
        ParsedResponse post = this.commentClient.post(ISSUE_KEY_HSP_1, newComment, "renderedBody");
        Assert.assertEquals((Object)"<p><b>Bolded comment body</b></p>", (Object)((Comment)post.body).renderedBody);
    }

    @Test
    public void testAddCommentWhenRoleDoesntExist() {
        this.backdoor.restoreDataFromResource(TEST_EDIT_COMMENT_XML_RESOURCE);
        Comment newComment = new Comment();
        newComment.body = "new comment body";
        newComment.visibility = new Visibility("role", "not-existing-role");
        ParsedResponse post = this.commentClient.post(ISSUE_KEY_HSP_1, newComment);
        Assert.assertEquals((long)400L, (long)post.statusCode);
        Assert.assertEquals((long)1L, (long)post.entity.errors.size());
    }

    @Test
    public void testAddCommentWhenGroupDoesntExist() {
        this.backdoor.restoreDataFromResource(TEST_EDIT_COMMENT_XML_RESOURCE);
        Comment newComment = new Comment();
        newComment.body = "new comment body";
        newComment.visibility = new Visibility("group", "not-existing-group");
        ParsedResponse post = this.commentClient.post(ISSUE_KEY_HSP_1, newComment);
        Assert.assertEquals((long)400L, (long)post.statusCode);
        Assert.assertEquals((long)1L, (long)post.entity.errors.size());
    }

    @Test
    public void testDeleteComment() {
        this.backdoor.restoreDataFromResource(TEST_EDIT_COMMENT_XML_RESOURCE);
        Comment newComment = new Comment();
        newComment.body = "new comment body";
        newComment.visibility = new Visibility("group", "jira-administrators");
        ParsedResponse put = this.commentClient.post(ISSUE_KEY_HSP_1, newComment);
        ParsedResponse deleteResponse = this.commentClient.delete(ISSUE_KEY_HSP_1, (Comment)put.body);
        Assert.assertEquals((long)204L, (long)deleteResponse.statusCode);
        ParsedResponse response = this.commentClient.getResponse(ISSUE_KEY_HSP_1, ((Comment)put.body).id);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertEquals((long)1L, (long)response.entity.errorMessages.size());
        Assert.assertTrue((boolean)((String)response.entity.errorMessages.get(0)).startsWith("Can not find a comment for the id: 10050."));
        deleteResponse = this.commentClient.delete(ISSUE_KEY_HSP_1, (Comment)put.body);
        Assert.assertEquals((long)404L, (long)deleteResponse.statusCode);
        Assert.assertEquals((long)1L, (long)deleteResponse.entity.errorMessages.size());
        Assert.assertTrue((boolean)((String)deleteResponse.entity.errorMessages.get(0)).startsWith("Can not find a comment for the id: 10050."));
    }

    @Test
    public void testIncorrectIssueKey() {
        ParsedResponse response = this.commentClient.getComments("NONEXISTANT-1");
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertEquals((long)1L, (long)response.entity.errorMessages.size());
        Assert.assertTrue((boolean)((String)response.entity.errorMessages.get(0)).startsWith("Issue Does Not Exist"));
        ParsedResponse response2 = this.commentClient.get("NONEXISTANT-1", "00000");
        Assert.assertEquals((long)404L, (long)response2.statusCode);
        Assert.assertEquals((long)1L, (long)response2.entity.errorMessages.size());
        Assert.assertTrue((boolean)((String)response2.entity.errorMessages.get(0)).startsWith("Issue Does Not Exist"));
    }

    @Test
    public void testGetCommentFromWrongIssue() {
        this.backdoor.restoreDataFromResource(TEST_EDIT_COMMENT_XML_RESOURCE);
        ParsedResponse goodResponse = this.commentClient.getComments(ISSUE_KEY_HSP_1);
        Comment comment = (Comment)((CommentsWithPaginationBean)goodResponse.body).getComments().get(0);
        ParsedResponse response = this.commentClient.get(ISSUE_KEY_HSP_2, comment.id);
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertEquals((long)1L, (long)response.entity.errorMessages.size());
        Assert.assertTrue((boolean)((String)response.entity.errorMessages.get(0)).startsWith("No comment with given ID found for issue HSP-2"));
    }

    @Test
    public void testAdminCanEditAndDeleteAllComments() throws Exception {
        this.backdoor.restoreDataFromResource("TestCommentPermissions.xml");
        ParsedResponse comments = this.commentClient.getComments("RAT-2");
        Assert.assertEquals((long)3L, (long)((CommentsWithPaginationBean)comments.body).getComments().size());
        ParsedResponse original = this.commentClient.get("RAT-2", "10000");
        ((Comment)original.body).body = "admin edited comment";
        ParsedResponse updated = this.commentClient.put("RAT-2", (Comment)original.body);
        this.assertCommentsEqual((Comment)updated.body, (Comment)original.body);
        Assert.assertEquals((long)200L, (long)updated.statusCode);
        original = this.commentClient.get("RAT-2", "10001");
        ((Comment)original.body).body = "admin edited comment";
        updated = this.commentClient.put("RAT-2", (Comment)original.body);
        this.assertCommentsEqual((Comment)updated.body, (Comment)original.body);
        Assert.assertEquals((long)200L, (long)updated.statusCode);
        original = this.commentClient.get("RAT-2", "10002");
        ((Comment)original.body).body = "admin edited comment";
        updated = this.commentClient.put("RAT-2", (Comment)original.body);
        this.assertCommentsEqual((Comment)updated.body, (Comment)original.body);
        Assert.assertEquals((long)200L, (long)updated.statusCode);
        ParsedResponse deleteResponse = this.commentClient.delete("RAT-2", "10001");
        Assert.assertEquals((long)204L, (long)deleteResponse.statusCode);
        deleteResponse = this.commentClient.delete("RAT-2", "10002");
        Assert.assertEquals((long)204L, (long)deleteResponse.statusCode);
        deleteResponse = this.commentClient.delete("RAT-2", "10000");
        Assert.assertEquals((long)204L, (long)deleteResponse.statusCode);
    }

    @Test
    public void testFredCanEditAndDeleteOwnComments() throws Exception {
        this.backdoor.restoreDataFromResource("TestCommentPermissions.xml");
        this.commentClient.loginAs("fred");
        ParsedResponse comments = this.commentClient.getComments("RAT-2");
        Assert.assertEquals((long)3L, (long)((CommentsWithPaginationBean)comments.body).getComments().size());
        ParsedResponse original = this.commentClient.get("RAT-2", "10001");
        ((Comment)original.body).body = "fred edited comment";
        ParsedResponse updated = this.commentClient.put("RAT-2", (Comment)original.body);
        this.assertCommentsEqual((Comment)updated.body, (Comment)original.body);
        Assert.assertEquals((long)200L, (long)updated.statusCode);
        original = this.commentClient.get("RAT-2", "10000");
        String originalBody = ((Comment)original.body).body;
        ((Comment)original.body).body = "fred edited comment";
        updated = this.commentClient.put("RAT-2", (Comment)original.body);
        Assert.assertEquals((long)400L, (long)updated.statusCode);
        Assert.assertEquals((long)1L, (long)updated.entity.errorMessages.size());
        Assert.assertTrue((boolean)((String)updated.entity.errorMessages.get(0)).contains("do not have the permission to edit this comment."));
        ((Comment)original.body).body = originalBody;
        ParsedResponse reget = this.commentClient.get("RAT-2", "10000");
        this.assertCommentsEqual((Comment)reget.body, (Comment)original.body);
        ParsedResponse deleteResponse = this.commentClient.delete("RAT-2", "10001");
        Assert.assertEquals((long)204L, (long)deleteResponse.statusCode);
        original = this.commentClient.get("RAT-2", "10002");
        deleteResponse = this.commentClient.delete("RAT-2", "10002");
        Assert.assertEquals((long)400L, (long)deleteResponse.statusCode);
        Assert.assertEquals((long)1L, (long)deleteResponse.entity.errorMessages.size());
        Assert.assertTrue((boolean)((String)deleteResponse.entity.errorMessages.get(0)).contains("You do not have permission to delete comment with id"));
        reget = this.commentClient.get("RAT-2", "10002");
        Assert.assertEquals((long)200L, (long)reget.statusCode);
        Assert.assertNotNull((Object)reget.body);
        this.assertCommentsEqual((Comment)original.body, (Comment)reget.body);
    }

    @Test
    public void testAnonCanEditAndDeleteNothing() throws Exception {
        this.backdoor.restoreDataFromResource("TestCommentPermissions.xml");
        this.commentClient.anonymous();
        ParsedResponse comments = this.commentClient.getComments("RAT-2");
        Assert.assertEquals((long)3L, (long)((CommentsWithPaginationBean)comments.body).getComments().size());
        ParsedResponse original = this.commentClient.get("RAT-2", "10000");
        String originalBody = ((Comment)original.body).body;
        ((Comment)original.body).body = "fred edited comment";
        ParsedResponse updated = this.commentClient.put("RAT-2", (Comment)original.body);
        Assert.assertEquals((long)400L, (long)updated.statusCode);
        Assert.assertEquals((long)1L, (long)updated.entity.errorMessages.size());
        Assert.assertTrue((boolean)((String)updated.entity.errorMessages.get(0)).startsWith("You do not have the permission to edit this comment."));
        ((Comment)original.body).body = originalBody;
        ParsedResponse reget = this.commentClient.get("RAT-2", "10000");
        this.assertCommentsEqual((Comment)reget.body, (Comment)original.body);
        original = this.commentClient.get("RAT-2", "10000");
        originalBody = ((Comment)original.body).body;
        ((Comment)original.body).body = "fred edited comment";
        updated = this.commentClient.put("RAT-2", (Comment)original.body);
        Assert.assertEquals((long)400L, (long)updated.statusCode);
        Assert.assertEquals((long)1L, (long)updated.entity.errorMessages.size());
        Assert.assertTrue((boolean)((String)updated.entity.errorMessages.get(0)).startsWith("You do not have the permission to edit this comment."));
        ((Comment)original.body).body = originalBody;
        reget = this.commentClient.get("RAT-2", "10000");
        this.assertCommentsEqual((Comment)reget.body, (Comment)original.body);
        original = this.commentClient.get("RAT-2", "10002");
        ParsedResponse deleteResponse = this.commentClient.delete("RAT-2", "10002");
        Assert.assertEquals((long)400L, (long)deleteResponse.statusCode);
        Assert.assertEquals((long)1L, (long)deleteResponse.entity.errorMessages.size());
        Assert.assertTrue((boolean)((String)deleteResponse.entity.errorMessages.get(0)).startsWith("You do not have permission to delete comment with id"));
        reget = this.commentClient.get("RAT-2", "10002");
        Assert.assertEquals((long)200L, (long)reget.statusCode);
        Assert.assertNotNull((Object)reget.body);
        this.assertCommentsEqual((Comment)original.body, (Comment)reget.body);
        original = this.commentClient.get("RAT-2", "10002");
        deleteResponse = this.commentClient.delete("RAT-2", "10002");
        Assert.assertEquals((long)400L, (long)deleteResponse.statusCode);
        Assert.assertEquals((long)1L, (long)deleteResponse.entity.errorMessages.size());
        Assert.assertTrue((boolean)((String)deleteResponse.entity.errorMessages.get(0)).startsWith("You do not have permission to delete comment with id"));
        reget = this.commentClient.get("RAT-2", "10002");
        Assert.assertEquals((long)200L, (long)reget.statusCode);
        Assert.assertNotNull((Object)reget.body);
        this.assertCommentsEqual((Comment)original.body, (Comment)reget.body);
    }

    @Test
    public void testCanAddCommentWhenNoIssueEditPerm() {
        this.backdoor.restoreDataFromResource("TestIssueResourceEditMeta.xml");
        IssueClient issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
        Issue issue = ((IssueClient)issueClient.loginAs("farnsworth")).get("PH-1", new Issue.Expand[]{Issue.Expand.editmeta});
        Assert.assertNotNull((Object)issue.editmeta);
        Assert.assertTrue((boolean)issue.editmeta.fields.isEmpty());
        Comment newComment = new Comment();
        newComment.body = "new comment body";
        ParsedResponse post = ((CommentClient)this.commentClient.loginAs("farnsworth")).post("PH-1", newComment);
        Assert.assertNotNull((Object)post);
        Assert.assertEquals((long)201L, (long)post.statusCode);
        Assert.assertNotNull((Object)post.body);
        Assert.assertEquals((Object)"new comment body", (Object)((Comment)post.body).body);
        ParsedResponse reget = ((CommentClient)this.commentClient.loginAs("farnsworth")).get("PH-1", ((Comment)post.body).id);
        this.assertCommentsEqual((Comment)post.body, (Comment)reget.body);
    }

    @Test
    public void testSettingPropertyDuringCreate() {
        this.backdoor.restoreBlankInstance();
        this.setupPermissionsToEditComments();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with comments properties");
        Comment comment = new Comment();
        comment.body = "comment with properties";
        HashMap<String, Object> commentPropValue = new HashMap<String, Object>();
        commentPropValue.put("value", "proper-val");
        Comment.CommentProperty commentProperty = new Comment.CommentProperty("key", new JSONObject(commentPropValue).toString());
        comment.properties = Lists.newArrayList((Object[])new Comment.CommentProperty[]{commentProperty});
        Comment commentResponse = (Comment)this.commentClient.post((String)issue.key, (Comment)comment, (String)"properties").body;
        Assert.assertThat((Object)commentResponse.body, (Matcher)Matchers.is((Object)"comment with properties"));
        Assert.assertThat((Object)commentResponse.properties, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"key", (Matcher)Matchers.is((Object)"key")), (Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.containsString((String)"proper-val")))));
    }

    @Test
    public void testUpdateCommentWithProperty() {
        this.backdoor.restoreBlankInstance();
        this.setupPermissionsToEditComments();
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with comments properties");
        Comment comment = new Comment();
        comment.body = "comment with properties";
        Comment commentCreateResponse = (Comment)this.commentClient.post((String)issue.key, (Comment)comment, (String)"properties").body;
        Assert.assertThat((Object)commentCreateResponse.body, (Matcher)Matchers.is((Object)"comment with properties"));
        Assert.assertThat((Object)commentCreateResponse.properties, (Matcher)Matchers.hasSize((int)0));
        Comment updatedComment = new Comment();
        updatedComment.body = "comment with updated properties";
        updatedComment.id = commentCreateResponse.id;
        HashMap<String, Object> commentPropValue = new HashMap<String, Object>();
        commentPropValue.put("value", "proper-val");
        Comment.CommentProperty commentProperty = new Comment.CommentProperty("key", new JSONObject(commentPropValue).toString());
        updatedComment.properties = Lists.newArrayList((Object[])new Comment.CommentProperty[]{commentProperty});
        Comment updatedCommentResponse = (Comment)this.commentClient.put((String)issue.key, (Comment)updatedComment, (String)"properties").body;
        Assert.assertThat((Object)updatedCommentResponse.body, (Matcher)Matchers.is((Object)"comment with updated properties"));
        Assert.assertThat((Object)updatedCommentResponse.properties, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"key", (Matcher)Matchers.is((Object)"key")), (Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.containsString((String)"proper-val")))));
    }

    private void setupPermissionsToEditComments() {
        Long permSchemeId = this.backdoor.permissionSchemes().copyDefaultScheme("comment perm scheme");
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.backdoor.permissionSchemes().addGroupPermission(permSchemeId, ProjectPermissions.EDIT_ALL_COMMENTS, "jira-users");
        this.backdoor.project().setPermissionScheme(projectId, permSchemeId);
    }

    public void assertCommentsEqual(Comment comment1, Comment comment2) {
        Assert.assertEquals((Object)comment1.self, (Object)comment2.self);
        Assert.assertEquals((Object)comment1.id, (Object)comment2.id);
        Assert.assertEquals((Object)comment1.body, (Object)comment2.body);
        if (comment1.author == null && comment2.author != null || comment1.author != null && comment2.author == null) {
            throw new AssertionError((Object)"Authors not the same, one null, the other not");
        }
        if (comment1.author != null && comment2.author != null) {
            Assert.assertEquals((Object)comment1.author.displayName, (Object)comment1.author.displayName);
        }
        if (comment1.visibility == null && comment2.visibility != null || comment1.visibility != null && comment2.visibility == null) {
            throw new AssertionError((Object)"Visibility not the same, one null, the other not");
        }
        if (comment1.visibility != null && comment2.visibility != null) {
            Assert.assertEquals((Object)comment1.visibility.type, (Object)comment2.visibility.type);
            Assert.assertEquals((Object)comment1.visibility.value, (Object)comment2.visibility.value);
        }
    }
}

