/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.ComponentClient;
import com.atlassian.jira.testkit.client.restclient.ComponentIssueCounts;
import com.atlassian.jira.testkit.client.restclient.Errors;
import com.atlassian.jira.testkit.client.restclient.PageBean;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.SearchClient;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.testkit.client.restclient.User;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestComponentResource.xml")
@LoginAs(user="admin")
public class TestComponentResource
extends BaseJiraFuncTest {
    public static final String EMPTY_STRING = "";
    public static final String NEW_COMPONENT_3 = "New Component 3";
    public static final String NEW_COMPONENT_1 = "New Component 1";
    public static final String NEW_COMPONENT_2 = "New Component 2";
    public static final String COMPONENT_NAME = "Sausages";
    public static final String COMPONENT_DESCRIPTION = "Lamb and Rosemary";
    public static final String COMPONENT_ID = "10001";
    private ComponentClient componentClient;
    private SearchClient searchClient;
    @Inject
    private FuncTestUrlHelper funcTestUrlHelper;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.componentClient = new ComponentClient((JIRAEnvironmentData)this.environmentData);
        this.searchClient = new SearchClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testViewComponent() throws Exception {
        Long componentID = 10000L;
        Component component = this.componentClient.get(componentID.toString());
        Component expectedComponent = this.getInitialComponent(componentID);
        Assert.assertEquals((Object)expectedComponent, (Object)component);
        Assert.assertNull((Object)component.lead);
    }

    @Test
    public void testViewComponentNotFound() throws Exception {
        ParsedResponse response123 = this.componentClient.getResponse("123");
        Assert.assertEquals((long)404L, (long)response123.statusCode);
        Assert.assertTrue((boolean)response123.entity.errorMessages.contains("The component with id 123 does not exist."));
        ParsedResponse responseAbc = this.componentClient.getResponse("abc");
        Assert.assertEquals((long)404L, (long)responseAbc.statusCode);
        Assert.assertTrue((boolean)responseAbc.entity.errorMessages.contains("The component with id abc does not exist."));
    }

    @Test
    public void testCreateComponent() {
        Component inputComponent = new Component().project("MKY").name(COMPONENT_NAME).description(COMPONENT_DESCRIPTION).leadUserName("fred").assigneeType(Component.AssigneeType.COMPONENT_LEAD);
        Component newComponent = this.componentClient.get(this.componentClient.create((Component)inputComponent).id.toString());
        this.assertSameComponent(inputComponent, newComponent);
        inputComponent = new Component().project("MKY").name("Chops").description("Lamb short loin").assigneeType(Component.AssigneeType.PROJECT_DEFAULT);
        newComponent = this.componentClient.get(this.componentClient.create((Component)inputComponent).id.toString());
        this.assertSameComponent(inputComponent, newComponent);
        inputComponent = new Component().project("MKY").name("potatoes").leadUserName("fred").assigneeType(Component.AssigneeType.PROJECT_DEFAULT);
        newComponent = this.componentClient.get(this.componentClient.create((Component)inputComponent).id.toString());
        this.assertSameComponent(inputComponent, newComponent);
        inputComponent = new Component().project("MKY").name("onions");
        newComponent = this.componentClient.get(this.componentClient.create((Component)inputComponent).id.toString());
        Component expectedComponent = new Component().project("MKY").name("onions").assigneeType(Component.AssigneeType.PROJECT_DEFAULT);
        this.assertSameComponent(expectedComponent, newComponent);
    }

    @Test
    public void testCreateComponentErrors() throws Exception {
        ParsedResponse response = this.componentClient.createResponse(new Component());
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((Object)new Errors().addError("A project id must be specified for this operation."), (Object)response.entity);
    }

    @Test
    public void testCreateComponentWithBadProject() {
        Component inputComponent = new Component().project("BAD").name(COMPONENT_NAME).description(COMPONENT_DESCRIPTION).leadUserName("fred").assigneeType(Component.AssigneeType.COMPONENT_LEAD);
        ParsedResponse response = this.componentClient.createResponse(inputComponent);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((Object)new Errors().addError("No project could be found with key 'BAD'."), (Object)response.entity);
    }

    @Test
    public void testCreateComponentWithoutName() {
        Component inputComponent = new Component().project("MKY").id(Long.valueOf(10000L)).description(COMPONENT_DESCRIPTION).leadUserName("fred").assigneeType(Component.AssigneeType.COMPONENT_LEAD);
        ParsedResponse response = this.componentClient.createResponse(inputComponent);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((Object)new Errors().addError("name", "The component name specified is invalid - cannot be an empty string."), (Object)response.entity);
    }

    @Test
    public void testCreateComponentWithDuplicateName() {
        Component inputComponent = new Component().project("MKY").id(Long.valueOf(10000L)).name(COMPONENT_NAME).description(COMPONENT_DESCRIPTION).leadUserName("fred").assigneeType(Component.AssigneeType.COMPONENT_LEAD);
        this.componentClient.create(inputComponent);
        inputComponent = new Component().project("MKY").id(Long.valueOf(10000L)).name(COMPONENT_NAME).description(COMPONENT_DESCRIPTION).leadUserName("fred").assigneeType(Component.AssigneeType.COMPONENT_LEAD);
        ParsedResponse response = this.componentClient.createResponse(inputComponent);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((Object)new Errors().addError("name", "A component with the name Sausages already exists in this project."), (Object)response.entity);
    }

    @Test
    public void testCreateComponentWithInvalidUsername() {
        Component inputComponent = new Component().project("MKY").id(Long.valueOf(10000L)).name("C1").description(COMPONENT_DESCRIPTION).leadUserName("notfred").assigneeType(Component.AssigneeType.COMPONENT_LEAD);
        ParsedResponse response = this.componentClient.createResponse(inputComponent);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((Object)new Errors().addError("leadUserName", "The user notfred does not exist.").addError("componentLead", "The user notfred does not exist."), (Object)response.entity);
    }

    @Test
    public void testCreateComponentWithoutPermissions() {
        Component inputComponent = new Component().project("MKY").id(Long.valueOf(10001L)).name("Chops").description("Lamb short loin").assigneeType(Component.AssigneeType.PROJECT_DEFAULT);
        ParsedResponse response = ((ComponentClient)this.componentClient.loginAs("fred")).createResponse(inputComponent);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((Object)new Errors().addError("You cannot edit the configuration of this project."), (Object)response.entity);
    }

    @Test
    public void testCreateComponentWithAnonymousUser() {
        ParsedResponse notFoundResp = ((ComponentClient)this.componentClient.anonymous()).createResponse(new Component().project("MKY").name("some name"));
        MatcherAssert.assertThat((Object)notFoundResp.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }

    @Test
    public void testCreateComponentWithoutPermissionsToConfigureProject() {
        ParsedResponse unauthorisedResp = ((ComponentClient)this.componentClient.anonymous()).createResponse(new Component().project("HSP").name("component"));
        MatcherAssert.assertThat((Object)unauthorisedResp.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.UNAUTHORIZED.getStatusCode()));
    }

    @Test
    public void testEditComponent() throws Exception {
        Component expectedComponent = this.getInitialComponent();
        Component inputComponent = new Component().name(COMPONENT_NAME).description(COMPONENT_DESCRIPTION).leadUserName("fred").assigneeType(Component.AssigneeType.COMPONENT_LEAD).self(expectedComponent.self);
        expectedComponent.name(COMPONENT_NAME).description(COMPONENT_DESCRIPTION).leadUserName("fred").assigneeType(Component.AssigneeType.COMPONENT_LEAD);
        this.verifyEdit(expectedComponent, inputComponent);
        inputComponent = new Component().name("Hamburger").self(expectedComponent.self);
        expectedComponent.name("Hamburger");
        this.verifyEdit(expectedComponent, inputComponent);
        inputComponent = new Component().description("Beef mince to you and me").self(expectedComponent.self);
        expectedComponent.description("Beef mince to you and me");
        this.verifyEdit(expectedComponent, inputComponent);
        inputComponent = new Component().assigneeType(Component.AssigneeType.COMPONENT_LEAD).self(expectedComponent.self);
        expectedComponent.assigneeType(Component.AssigneeType.COMPONENT_LEAD);
        this.verifyEdit(expectedComponent, inputComponent);
        inputComponent = new Component().assigneeType(Component.AssigneeType.UNASSIGNED).self(expectedComponent.self);
        expectedComponent.assigneeType(Component.AssigneeType.UNASSIGNED);
        this.verifyEdit(expectedComponent, inputComponent);
        inputComponent = new Component().leadUserName("admin").self(expectedComponent.self);
        expectedComponent.leadUserName("admin");
        this.verifyEdit(expectedComponent, inputComponent);
        inputComponent = new Component().leadUserName(EMPTY_STRING).self(expectedComponent.self);
        expectedComponent.leadUserName(null);
        expectedComponent.lead(null);
        this.verifyEdit(expectedComponent, inputComponent);
    }

    @Test
    public void testEditComponentErrors() throws Exception {
        Component expectedComponent = this.getInitialComponent();
        Component editComponent = new Component().name(NEW_COMPONENT_2).self(expectedComponent.self);
        ParsedResponse response = this.componentClient.putResponse(editComponent);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((Object)new Errors().addError("name", "A component with the name New Component 2 already exists in this project."), (Object)response.entity);
        editComponent = new Component().name(EMPTY_STRING).self(expectedComponent.self);
        response = this.componentClient.putResponse(editComponent);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((Object)new Errors().addError("name", "The component name specified is invalid - cannot be an empty string."), (Object)response.entity);
        editComponent = new Component().leadUserName("notfred").self(expectedComponent.self);
        response = this.componentClient.putResponse(editComponent);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((Object)new Errors().addError("leadUserName", "The user notfred does not exist.").addError("componentLead", "The user notfred does not exist."), (Object)response.entity);
        editComponent = new Component().name("Not authorised").self(expectedComponent.self);
        response = ((ComponentClient)this.componentClient.loginAs("fred")).putResponse(editComponent);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
        Assert.assertEquals((Object)new Errors().addError("The user fred does not have permission to complete this operation."), (Object)response.entity);
        String compId = this.administration.project().addComponent("MKY", "Galho", "Galho do macaco", "admin");
        response = ((ComponentClient)this.componentClient.anonymous()).putResponse(compId, new Component().name("Other"));
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        MatcherAssert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.hasItem((Object)"The component with id 10001 does not exist."));
        response = ((ComponentClient)this.componentClient.anonymous()).putResponse("gugu", new Component().name("Other"));
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        MatcherAssert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.hasItem((Object)"The component with id gugu does not exist."));
        response = ((ComponentClient)this.componentClient.anonymous()).putResponse(new Component().name(NEW_COMPONENT_1).self(expectedComponent.self));
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.UNAUTHORIZED.getStatusCode()));
    }

    private void verifyEdit(Component expectedComponent, Component editComponent) {
        this.componentClient.putResponse(editComponent);
        this.assertSameComponent(expectedComponent, this.componentClient.get(expectedComponent.id.toString()));
    }

    private Component getInitialComponent() {
        Long componentID = 10000L;
        Component actualComponent = this.componentClient.get(componentID.toString());
        Component expectedComponent = this.getInitialComponent(componentID);
        Assert.assertEquals((Object)expectedComponent, (Object)actualComponent);
        return actualComponent;
    }

    private User createUserAdmin() {
        LinkedHashMap<String, String> avatarUrls = new LinkedHashMap<String, String>();
        avatarUrls.put("16x16", this.funcTestUrlHelper.getBaseUrlPlus("secure/useravatar?size=xsmall&avatarId=10062"));
        avatarUrls.put("24x24", this.funcTestUrlHelper.getBaseUrlPlus("secure/useravatar?size=small&avatarId=10062"));
        avatarUrls.put("32x32", this.funcTestUrlHelper.getBaseUrlPlus("secure/useravatar?size=medium&avatarId=10062"));
        avatarUrls.put("48x48", this.funcTestUrlHelper.getBaseUrlPlus("secure/useravatar?avatarId=10062"));
        return new User().self(this.createUserUri("admin")).name("admin").key("admin").displayName("Administrator").active(true).avatarUrls(avatarUrls);
    }

    private URI createUserUri(String name) {
        return this.funcTestUrlHelper.getRestApiUri(String.format("user?username=%s", name));
    }

    private URI createSelfLink(long id) {
        return this.funcTestUrlHelper.getRestApiUri("component", String.valueOf(id));
    }

    @Test
    public void testGetComponentIssueCounts() throws Exception {
        ComponentIssueCounts counts = this.componentClient.getComponentIssueCounts("10000");
        Assert.assertEquals((long)0L, (long)counts.issueCount);
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Issue for voting test");
        this.navigation.issue().setComponents(issueKey, NEW_COMPONENT_1);
        counts = this.componentClient.getComponentIssueCounts("10000");
        Assert.assertEquals((long)1L, (long)counts.issueCount);
        issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Issue for voting test");
        this.navigation.issue().setComponents(issueKey, NEW_COMPONENT_2);
        counts = this.componentClient.getComponentIssueCounts("10000");
        Assert.assertEquals((long)1L, (long)counts.issueCount);
        counts = this.componentClient.getComponentIssueCounts(COMPONENT_ID);
        Assert.assertEquals((long)1L, (long)counts.issueCount);
        issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Issue for voting test");
        this.navigation.issue().setComponents(issueKey, NEW_COMPONENT_2);
        counts = this.componentClient.getComponentIssueCounts("10000");
        Assert.assertEquals((long)1L, (long)counts.issueCount);
        counts = this.componentClient.getComponentIssueCounts(COMPONENT_ID);
        Assert.assertEquals((long)2L, (long)counts.issueCount);
        counts = ((ComponentClient)this.componentClient.loginAs("fred")).getComponentIssueCounts(COMPONENT_ID);
        Assert.assertEquals((long)2L, (long)counts.issueCount);
    }

    @Test
    public void testGetVersionIssueCountsNotFound() throws Exception {
        ParsedResponse resp1 = this.componentClient.getComponentIssueCountsResponse("1");
        Assert.assertEquals((long)404L, (long)resp1.statusCode);
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("The component with id 1 does not exist."));
        ParsedResponse respZbing = this.componentClient.getComponentIssueCountsResponse("zbing");
        Assert.assertEquals((long)404L, (long)respZbing.statusCode);
        Assert.assertTrue((boolean)respZbing.entity.errorMessages.contains("The component with id zbing does not exist."));
    }

    @Test
    public void testDeleteComponent() throws Exception {
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Issue for voting test");
        this.navigation.issue().setComponents(issueKey, NEW_COMPONENT_1);
        SearchResult searchResults = this.searchClient.postSearch(new SearchRequest().jql("component is empty"));
        MatcherAssert.assertThat((Object)searchResults.total, (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)searchResults.issues.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        this.componentClient.delete("10000");
        ParsedResponse resp1 = this.componentClient.getResponse("10000");
        Assert.assertEquals((long)404L, (long)resp1.statusCode);
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("The component with id 10000 does not exist."));
        searchResults = this.searchClient.postSearch(new SearchRequest().jql("component is empty"));
        MatcherAssert.assertThat((Object)searchResults.total, (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)searchResults.issues.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.navigation.issue().setComponents(issueKey, NEW_COMPONENT_2);
        issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Issue for voting test");
        this.navigation.issue().setComponents(issueKey, NEW_COMPONENT_2);
        this.componentClient.delete(COMPONENT_ID, this.createSelfLink(10002L));
        resp1 = this.componentClient.getResponse(COMPONENT_ID);
        Assert.assertEquals((long)404L, (long)resp1.statusCode);
        Assert.assertTrue((boolean)resp1.entity.errorMessages.contains("The component with id 10001 does not exist."));
        searchResults = this.searchClient.postSearch(new SearchRequest().jql("component = \"New Component 3\""));
        MatcherAssert.assertThat((Object)searchResults.total, (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)searchResults.issues.size(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testGetFilteredComponents() {
        int maxResults = 5;
        long startAt = 0L;
        PageBean page = this.componentClient.getPage(Long.valueOf(0L), Integer.valueOf(5), EMPTY_STRING, Collections.emptySet());
        Assertions.assertThat((int)page.getMaxResults()).isEqualTo(5);
        Assertions.assertThat((long)page.getTotal()).isEqualTo(3L);
        Assertions.assertThat((Boolean)page.getIsLast()).isTrue();
        ((ListAssert)Assertions.assertThat((List)page.getValues()).hasSize(3)).extracting("name").containsExactly(new Object[]{NEW_COMPONENT_1, NEW_COMPONENT_2, NEW_COMPONENT_3});
    }

    private void assertSameComponent(Component expectedComponent, Component actualComponent) {
        Assert.assertNotNull((Object)actualComponent.id);
        Assert.assertNotNull((Object)actualComponent.self);
        Assert.assertEquals((Object)expectedComponent.name, (Object)actualComponent.name);
        Assert.assertEquals((Object)expectedComponent.description, (Object)actualComponent.description);
        Assert.assertEquals((Object)expectedComponent.assigneeType, (Object)actualComponent.assigneeType);
        String expectedLead = expectedComponent.lead != null ? expectedComponent.lead.name : expectedComponent.leadUserName;
        String actualLead = actualComponent.lead != null ? actualComponent.lead.name : actualComponent.leadUserName;
        Assert.assertEquals((Object)expectedLead, (Object)actualLead);
    }

    private Component getInitialComponent(Long componentID) {
        return new Component().self(this.createSelfLink(componentID)).id(componentID).project("HSP").projectId(10000L).name(NEW_COMPONENT_1).assigneeType(Component.AssigneeType.PROJECT_DEFAULT).assignee(this.createUserAdmin()).realAssigneeType(Component.AssigneeType.PROJECT_DEFAULT).realAssignee(this.createUserAdmin()).isAssigneeTypeValid(true);
    }
}

