/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.ResponseMatchers;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ConfigurationBean;
import com.atlassian.jira.testkit.client.restclient.ConfigurationClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreBlankInstance
public class TestConfigurationResource
extends BaseJiraRestTest {
    private ConfigurationClient configurationClient;

    @Before
    public void setUpTest() {
        this.configurationClient = new ConfigurationClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void noAccessByAnonymous() throws Exception {
        ParsedResponse response = ((ConfigurationClient)this.configurationClient.anonymous()).getConfigurationResponse();
        Assert.assertThat((Object)response, ResponseMatchers.hasStatusCode(Response.Status.UNAUTHORIZED));
    }

    @Test
    public void accessibleWhenNormalUser() throws Exception {
        ParsedResponse response = ((ConfigurationClient)this.configurationClient.loginAs("fred")).getConfigurationResponse();
        Assert.assertThat((Object)response, ResponseMatchers.hasStatusCode(Response.Status.OK));
    }

    @Test
    public void gettingJIRAConfiguration() {
        this.backdoor.attachments().disable();
        this.backdoor.issueLinking().disable();
        this.backdoor.subtask().enable();
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", true);
        this.backdoor.applicationProperties().setOption("jira.option.allowunassigned", true);
        ConfigurationBean configuration = this.configurationClient.getConfiguration();
        Assert.assertThat((Object)configuration.attachmentsEnabled, (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)false)));
        Assert.assertThat((Object)configuration.issueLinkingEnabled, (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)false)));
        Assert.assertThat((Object)configuration.subTasksEnabled, (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)true)));
        Assert.assertThat((Object)configuration.timeTrackingEnabled, (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)true)));
        Assert.assertThat((Object)configuration.unassignedIssuesAllowed, (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)true)));
        Assert.assertThat((Object)configuration.votingEnabled, (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)true)));
        Assert.assertThat((Object)configuration.watchingEnabled, (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)true)));
        Assert.assertThat((Object)configuration.timeTrackingConfiguration.defaultUnit, (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)ConfigurationBean.TimeTrackingConfigurationBean.TimeTrackingUnit.minute)));
        Assert.assertThat((Object)configuration.timeTrackingConfiguration.timeFormat, (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)ConfigurationBean.TimeTrackingConfigurationBean.TimeFormat.pretty)));
        Assert.assertEquals((double)configuration.timeTrackingConfiguration.workingDaysPerWeek, (double)7.0, (double)Math.pow(10.0, -5.0));
        Assert.assertEquals((double)configuration.timeTrackingConfiguration.workingHoursPerDay, (double)24.0, (double)Math.pow(10.0, -5.0));
    }

    @Test
    public void timeTrackingDisabled() {
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", false);
        ConfigurationBean configuration = this.configurationClient.getConfiguration();
        Assert.assertThat((Object)configuration.timeTrackingEnabled, (Matcher)Is.is((Matcher)CoreMatchers.equalTo((Object)false)));
        Assert.assertThat((Object)configuration.timeTrackingConfiguration, (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }
}

