/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestCurrentUserResource
extends BaseJiraFuncTest {
    private static final String PASSWORD = "password";
    private static final String CURRENT_PASSWORD = "currentPassword";
    private static final String EMAIL_ADDRESS = "emailAddress";
    private static final String DISPLAY_NAME = "displayName";
    private static final String EMAIL_ADDRESS_CHANGED_VALUE = "charlie2@localhost";
    private static final String DISPLAY_NAME_CHANGED_VALUE = "Charlie of Atlassian II";
    private static final String REST_URL = "/rest/api/2/user?";
    private static final String USER_NAME = "notadmin";
    private static final String USER_CURRENT_PASSWORD = "withpassword";
    private static final String USER_NEW_PASSWORD = "hocuspocus";
    private UserClient userClient;
    private com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData;

    @Before
    public void setUp() {
        this.environmentData = this.getEnvironmentData();
        this.backdoor.usersAndGroups().addUser(USER_NAME, USER_CURRENT_PASSWORD, "DisplayNoAdminName", "noadmin@localhost");
        this.userClient = new UserClient(this.environmentData);
        this.userClient.loginAs(USER_NAME, USER_CURRENT_PASSWORD);
    }

    @After
    public void tearDown() {
        this.userClient.close();
    }

    @Test
    public void testUpdateUser() {
        this.updateUser();
    }

    @Test
    public void testUpdateUserWithNoPassword() {
        Response responseUpdate = this.userClient.updateUser(EMAIL_ADDRESS_CHANGED_VALUE, DISPLAY_NAME_CHANGED_VALUE, null);
        Assert.assertThat((Object)responseUpdate.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    @Test
    public void testUpdateUserWithInvalidPassword() {
        Response responseUpdate = this.userClient.updateUser(EMAIL_ADDRESS_CHANGED_VALUE, DISPLAY_NAME_CHANGED_VALUE, "currentPassword*");
        Assert.assertThat((Object)responseUpdate.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
    }

    @Test
    public void testChangePassword() {
        Response response = this.userClient.changePassword(USER_NEW_PASSWORD, USER_CURRENT_PASSWORD);
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.NO_CONTENT.getStatusCode()));
        response.close();
    }

    @Test
    public void testChangePasswordWithInvalidCurrentPassword() {
        Response response = this.userClient.changePassword(USER_NEW_PASSWORD, "withpassword-");
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        response.close();
    }

    private String getJiraExperimentalApiUserPath() {
        return this.environmentData.getBaseUrl() + REST_URL;
    }

    private void updateUser() {
        Response responseUpdate = this.userClient.updateUser(EMAIL_ADDRESS_CHANGED_VALUE, DISPLAY_NAME_CHANGED_VALUE, USER_CURRENT_PASSWORD);
        Assert.assertThat((Object)responseUpdate.getStatus(), (Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode()));
        UserBean userBean = this.getMapEntity(responseUpdate);
        responseUpdate.close();
        Assert.assertThat((Object)userBean, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)userBean.getEmailAddress(), (Matcher)Matchers.equalTo((Object)EMAIL_ADDRESS_CHANGED_VALUE));
        Assert.assertThat((Object)userBean.getDisplayName(), (Matcher)Matchers.equalTo((Object)DISPLAY_NAME_CHANGED_VALUE));
        Assert.assertThat((Object)userBean.getSelf().toString(), (Matcher)Matchers.startsWith((String)this.getJiraExperimentalApiUserPath()));
        Assert.assertThat((Object)userBean.getLocale(), (Matcher)Matchers.equalTo((Object)"en_AU"));
    }

    private UserBean getMapEntity(Response responseRead) {
        return (UserBean)responseRead.readEntity(UserBean.class);
    }

    private class UserClient
    extends RestApiClient<UserClient> {
        private static final String CURRENT_USER_PATH = "myself";
        private static final String PASSWORD_PATH = "password";
        private final Set<Response> responses;

        protected UserClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
            super((JIRAEnvironmentData)environmentData);
            this.responses = Sets.newHashSet();
        }

        protected WebTarget createResource() {
            return this.resourceRoot(TestCurrentUserResource.this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("api").path("2");
        }

        private Response getUser(String key) {
            Preconditions.checkNotNull((Object)key);
            WebTarget webTarget = this.createResource().path(CURRENT_USER_PATH);
            Response response = (Response)webTarget.request().get(Response.class);
            this.responses.add(response);
            return response;
        }

        private Response updateUser(String emailAddress, String displayName, String password) {
            WebTarget webTarget = this.createResource().path(CURRENT_USER_PATH);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (emailAddress != null) {
                builder.put((Object)TestCurrentUserResource.EMAIL_ADDRESS, (Object)emailAddress);
            }
            if (displayName != null) {
                builder.put((Object)TestCurrentUserResource.DISPLAY_NAME, (Object)displayName);
            }
            if (password != null) {
                builder.put((Object)"password", (Object)password);
            }
            Response response = (Response)webTarget.request(new String[]{"application/json"}).put(Entity.json((Object)builder.build()), Response.class);
            this.responses.add(response);
            return response;
        }

        private Response changePassword(String password, String currentPassword) {
            WebTarget webTarget = this.createResource().path("myself/password");
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (password != null) {
                builder.put((Object)"password", (Object)password);
                builder.put((Object)TestCurrentUserResource.CURRENT_PASSWORD, (Object)currentPassword);
            }
            Response response = (Response)webTarget.request(new String[]{"application/json"}).put(Entity.json((Object)builder.build()), Response.class);
            this.responses.add(response);
            return response;
        }

        private void close() {
            for (Response response : this.responses) {
                response.close();
            }
        }
    }
}

