/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
public class TestCustomFieldOptionResource
extends BaseJiraRestTest {
    private static final Logger log = LoggerFactory.getLogger(TestCustomFieldOptionResource.class);
    private static final int ANONYMOUSLY_ACCESSIBLE_OPTION_ID = 10100;
    private static final int OPTION_OF_FIELD_WITH_SCHEME_NO_CONTEXT = 10005;
    private static final int OPTION_OF_FIELD_HIDDEN_IS_SECOND_PROJECT = 10009;
    private static final int OPTION_OF_HIDDEN_FIELD = 10003;
    private static final int OPTION_OF_FIELD_WITH_CONTEXT_FOR_THIRD_PROJECT = 10007;
    private static final Integer[] ALL_OPTIONS = new Integer[]{10100, 10005, 10009, 10003, 10007};
    private static final Integer[] OPTIONS_VISIBLE_BY_ADMIN = new Integer[]{10100, 10005, 10009, 10007};
    private static final Integer[] OPTIONS_VISIBLE_BY_ANONYMOUS = new Integer[]{10100};
    @Inject
    FuncTestUrlHelper funcTestUrlHelper;
    private CloseableHttpClient httpClient;

    @Before
    public void setUpTest() {
        this.httpClient = HttpClientBuilder.create().build();
    }

    @After
    public void tearDown() throws IOException {
        this.httpClient.close();
    }

    @Test
    @Restore(value="TestCustomFieldOptionResource.zip")
    @SinceBuildRule.SinceBuild(buildNumber=815000)
    public void testOptionsVisibleForAdmin() throws IOException {
        Set<Integer> foundOptions = this.getOptions("admin");
        Assert.assertThat(foundOptions, (Matcher)Matchers.containsInAnyOrder((Object[])OPTIONS_VISIBLE_BY_ADMIN));
    }

    @Test
    @Restore(value="TestCustomFieldOptionResource.zip")
    @SinceBuildRule.SinceBuild(buildNumber=815000)
    public void testOptionsVisibleForAnonymous() throws IOException {
        Set<Integer> foundOptions = this.getOptions(null);
        Assert.assertThat(foundOptions, (Matcher)Matchers.containsInAnyOrder((Object[])OPTIONS_VISIBLE_BY_ANONYMOUS));
    }

    @Nonnull
    private Set<Integer> getOptions(String login) throws IOException {
        HashSet<Integer> foundOptions = new HashSet<Integer>();
        for (Integer customFieldOptionId : ALL_OPTIONS) {
            try (CloseableHttpResponse response = this.getCustomFieldOption(customFieldOptionId.toString(), login);){
                if (response.getStatusLine().getStatusCode() == 200) {
                    foundOptions.add(customFieldOptionId);
                    continue;
                }
                if (response.getStatusLine().getStatusCode() == 404) continue;
                log.error("Received unexpected response: {} for option {}", (Object)response, (Object)customFieldOptionId);
                Assert.fail((String)("CustomFieldOptionResource should return option or NOT_FOUND error but was " + response.getStatusLine().toString()));
            }
        }
        return foundOptions;
    }

    private CloseableHttpResponse getCustomFieldOption(String customFieldOptionId, String login) throws IOException {
        HttpGet httpGet = new HttpGet(this.funcTestUrlHelper.getBaseUrl() + "/rest/api/2/customFieldOption/" + customFieldOptionId);
        if (login != null) {
            String credentials = Base64.getEncoder().encodeToString((login + ":" + login).getBytes(StandardCharsets.UTF_8));
            httpGet.setHeader("Authorization", "Basic " + credentials);
        }
        return this.httpClient.execute((HttpUriRequest)httpGet);
    }
}

