/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.v2.issue.customfield.CustomFieldOptionBean;
import com.atlassian.jira.rest.v2.issue.customfield.CustomFieldOptionsBean;
import com.atlassian.jira.testkit.client.IssueTypeControl;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.CustomFieldsClient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreOnce(value="blankprojects.xml")
public class TestCustomFieldResource
extends BaseJiraRestTest {
    private CustomFieldsClient client;
    private String customFieldId;
    private long customFieldNumericId;
    private long projectOneId;
    private long projectTwoId;
    private String issueTypeOne;
    private String issueTypeTwo;

    @Before
    public void setup() {
        this.backdoor.project().getProjects().forEach(project -> this.backdoor.project().deleteProject(project.key));
        this.client = new CustomFieldsClient(this.getEnvironmentData());
        this.customFieldId = this.backdoor.customFields().createCustomField("MultiSelect", "MultiSelect CF", CustomFields.builtInCustomFieldKey("multiselect"), null);
        this.customFieldNumericId = Long.parseLong(CustomFields.numericCfId(this.customFieldId));
        this.projectOneId = this.backdoor.project().addProject("Project One", "ONE", "admin");
        this.projectTwoId = this.backdoor.project().addProject("Project Two", "TWO", "admin");
        List issueTypes = this.backdoor.issueType().getIssueTypesForProject(String.valueOf(this.projectOneId));
        this.issueTypeOne = ((IssueTypeControl.IssueType)issueTypes.get(0)).getId();
        this.issueTypeTwo = ((IssueTypeControl.IssueType)issueTypes.get(1)).getId();
        long projectThreeId = this.backdoor.project().addProject("Project Three", "THREE", "admin");
        long contextProjectThree = this.createContext(Collections.singletonList(projectThreeId));
        this.addOption("Project Three Option", contextProjectThree);
        this.addOption("Global A");
        this.addOption("Global B");
        this.addOption("Global C");
    }

    @After
    public void clean() {
        this.backdoor.customFields().deleteCustomField(this.customFieldId);
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS, "jira-users");
    }

    @Test
    public void shouldShowGlobalOptionsIfContextIsNotProvided() {
        TestOptionsBean bean = this.getOptions();
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.contains((Object[])new String[]{"Global A", "Global B", "Global C"}));
    }

    @Test
    public void shouldShowOnlyOptionsInProvidedContext() {
        this.addOption("Project One Option", this.createContext(Collections.singletonList(this.projectOneId)));
        this.addOption("Project Two Option", this.createContext(Collections.singletonList(this.projectTwoId)));
        TestOptionsBean bean = this.getOptions(Collections.singletonList(this.projectOneId), Collections.emptyList());
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.contains((Object[])new String[]{"Project One Option"}));
    }

    @Test
    public void shouldNotShowOptionsIfProvidedContextMatchesMoreThanOneContext() {
        this.addOption("Project One Option", this.createContext(Collections.singletonList(this.projectOneId)));
        this.addOption("Project Two Option", this.createContext(Collections.singletonList(this.projectTwoId)));
        TestOptionsBean bean = this.getOptions(Arrays.asList(this.projectOneId, this.projectTwoId), Collections.emptyList());
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void shouldShowGlobalOptionsIfProjectDoesNotBelongToAnyContext() {
        TestOptionsBean bean = this.getOptions(Collections.singletonList(this.projectTwoId), Collections.emptyList());
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.contains((Object[])new String[]{"Global A", "Global B", "Global C"}));
    }

    @Test
    public void shouldNotShowGlobalOptionsIfProvidedContextDoesNotMatchAnyContext() {
        long contextForProjectAndIssueTypeId = this.createContext(Collections.singletonList(this.projectOneId), Collections.singletonList(this.issueTypeOne));
        this.addOption("Local A", contextForProjectAndIssueTypeId);
        TestOptionsBean bean = this.getOptions(Collections.singletonList(this.projectOneId), Collections.singletonList(this.issueTypeTwo));
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void shouldShowOptionsForMultipleProjects() {
        List<Long> projectsInContext = Arrays.asList(this.projectOneId, this.projectTwoId);
        long projectOneAndTwoContextId = this.createContext(projectsInContext);
        this.addOption("Project One and Two Option A", projectOneAndTwoContextId);
        this.addOption("Project One and Two Option B", projectOneAndTwoContextId);
        TestOptionsBean bean = this.getOptions(projectsInContext, Collections.emptyList());
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.contains((Object[])new String[]{"Project One and Two Option A", "Project One and Two Option B"}));
    }

    @Test
    public void shouldShowOptionsForAnyIssueTypeIfNoIssueTypesSpecifiedWhenCreatingContext() {
        long contextId = this.createContext(Collections.singletonList(this.projectOneId), Collections.emptyList());
        this.addOption("Project One Option A", contextId);
        this.addOption("Project One Option B", contextId);
        TestOptionsBean bean = this.getOptions(Collections.singletonList(this.projectOneId), Collections.singletonList(this.issueTypeOne));
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.contains((Object[])new String[]{"Project One Option A", "Project One Option B"}));
    }

    @Test
    public void shouldShowOptionsForProjectAndIssueType() {
        long contextId = this.createContext(Collections.singletonList(this.projectOneId), Collections.singletonList(this.issueTypeOne));
        this.addOption("Option 1", contextId);
        this.addOption("Option 2", contextId);
        TestOptionsBean bean = this.getOptions(Collections.singletonList(this.projectOneId), Collections.singletonList(this.issueTypeOne));
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.contains((Object[])new String[]{"Option 1", "Option 2"}));
    }

    @Test
    public void shouldShowOptionsForProjectAndIssueTypeIfProvidedContextForProjectAndAllIssueTypes() {
        long contextId = this.createContext(Collections.singletonList(this.projectOneId), Collections.singletonList(this.issueTypeOne));
        this.addOption("Option 1", contextId);
        this.addOption("Option 2", contextId);
        TestOptionsBean bean = this.getOptions(Collections.singletonList(this.projectOneId), Collections.emptyList());
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.contains((Object[])new String[]{"Option 1", "Option 2"}));
    }

    @Test
    public void shouldNotShowOptionsIfProvidedContextMatchesProjectButDoesNotMatchIssueType() {
        long contextId = this.createContext(Collections.singletonList(this.projectOneId), Collections.singletonList(this.issueTypeOne));
        this.addOption("Option 1", contextId);
        this.addOption("Option 2", contextId);
        TestOptionsBean bean = this.getOptions(Collections.singletonList(this.projectOneId), Collections.singletonList(this.issueTypeTwo));
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void shouldNotShowOptionsIfProvidedContextIsSupersetOfIssueTypes() {
        long contextId = this.createContext(Collections.singletonList(this.projectOneId), Collections.singletonList(this.issueTypeOne));
        this.addOption("Option 1", contextId);
        this.addOption("Option 2", contextId);
        TestOptionsBean bean = this.getOptions(Collections.singletonList(this.projectOneId), Arrays.asList(this.issueTypeOne, this.issueTypeTwo));
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void shouldShowOptionsIfProvidedContextIsSubsetOfIssueTypes() {
        long contextId = this.createContext(Collections.singletonList(this.projectOneId), Arrays.asList(this.issueTypeOne, this.issueTypeTwo));
        this.addOption("Option 1", contextId);
        this.addOption("Option 2", contextId);
        TestOptionsBean bean = this.getOptions(Collections.singletonList(this.projectOneId), Collections.singletonList(this.issueTypeOne));
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.contains((Object[])new String[]{"Option 1", "Option 2"}));
    }

    @Test
    public void shouldShowOptionsIfProvidedContextIsSubsetOfProjectsAndIssueTypesFromTheSameContext() {
        long contextId = this.createContext(Arrays.asList(this.projectOneId, this.projectTwoId), Arrays.asList(this.issueTypeOne, this.issueTypeTwo));
        this.addOption("Option 1", contextId);
        this.addOption("Option 2", contextId);
        TestOptionsBean bean = this.getOptions(Collections.singletonList(this.projectOneId), Collections.singletonList(this.issueTypeOne));
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.contains((Object[])new String[]{"Option 1", "Option 2"}));
    }

    @Test
    public void shouldShowGlobalOptionsIfProvidedIssueTypeBelongsToGlobalContextAndNoProjectSpecified() {
        this.addOption("Local", this.createContext(Collections.singletonList(this.projectOneId)));
        TestOptionsBean bean = this.getOptions(Collections.emptyList(), Collections.singletonList(this.issueTypeOne));
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.contains((Object[])new String[]{"Global A", "Global B", "Global C"}));
    }

    @Test
    public void shouldReturnErrorMessageIfCustomFieldDoesNotExist() {
        ParsedResponse<CustomFieldOptionsBean> response = this.client.getOptions(123L, Collections.emptyList(), Collections.emptyList());
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)Response.Status.NOT_FOUND.getStatusCode()));
        MatcherAssert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.is(Collections.singletonList("A custom field with id '123' does not exist or you do not have permission to view it.")));
    }

    @Test
    public void shouldReturnErrorMessageIfUserDoesNotHavePermissionToCustomField() {
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.BROWSE_PROJECTS, "jira-users");
        ParsedResponse<CustomFieldOptionsBean> response = ((CustomFieldsClient)this.client.loginAs("fred")).getOptions(this.customFieldNumericId, Collections.emptyList(), Collections.emptyList());
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)Response.Status.NOT_FOUND.getStatusCode()));
        MatcherAssert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.is(Collections.singletonList("A custom field with id '" + this.customFieldNumericId + "' does not exist or you do not have permission to view it.")));
    }

    @Test
    public void shouldReturnOptionsForNotAdminUser() {
        TestOptionsBean bean = this.getOptionsForUser("fred");
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.contains((Object[])new String[]{"Global A", "Global B", "Global C"}));
    }

    @Test
    public void shouldFilterOptionsByQuery() {
        this.addOption("Global (Option) A");
        this.addOption("Another OPTION B");
        this.addOption("Something else");
        this.addOption("AnotherOption");
        this.addOption("This(option)Matches");
        TestOptionsBean bean = this.getOptions("option", 10L);
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Global (Option) A", "Another OPTION B", "This(option)Matches"}));
        MatcherAssert.assertThat((Object)bean.total, (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void shouldLimitOptionsByMaxResults() {
        this.addOption("1");
        this.addOption("2");
        this.addOption("3");
        this.addOption("4");
        this.addOption("5");
        this.addOption("6");
        TestOptionsBean bean = this.getOptions("", 2L);
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)bean.total, (Matcher)Matchers.is((Object)9));
    }

    @Test
    public void shouldReturnTotalNumberOfOptionsAfterFiltering() {
        this.addOption("1");
        this.addOption("1");
        this.addOption("2");
        this.addOption("2");
        TestOptionsBean bean = this.getOptions("1", 1L);
        MatcherAssert.assertThat((Object)bean.options, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)bean.total, (Matcher)Matchers.is((Object)2));
    }

    private TestOptionsBean getOptions(String query, Long maxResults) {
        return this.getOptions(Collections.emptyList(), Collections.emptyList(), "admin", query, maxResults);
    }

    private TestOptionsBean getOptions() {
        return this.getOptions(Collections.emptyList(), Collections.emptyList());
    }

    private TestOptionsBean getOptions(List<Long> projectIds, List<String> issueTypeIds) {
        return this.getOptions(projectIds, issueTypeIds, "admin", null, null);
    }

    private TestOptionsBean getOptionsForUser(String username) {
        return this.getOptions(Collections.emptyList(), Collections.emptyList(), username, null, null);
    }

    private TestOptionsBean getOptions(List<Long> projectIds, List<String> issueTypeIds, String user, String query, Long maxResults) {
        ParsedResponse<CustomFieldOptionsBean> optionsResponse = ((CustomFieldsClient)this.client.loginAs(user)).getOptions(this.customFieldNumericId, projectIds, issueTypeIds, query, maxResults);
        MatcherAssert.assertThat((Object)optionsResponse.statusCode, (Matcher)Matchers.is((Object)Response.Status.OK.getStatusCode()));
        return new TestOptionsBean((CustomFieldOptionsBean)optionsResponse.body);
    }

    private void addOption(String optionValue) {
        this.addOption(optionValue, null);
    }

    private void addOption(String optionValue, @Nullable Long schemeId) {
        this.backdoor.customFields().addOption(this.customFieldId, optionValue, schemeId);
    }

    private long createContext(List<Long> projectIds) {
        return this.createContext(projectIds, Collections.emptyList());
    }

    private long createContext(List<Long> projectIds, List<String> issueTypeIds) {
        return this.backdoor.customFields().createCustomFieldContext(String.valueOf(this.customFieldNumericId), projectIds, issueTypeIds.stream().map(Long::valueOf).collect(Collectors.toList()));
    }

    private static class TestOptionsBean {
        private final List<String> options;
        private final Integer total;

        private TestOptionsBean(CustomFieldOptionsBean optionsBean) {
            this.options = optionsBean.getOptions().stream().map(CustomFieldOptionBean::getValue).collect(Collectors.toList());
            this.total = optionsBean.getTotal();
        }
    }
}

