/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyClient;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyKeys;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util.PropertyAssertions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ENTITY_PROPERTIES, Category.REST})
@LoginAs(user="admin")
@RestoreOnce(value="DashboardItems.xml")
public final class TestDashboardItemPropertyResource
extends BaseJiraFuncTest {
    private static final String DASHBOARD_ID = "10010";
    private static final String DASHBOARD_ID_SHARED = "10110";
    private static final String DASHBOARD_ID_FRED_PRIVATE = "10120";
    private static final String DASHBOARD_ID_NOT_EXITING = "20010";
    private static final String DASHBOARD_ID_SYSTEM = "10000";
    private static final String ITEM_ID_1 = "10010";
    private static final String ITEM_ID_FROM_SHARED_DASHBOARD = "10110";
    private static final String ITEM_ID_FROM_FRED_PRIVATE_DASHBOARD = "10120";
    private static final String ITEM_ID_THAT_DOES_NOT_EXIST = "12345";
    private DashboardItemPropertyClient client;

    @Before
    public void setUpTest() {
        this.client = new DashboardItemPropertyClient(this.environmentData).dashboardId("10010");
    }

    @Test
    public void testModifyingDashboardItemPropertiesForOwnerDashboard() {
        this.testModifyingDashboardItemProperties("10010");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=811000)
    public void testModifyingDashboardItemPropertiesForPrivateDashboardOfOtherUser() {
        try {
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            this.client.dashboardId("10120");
            this.testModifyingDashboardItemProperties("10120");
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        }
    }

    private void testModifyingDashboardItemProperties(String gadgetId) {
        this.client.put(gadgetId, "prop1", this.value(1));
        this.client.put(gadgetId, "prop2", this.value(2));
        List item1Keys = this.client.getKeys((String)gadgetId).keys;
        MatcherAssert.assertThat((Object)item1Keys, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)item1Keys, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{PropertyAssertions.propertyKey("prop1"), PropertyAssertions.propertyKey("prop2")}));
        MatcherAssert.assertThat((Object)this.client.get((String)gadgetId, (String)"prop1").value, (Matcher)Matchers.equalTo(this.valueAsMap(1)));
        this.client.put(gadgetId, "prop1", this.value(420));
        MatcherAssert.assertThat((Object)this.client.get((String)gadgetId, (String)"prop1").value, (Matcher)Matchers.equalTo(this.valueAsMap(420)));
        this.client.delete(gadgetId, "prop1");
        MatcherAssert.assertThat((Object)this.client.getKeys((String)gadgetId).keys, (Matcher)Matchers.hasSize((int)1));
        this.client.delete(gadgetId, "prop2");
        MatcherAssert.assertThat((Object)this.client.getKeys((String)gadgetId).keys, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testAccessingDashboardItemInWrongDashboardReturns404() {
        this.assertNotFoundResponse(DASHBOARD_ID_NOT_EXITING, "10010");
        this.assertNotFoundResponse(DASHBOARD_ID_SYSTEM, "10010");
    }

    @Test
    public void testAccessingNonExistingDashboardItemReturns404() {
        this.assertNotFoundResponse("10010", ITEM_ID_THAT_DOES_NOT_EXIST);
    }

    @Test
    public void testAccessingDashboardAsLoggedInUserWithoutReadPermissionsReturns404() {
        this.client.loginAs("fred");
        this.assertNotFoundResponseOnAccess("10010", "10010");
    }

    @Test
    public void testAccessingDashboardAsAnonymousWithoutReadPermissionsReturns404() {
        this.client.anonymous();
        this.assertNotFoundResponseOnAccess("10010", "10010");
    }

    @Test
    public void testAccessingPropertiesOfADashboardItemSharedWithEveryoneAsAnonymousWorks() {
        this.client.anonymous();
        EntityPropertyKeys keys = this.client.dashboardId("10110").getKeys("10110");
        MatcherAssert.assertThat((Object)keys.keys, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testUserMustHaveWriteAccessToTheDashboardToSetProperties() {
        this.client.dashboardId("10110");
        this.client.loginAs("fred");
        ParsedResponse response = this.client.put("10110", "prop1", this.value(1));
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.statusCode);
    }

    @Test
    public void testUserMustHaveReadAccessToTheDashboardToAccessProperties() {
        try {
            this.client.dashboardId("10010").put("10010", "prop1", this.value(1));
            this.client.loginAs("fred");
            PropertyAssertions.assertWebApplicationException(() -> {
                this.client.dashboardId("10010").get("10010", "prop1");
                return null;
            }, Response.Status.NOT_FOUND);
        }
        finally {
            this.client.loginAs("admin");
            this.client.dashboardId("10010").delete("10010", "prop1");
        }
    }

    @Test
    public void testUserCanReadPropertiesOfSharedDashboard() {
        try {
            this.client.dashboardId("10110").put("10110", "prop1", this.value(1));
            this.client.loginAs("fred");
            MatcherAssert.assertThat((Object)this.client.dashboardId((String)"10110").get((String)"10110", (String)"prop1").value, (Matcher)Matchers.equalTo(this.valueAsMap(1)));
        }
        finally {
            this.client.loginAs("admin");
            this.client.dashboardId("10110").delete("10110", "prop1");
        }
    }

    @Test
    public void testSelfLink() {
        try {
            this.client.put("10010", "prop1", this.value(1));
            EntityPropertyKeys.EntityPropertyKey key = (EntityPropertyKeys.EntityPropertyKey)this.client.getKeys((String)"10010").keys.get(0);
            MatcherAssert.assertThat((Object)key.self, (Matcher)Matchers.equalTo((Object)String.format("%s/rest/api/%s/dashboard/%s/items/%s/properties/prop1", this.environmentData.getBaseUrl(), "2", "10010", "10010")));
        }
        finally {
            this.client.delete("10010", "prop1");
        }
    }

    private void assertNotFoundResponse(String dashboardId, String itemId) {
        this.client.dashboardId(dashboardId);
        ParsedResponse response = this.client.put(itemId, "prop1", this.value(1));
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.statusCode);
        MatcherAssert.assertThat((Object)response.entity.errorMessages, (Matcher)Matchers.contains((Object[])new String[]{String.format("dashboard %s does not contain item %s or you do not have permissions to view the dashboard", dashboardId, itemId)}));
    }

    private void assertNotFoundResponseOnAccess(String dashboardId, String itemId) {
        this.client.dashboardId(dashboardId);
        PropertyAssertions.assertWebApplicationException(() -> {
            this.client.getKeys(itemId);
            return null;
        }, Response.Status.NOT_FOUND, String.format("dashboard %s does not contain item %s or you do not have permissions to view the dashboard", dashboardId, itemId));
    }

    private JSONObject value(int value) {
        return new JSONObject(this.valueAsMap(value));
    }

    private Map<String, Object> valueAsMap(int value) {
        return ImmutableMap.of((Object)"value", (Object)value);
    }

    private static class DashboardItemPropertyClient
    extends EntityPropertyClient {
        private String dashboardId;

        DashboardItemPropertyClient(JIRAEnvironmentData environmentData) {
            super(environmentData, "items");
        }

        public DashboardItemPropertyClient dashboardId(String id) {
            this.dashboardId = id;
            return this;
        }

        protected WebTarget createResource() {
            if (this.dashboardId == null) {
                throw new IllegalArgumentException("dashboardId not specified, use the dashboardId(id) method first");
            }
            return super.createResource().path("dashboard").path(this.dashboardId);
        }
    }
}

