/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.gadgets.dashboard.Layout;
import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.URIMatcher;
import com.atlassian.jira.rest.api.dashboard.DashboardBean;
import com.atlassian.jira.rest.api.dashboard.DashboardsBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.DashboardClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import java.net.URI;
import java.util.Collections;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.DASHBOARDS})
@LoginAs(user="admin")
@RestoreOnce(value="TestDashboardResource.xml")
public class TestDashboardResource
extends BaseJiraRestTest {
    private static final String PRIVATE_DASHBOARD_ID = "10012";
    private static final String PRIVATE_DASHBOARD_NAME = "Private Dasboard owned by developer";
    private static final int PAGE_SIZE = 2;
    private DashboardClient dashboardClient;

    @Before
    public void setUp() {
        this.dashboardClient = new DashboardClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testDashboardResourceShouldAllowGettingFavouriteDashboards() {
        ParsedResponse badFilterResponse = this.dashboardClient.getListResponse("zzz", Integer.valueOf(0), Integer.valueOf(-1));
        Assert.assertThat((Object)badFilterResponse.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        Assert.assertThat((Object)badFilterResponse.entity.errorMessages, (Matcher)Matchers.hasItem((Object)"Bad value 'zzz' for query parameter 'filter'. Valid values are: 'favourite', 'my'"));
        Object[] favouriteDashboards = new DashboardBean[]{this.createDashboardBean("10011", "Private Dashboard owned by admin"), this.createDashboardBean("10010", "Shared Dashboard with group jira-administrators owned by admin"), this.createDashboardBean("10019", "Shared Dashboard with role Users on homosapien owned by fred")};
        DashboardsBean noResultsBean = this.dashboardClient.getList("favourite", Integer.valueOf(0), Integer.valueOf(0));
        Assert.assertThat((String)"clients should be able to pass maxResults=0 to get dashboard count and no results", (Object)noResultsBean.total(), (Matcher)CoreMatchers.equalTo((Object)favouriteDashboards.length));
        Assert.assertThat((String)"clients should be able to pass maxResults=0 to get dashboard count and no results", (Object)noResultsBean.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        DashboardsBean favourites = this.dashboardClient.getList("favourite", Integer.valueOf(0), Integer.valueOf(-1));
        Assert.assertThat((Object)favourites.startAt(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)favourites.total(), (Matcher)CoreMatchers.equalTo((Object)favouriteDashboards.length));
        Assert.assertThat((String)"clients should be able to pass ?filter=favourite to get only favourite dashboards", (Object)favourites.dashboards(), (Matcher)Matchers.hasItems((Object[])favouriteDashboards));
        Assert.assertThat((Object)favourites.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)favouriteDashboards.length));
        DashboardsBean page0 = this.dashboardClient.getList("favourite", Integer.valueOf(0), Integer.valueOf(2));
        Assert.assertThat((String)"page 0 should have 2 results", (Object)page0.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)page0.prev(), (Matcher)CoreMatchers.equalTo(null));
        Assert.assertThat((Object)URI.create(page0.next()), (Matcher)URIMatcher.isSameURI(URI.create(this.environmentData.getBaseUrl() + "/rest/api/2/dashboard?startAt=2&filter=favourite&maxResults=" + 2)));
        DashboardsBean page1 = this.dashboardClient.getList("favourite", Integer.valueOf(2), Integer.valueOf(2));
        Assert.assertThat((String)"page 1 should have 1 results", (Object)page1.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)URI.create(page1.prev()), (Matcher)URIMatcher.isSameURI(URI.create(this.environmentData.getBaseUrl() + "/rest/api/2/dashboard?startAt=0&filter=favourite&maxResults=" + 2)));
        Assert.assertThat((Object)page1.next(), (Matcher)CoreMatchers.equalTo(null));
        Assert.assertThat((String)"page 2 should have 0 results", (Object)this.dashboardClient.getList("favourite", Integer.valueOf(4), Integer.valueOf(2)).dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        DashboardsBean anonymousFavourites = ((DashboardClient)this.dashboardClient.anonymous()).getList("favourite", Integer.valueOf(0), Integer.valueOf(-1));
        Assert.assertThat((Object)anonymousFavourites.total(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)anonymousFavourites.dashboards(), (Matcher)CoreMatchers.equalTo(Collections.emptyList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDashboardResourceShouldAllowGettingAllSharedDashboards() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            Object[] sharedDashboards = new DashboardBean[]{this.createDashboardBean("10011", "Private Dashboard owned by admin"), this.createDashboardBean("10013", "Shared Dashboard with all roles on Monkey owned by developer"), this.createDashboardBean("10014", "Shared Dashboard with Anyone owned by developer"), this.createDashboardBean("10010", "Shared Dashboard with group jira-administrators owned by admin"), this.createDashboardBean("10018", "Shared Dashboard with group jira-users owned by fred"), this.createDashboardBean("10019", "Shared Dashboard with role Users on homosapien owned by fred"), this.createDashboardBean("10000", "System Dashboard")};
            DashboardsBean noResultsBean = this.dashboardClient.getList("", Integer.valueOf(0), Integer.valueOf(0));
            Assert.assertThat((Object)noResultsBean.total(), (Matcher)CoreMatchers.equalTo((Object)sharedDashboards.length));
            Assert.assertThat((Object)noResultsBean.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)0));
            DashboardsBean all = this.dashboardClient.getList(null, Integer.valueOf(0), Integer.valueOf(-1));
            Assert.assertThat((Object)all.startAt(), (Matcher)CoreMatchers.equalTo((Object)0));
            Assert.assertThat((Object)all.total(), (Matcher)CoreMatchers.equalTo((Object)sharedDashboards.length));
            Assert.assertThat((Object)all.dashboards(), (Matcher)Matchers.hasItems((Object[])sharedDashboards));
            Assert.assertThat((Object)all.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)sharedDashboards.length));
            Assert.assertThat((String)"page 0 should have 2 results", (Object)this.dashboardClient.getList("", Integer.valueOf(0), Integer.valueOf(2)).dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)2));
            Assert.assertThat((String)"page 1 should have 2 results", (Object)this.dashboardClient.getList("", Integer.valueOf(2), Integer.valueOf(2)).dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)2));
            Assert.assertThat((String)"page 2 should have 2 results", (Object)this.dashboardClient.getList("", Integer.valueOf(4), Integer.valueOf(2)).dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)2));
            Assert.assertThat((String)"page 3 should have 1 results", (Object)this.dashboardClient.getList("", Integer.valueOf(6), Integer.valueOf(2)).dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)1));
            Assert.assertThat((String)"page 4 should have 0 results", (Object)this.dashboardClient.getList("", Integer.valueOf(8), Integer.valueOf(2)).dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)0));
            DashboardsBean anonymousMy = ((DashboardClient)this.dashboardClient.anonymous()).getList("", Integer.valueOf(0), Integer.valueOf(-1));
            Assert.assertThat((Object)anonymousMy.total(), (Matcher)CoreMatchers.equalTo((Object)2));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDashboardResourceShouldAllowGettingAllDashboardsWithFfEnabled() {
        try {
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            Object[] allDashboards = new DashboardBean[]{this.createDashboardBean("10010", "Shared Dashboard with group jira-administrators owned by admin"), this.createDashboardBean("10011", "Private Dashboard owned by admin"), this.createDashboardBean(PRIVATE_DASHBOARD_ID, PRIVATE_DASHBOARD_NAME), this.createDashboardBean("10013", "Shared Dashboard with all roles on Monkey owned by developer"), this.createDashboardBean("10014", "Shared Dashboard with Anyone owned by developer"), this.createDashboardBean("10015", "Shared Dashboard with group jira-developers owned by developer"), this.createDashboardBean("10016", "Shared Dashboard with role Developers on homosapiens owned by developer"), this.createDashboardBean("10017", "Private Dahboard owned by fred"), this.createDashboardBean("10018", "Shared Dashboard with group jira-users owned by fred"), this.createDashboardBean("10019", "Shared Dashboard with role Users on homosapien owned by fred"), this.createDashboardBean("10000", "System Dashboard")};
            DashboardsBean noResultsBean = this.dashboardClient.getList("", Integer.valueOf(0), Integer.valueOf(0));
            Assert.assertThat((Object)noResultsBean.total(), (Matcher)CoreMatchers.equalTo((Object)allDashboards.length));
            Assert.assertThat((Object)noResultsBean.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)0));
            DashboardsBean all = this.dashboardClient.getList(null, Integer.valueOf(0), Integer.valueOf(-1));
            Assert.assertThat((Object)all.startAt(), (Matcher)CoreMatchers.equalTo((Object)0));
            Assert.assertThat((Object)all.total(), (Matcher)CoreMatchers.equalTo((Object)allDashboards.length));
            Assert.assertThat((Object)all.dashboards(), (Matcher)Matchers.hasItems((Object[])allDashboards));
            Assert.assertThat((Object)all.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)allDashboards.length));
            DashboardsBean anonymousMy = ((DashboardClient)this.dashboardClient.anonymous()).getList("", Integer.valueOf(0), Integer.valueOf(-1));
            Assert.assertThat((Object)anonymousMy.total(), (Matcher)CoreMatchers.equalTo((Object)2));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        }
    }

    @Test
    public void testDashboardResourceShouldAllowGettingMyDashboards() {
        Object[] myDashboards = new DashboardBean[]{this.createDashboardBean("10011", "Private Dashboard owned by admin"), this.createDashboardBean("10010", "Shared Dashboard with group jira-administrators owned by admin")};
        DashboardsBean noResultsBean = this.dashboardClient.getList("my", Integer.valueOf(0), Integer.valueOf(0));
        Assert.assertThat((Object)noResultsBean.total(), (Matcher)CoreMatchers.equalTo((Object)myDashboards.length));
        Assert.assertThat((Object)noResultsBean.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        DashboardsBean my = this.dashboardClient.getList("my", Integer.valueOf(0), Integer.valueOf(-1));
        Assert.assertThat((Object)my.startAt(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)my.total(), (Matcher)CoreMatchers.equalTo((Object)myDashboards.length));
        Assert.assertThat((Object)my.dashboards(), (Matcher)Matchers.hasItems((Object[])myDashboards));
        Assert.assertThat((Object)my.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)myDashboards.length));
        Assert.assertThat((String)"page 0 should have 2 results", (Object)this.dashboardClient.getList("my", Integer.valueOf(0), Integer.valueOf(2)).dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((String)"page 1 should have 0 results", (Object)this.dashboardClient.getList("my", Integer.valueOf(2), Integer.valueOf(2)).dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        DashboardsBean anonymousMy = ((DashboardClient)this.dashboardClient.anonymous()).getList("my", Integer.valueOf(0), Integer.valueOf(-1));
        Assert.assertThat((Object)anonymousMy.total(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)anonymousMy.dashboards(), (Matcher)CoreMatchers.equalTo(Collections.emptyList()));
    }

    @Test
    public void testDashboardResourceShouldAllowGettingASingleDashboard() {
        ParsedResponse fooResponse = this.dashboardClient.getSingleResponse("foo");
        Assert.assertThat((Object)fooResponse.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        Assert.assertThat((Object)fooResponse.entity.errorMessages, (Matcher)Matchers.hasItem((Object)"The dashboard with id 'foo' does not exist."));
        ParsedResponse minusOneResponse = this.dashboardClient.getSingleResponse("-1");
        Assert.assertThat((Object)minusOneResponse.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        Assert.assertThat((Object)minusOneResponse.entity.errorMessages, (Matcher)Matchers.hasItem((Object)"The dashboard with id '-1' does not exist."));
        Assert.assertThat((Object)this.dashboardClient.getSingle("10000"), (Matcher)CoreMatchers.equalTo((Object)this.createDashboardBean("10000", "System Dashboard")));
        DashboardBean anonSystemDashboard = ((DashboardClient)this.dashboardClient.anonymous()).getSingle("10000");
        Assert.assertThat((Object)anonSystemDashboard.name(), (Matcher)CoreMatchers.equalTo((Object)"System Dashboard"));
        ParsedResponse anonPrivateDashboardResp = ((DashboardClient)this.dashboardClient.anonymous()).getSingleResponse("10010");
        Assert.assertThat((Object)anonPrivateDashboardResp.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
    }

    @Test
    public void testDashboardResourceShouldAllowGettingPrivateDashboardWithFfEnabled() {
        try {
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            Assert.assertThat((Object)this.dashboardClient.getSingle(PRIVATE_DASHBOARD_ID), (Matcher)CoreMatchers.equalTo((Object)this.createDashboardBean(PRIVATE_DASHBOARD_ID, PRIVATE_DASHBOARD_NAME)));
            ParsedResponse response = ((DashboardClient)this.dashboardClient.anonymous()).getSingleResponse(PRIVATE_DASHBOARD_ID);
            Assert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
            response = ((DashboardClient)this.dashboardClient.loginAs("fred")).getSingleResponse(PRIVATE_DASHBOARD_ID);
            Assert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        }
    }

    @Test
    public void testDashboardResourceShouldNotAllowGettingPrivateDashboard() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            ParsedResponse response = this.dashboardClient.getSingleResponse(PRIVATE_DASHBOARD_ID);
            Assert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        }
    }

    @Test
    public void testDashboardResourcesShouldReturnTheSpecifiedNumberOfBoards() {
        for (int i = 0; i < 100; ++i) {
            this.backdoor.dashboard().createDashboard("admin", "Board " + i, "description " + i, Layout.A, true, false);
        }
        DashboardsBean dashboards = this.dashboardClient.getList(null, Integer.valueOf(0), Integer.valueOf(100));
        Assert.assertThat((Object)dashboards.dashboards().size(), (Matcher)CoreMatchers.equalTo((Object)100));
    }

    private DashboardBean createDashboardBean(String id, String name) {
        return new DashboardBean().id(id).name(name).self(this.environmentData.getBaseUrl() + "/rest/api/2/dashboard/" + id).view(this.environmentData.getBaseUrl() + "/secure/Dashboard.jspa?selectPageId=" + id);
    }
}

