/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.DarkFeature;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.FeatureKeyClient;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestFeatureFlagResource
extends BaseJiraRestTest {
    private static final String FEATURE_KEY = "jira.instrumentation.laas";
    public static final String FULL_DARK_FEATURE_KEY_ENABLED = "jira.instrumentation.laas.enabled";
    public static final String FULL_DARK_FEATURE_KEY_DISABLED = "jira.instrumentation.laas.disabled";
    private FeatureKeyClient client;
    private boolean initialEnabled;
    private boolean initialDisabled;

    @Before
    public void setUpTest() {
        this.client = new FeatureKeyClient(this.environmentData);
        this.initialEnabled = this.backdoor.darkFeatures().isGlobalEnabled(FULL_DARK_FEATURE_KEY_ENABLED);
        this.initialDisabled = this.backdoor.darkFeatures().isGlobalEnabled(FULL_DARK_FEATURE_KEY_DISABLED);
        this.setViaBackDoor(FULL_DARK_FEATURE_KEY_ENABLED, false);
        this.setViaBackDoor(FULL_DARK_FEATURE_KEY_DISABLED, false);
    }

    @After
    public void tearDownTest() {
        this.setViaBackDoor(FULL_DARK_FEATURE_KEY_ENABLED, this.initialEnabled);
        this.setViaBackDoor(FULL_DARK_FEATURE_KEY_DISABLED, this.initialDisabled);
    }

    @Test
    public void testGet() throws Exception {
        this.client.loginAs("admin", "admin");
        ParsedResponse response = this.client.getResponse(FEATURE_KEY);
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)200));
        DarkFeature feature = this.client.get(FEATURE_KEY);
        MatcherAssert.assertThat((Object)feature, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)feature.enabled, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testGetAll() throws Exception {
        this.client.loginAs("admin", "admin");
        ParsedResponse response = this.client.getResponse();
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)200));
        Map<?, ?> featureFlags = this.client.get();
        Map feature = (Map)featureFlags.get(FEATURE_KEY);
        MatcherAssert.assertThat((Object)feature, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat(feature.get("enabled"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testEnable() throws Exception {
        this.client.loginAs("admin", "admin");
        this.setViaBackDoor(FULL_DARK_FEATURE_KEY_ENABLED, false);
        this.setViaBackDoor(FULL_DARK_FEATURE_KEY_DISABLED, true);
        DarkFeature featureFlag = this.client.get(FEATURE_KEY);
        MatcherAssert.assertThat((Object)featureFlag.enabled, (Matcher)Matchers.is((Object)false));
        this.client.put(FEATURE_KEY, true);
        this.assertViaBackDoor(FEATURE_KEY, true);
    }

    @Test
    public void testDisable() throws Exception {
        this.client.loginAs("admin", "admin");
        this.setViaBackDoor(FULL_DARK_FEATURE_KEY_ENABLED, true);
        this.setViaBackDoor(FULL_DARK_FEATURE_KEY_DISABLED, false);
        DarkFeature featureFlag = this.client.get(FEATURE_KEY);
        MatcherAssert.assertThat((Object)featureFlag.enabled, (Matcher)Matchers.is((Object)true));
        this.client.put(FEATURE_KEY, false);
        this.assertViaBackDoor(FEATURE_KEY, false);
    }

    @Test
    public void testNonAdministrator() throws Exception {
        this.client.loginAs("fred");
        ParsedResponse response = this.client.putResponse(FEATURE_KEY, true);
        Assert.assertEquals((String)"Expected 402 as status code for non admin", (long)403L, (long)response.statusCode);
        response = this.client.putResponse(FEATURE_KEY, false);
        Assert.assertEquals((String)"Expected 402 as status code for non admin", (long)403L, (long)response.statusCode);
        response = this.client.getResponse(FEATURE_KEY);
        Assert.assertEquals((String)"Expected 402 as status code for non admin", (long)403L, (long)response.statusCode);
        response = this.client.getResponse();
        Assert.assertEquals((String)"Expected 402 as status code for non admin", (long)403L, (long)response.statusCode);
    }

    private void assertViaBackDoor(String featureKey, boolean enabled) {
        String fullDarkFeatureKeyEnabled = featureKey + ".enabled";
        String fullDarkFeatureKeyDisabled = featureKey + ".disabled";
        boolean isEnabled = this.backdoor.darkFeatures().isGlobalEnabled(fullDarkFeatureKeyEnabled);
        boolean isDisabled = this.backdoor.darkFeatures().isGlobalEnabled(fullDarkFeatureKeyDisabled);
        if (enabled) {
            MatcherAssert.assertThat((Object)(isEnabled | !isDisabled), (Matcher)Matchers.is((Object)true));
        } else {
            MatcherAssert.assertThat((Object)(!isEnabled | isDisabled), (Matcher)Matchers.is((Object)true));
        }
    }

    private void setViaBackDoor(String feature, boolean enabled) {
        if (enabled) {
            this.backdoor.darkFeatures().enableForSite(feature);
        } else {
            this.backdoor.darkFeatures().disableForSite(feature);
        }
    }
}

