/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Field;
import com.atlassian.jira.testkit.client.restclient.FieldClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@Restore(value="TestFieldResource.xml")
public class TestFieldResource
extends BaseJiraRestTest {
    private static final String[] UNSEARCHABLE = new String[]{"Key", "Votes", "Watchers", "Images"};
    private static final String[] UNNAVIGABLE = new String[]{"Comment", "Attachment"};
    private static final String[] UNORDERABLE = new String[]{"Key", "Votes", "Resolved", "Updated", "Created", "Status", "Work Ratio", "Project", "Images", "Watchers"};
    private FieldClient fieldClient;

    @Before
    public void setUp() {
        this.fieldClient = new FieldClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testAllFields() throws Exception {
        List fields = this.fieldClient.get();
        Assert.assertTrue((fields.size() > 40 ? 1 : 0) != 0);
        this.assertFieldsContain(fields, "Affects Version/s", false);
        this.assertFieldsContain(fields, "Assignee", false);
        this.assertFieldsContain(fields, "Attachment", false);
        this.assertFieldsContain(fields, "Comment", false);
        this.assertFieldsContain(fields, "Component/s", false);
        this.assertFieldsContain(fields, "Created", false);
        this.assertFieldsContain(fields, "CSF", true);
        this.assertFieldsContain(fields, "Description", false);
        this.assertFieldsContain(fields, "DP", true);
        this.assertFieldsContain(fields, "DT", true);
        this.assertFieldsContain(fields, "Due Date", false);
        this.assertFieldsContain(fields, "Environment", false);
        this.assertFieldsContain(fields, "Fix Version/s", false);
        this.assertFieldsContain(fields, "FTF", true);
        this.assertFieldsContain(fields, "GP", true);
        this.assertFieldsContain(fields, "II", true);
        this.assertFieldsContain(fields, "Images", false);
        this.assertFieldsContain(fields, "Issue Type", false);
        this.assertFieldsContain(fields, "Key", false);
        this.assertFieldsContain(fields, "Labels", false);
        this.assertFieldsContain(fields, "Linked Issues", false);
        this.assertFieldsContain(fields, "MC", true);
        this.assertFieldsContain(fields, "MGP", true);
        this.assertFieldsContain(fields, "MS", true);
        this.assertFieldsContain(fields, "MUP", true);
        this.assertFieldsContain(fields, "NF", true);
        this.assertFieldsContain(fields, "PP", true);
        this.assertFieldsContain(fields, "Priority", false);
        this.assertFieldsContain(fields, "Project", false);
        this.assertFieldsContain(fields, "RB", true);
        this.assertFieldsContain(fields, "Reporter", false);
        this.assertFieldsContain(fields, "Resolution", false);
        this.assertFieldsContain(fields, "Resolved", false);
        this.assertFieldsContain(fields, "ROTF", true);
        this.assertFieldsContain(fields, "Security Level", false);
        this.assertFieldsContain(fields, "SL", true);
        this.assertFieldsContain(fields, "Status", false);
        this.assertFieldsContain(fields, "Summary", false);
        this.assertFieldsContain(fields, "SVP", true);
        this.assertFieldsContain(fields, "TF", true);
        this.assertFieldsContain(fields, "Updated", false);
        this.assertFieldsContain(fields, "UP", true);
        this.assertFieldsContain(fields, "URL", true);
        this.assertFieldsContain(fields, "Votes", false);
        this.assertFieldsContain(fields, "VP", true);
        this.assertFieldsContain(fields, "Watchers", false);
        this.assertFieldsContain(fields, "Work Ratio", false);
    }

    @Test
    public void testAllFieldsAsAnonymous() {
        ParsedResponse response = ((FieldClient)this.fieldClient.anonymous()).getResponse();
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    @Test
    public void testAllFieldsAsAnonymousWithAvailableProjects() {
        this.backdoor.project().addProject("Test", "TEST", "admin");
        Long schemeId = this.backdoor.project().getSchemes((String)"TEST").permissionScheme.id;
        this.backdoor.permissionSchemes().addEveryonePermission(schemeId, ProjectPermissions.BROWSE_PROJECTS);
        ParsedResponse response = ((FieldClient)this.fieldClient.anonymous()).getResponse();
        Assert.assertEquals((long)200L, (long)response.statusCode);
    }

    @Test
    public void testAvailableFields() throws Exception {
        List fields = ((FieldClient)this.fieldClient.loginAs("admin")).get();
        this.assertFieldsContain(fields, "Salary", true);
        fields = ((FieldClient)this.fieldClient.loginAs("fred")).get();
        for (Field field : fields) {
            if (!field.name().equals("Salary")) continue;
            Assert.fail((String)"Field 'Salary' should be hidden from user Fred");
        }
    }

    private void assertFieldsContain(List<Field> fields, String name, boolean custom) {
        for (Field field : fields) {
            if (!field.name().equals(name)) continue;
            Assert.assertEquals((Object)custom, (Object)field.custom());
            boolean expected2 = !Arrays.asList(UNORDERABLE).contains(field.name());
            Assert.assertEquals((String)(field.name() + " orderability"), (Object)expected2, (Object)field.orderable());
            boolean expected1 = !Arrays.asList(UNNAVIGABLE).contains(field.name());
            Assert.assertEquals((String)(field.name() + " navigability"), (Object)expected1, (Object)field.navigable());
            boolean expected = !Arrays.asList(UNSEARCHABLE).contains(field.name());
            Assert.assertEquals((String)(field.name() + " searchability"), (Object)expected, (Object)field.searchable());
            return;
        }
        Assert.fail((String)("Field " + name + " not in list"));
    }
}

