/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.GroupPickerClient;
import com.atlassian.jira.testkit.client.restclient.GroupSuggestion;
import com.atlassian.jira.testkit.client.restclient.GroupSuggestions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
public class TestGroupPickerResource
extends BaseJiraFuncTest {
    private GroupPickerClient groupPickerClient;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.groupPickerClient = new GroupPickerClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    @RestoreBlankInstance
    public void testGroupSuggestionsOrder() {
        this.administration.usersAndGroups().addGroup("jara-users");
        this.administration.usersAndGroups().addGroup("zara-users");
        ArrayList expectedSuggestions = Lists.newArrayList((Object[])new GroupSuggestion[]{new GroupSuggestion().name("jara-users").html("jara-<b>users</b>"), new GroupSuggestion().name("jira-users").html("jira-<b>users</b>"), new GroupSuggestion().name("zara-users").html("zara-<b>users</b>")});
        GroupSuggestions suggestions = this.groupPickerClient.get("users");
        Assert.assertEquals((Object)"Showing 3 of 3 matching groups", (Object)suggestions.header);
        Assert.assertEquals((Object)expectedSuggestions, (Object)suggestions.groups);
    }

    @Test
    @RestoreBlankInstance
    public void testGroupSuggestionsAreHtmlEncoded() {
        this.administration.usersAndGroups().addGroup("<script>alert('wtf')</script>");
        ArrayList expectedSuggestions = Lists.newArrayList((Object[])new GroupSuggestion[]{new GroupSuggestion().name("<script>alert('wtf')</script>").html("&lt;script&gt;alert(&#39;<b>wtf</b>&#39;)&lt;/script&gt;")});
        GroupSuggestions suggestions = this.groupPickerClient.get("wtf");
        Assert.assertEquals((Object)"Showing 1 of 1 matching groups", (Object)suggestions.header);
        Assert.assertEquals((Object)expectedSuggestions, (Object)suggestions.groups);
    }

    @Test
    @RestoreBlankInstance
    public void testGroupSuggestionsNoQueryString() {
        ArrayList expectedSuggestions = Lists.newArrayList((Object[])new GroupSuggestion[]{new GroupSuggestion().name("jira-administrators").html("jira-administrators"), new GroupSuggestion().name("jira-developers").html("jira-developers"), new GroupSuggestion().name("jira-users").html("jira-users")});
        GroupSuggestions suggestions = this.groupPickerClient.get(null);
        Assert.assertEquals((Object)"Showing 3 of 3 matching groups", (Object)suggestions.header);
        Assert.assertEquals((Object)expectedSuggestions, (Object)suggestions.groups);
    }

    @Test
    @RestoreBlankInstance
    public void testFindGroupsWithNoMatch() {
        GroupSuggestions suggestions = this.groupPickerClient.get("lalala");
        Assert.assertEquals((Object)"Showing 0 of 0 matching groups", (Object)suggestions.header);
        Assert.assertEquals(Collections.emptyList(), (Object)suggestions.groups);
    }

    @Test
    @Restore(value="TestGroupPickerResource.xml")
    public void testFindGroupsExcessResults() {
        GroupSuggestions suggestions = this.groupPickerClient.get("z");
        ArrayList expectedSuggestions = Lists.newArrayList();
        for (int i = 0; i < 20; ++i) {
            String expectedName = "z" + String.format("%02d", i);
            String expectedHtml = "<b>z</b>" + String.format("%02d", i);
            expectedSuggestions.add(new GroupSuggestion().name(expectedName).html(expectedHtml));
        }
        Assert.assertEquals((Object)"Showing 20 of 21 matching groups", (Object)suggestions.header);
        Assert.assertEquals((Object)expectedSuggestions, (Object)suggestions.groups);
    }
}

