/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.IssueTypeControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ICalendarResourceClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.PLUGINS})
@RestoreBlankInstance
public class TestICalFeedResource
extends BaseJiraRestTest {
    private ICalendarResourceClient apiClient;
    private static final String HUMAN_PROJECT_KEY = "HSP";
    private static final Long HUMAN_PROJECT_ID = 10000L;
    private static final String HUMAN_FILTER_NAME = "HSP filter";
    private static final String ONE_PROJECT_JQL_QUERY = "project = HSP";
    private static final String TWO_PROJECT_JQL_QUERY = "project in (HSP, MKY)";
    private static final String CUSTOM_FIELD_TYPE_TEXTAREA = "com.atlassian.jira.plugin.system.customfieldtypes:textarea";
    private static final String CUSTOM_FIELD_TYPE_DATETIME = "com.atlassian.jira.plugin.system.customfieldtypes:datetime";
    private static final String CUSTOM_FIELD_TYPE_DATEPICKER = "com.atlassian.jira.plugin.system.customfieldtypes:datepicker";
    private String customTextFieldId;
    private String customDateTimeIdGlobal;
    private String customDateTimeIdProjectRestricted;
    private String customDatePickerIdIssuetypeRestricted;

    @Before
    public void setUpTest() {
        this.apiClient = new ICalendarResourceClient((JIRAEnvironmentData)this.environmentData);
    }

    @After
    public void tearDown() {
        this.apiClient.cleanUp();
    }

    @Test
    public void checkIfQueryOptionsAreReturned() {
        this.backdoor.filters().createFilter(ONE_PROJECT_JQL_QUERY, HUMAN_FILTER_NAME);
        ParsedResponse response = this.apiClient.getQueryOptions();
        Assert.assertEquals((long)200L, (long)response.statusCode);
        ICalendarResourceClient.QueryOptions queryOptions = (ICalendarResourceClient.QueryOptions)response.body;
        Assert.assertNotNull((String)"No project with key HSP found in the response", queryOptions.projects.stream().filter(project -> HUMAN_PROJECT_KEY.equals(project.key)).findAny().orElse(null));
        Assert.assertNotNull((String)"No filter with name 'HSP filter' found in the response", queryOptions.searchFilters.stream().filter(filter -> HUMAN_FILTER_NAME.equals(filter.name)).findAny().orElse(null));
    }

    @Test
    public void searchForSprintDatesLinkTest() {
        Assert.assertEquals((long)200L, (long)this.apiClient.searchWithJql((String)ONE_PROJECT_JQL_QUERY, (String[])new String[]{"sprint"}).statusCode);
    }

    @Test
    public void searchForEventsInNonExistingProjectShouldResultWithBadRequest() {
        Assert.assertEquals((long)400L, (long)this.apiClient.searchWithJql((String)"project = nspaaa", (String[])new String[]{"sprint"}).statusCode);
    }

    @Test
    public void jqlValidateLinkTest() {
        Assert.assertEquals((long)200L, (long)this.apiClient.validateJql((String)ONE_PROJECT_JQL_QUERY).statusCode);
    }

    @Test
    public void getConfigFieldsTestExpandedRetrievalNotSpecified() {
        this.setupConfigFieldTestData();
        ParsedResponse response = this.apiClient.getConfigFields(ONE_PROJECT_JQL_QUERY);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)200));
        Assert.assertThat((Object)((Set)response.body).size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        List<String> fieldKeysInResponse = this.getResponseFieldKeysList((Set)response.body);
        Assert.assertThat((Object)fieldKeysInResponse.contains(this.customDateTimeIdGlobal), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)fieldKeysInResponse.contains(this.customDateTimeIdProjectRestricted), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)fieldKeysInResponse.contains(this.customTextFieldId), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void getConfigFieldsTestExpandedRetrievalFalse() {
        this.setupConfigFieldTestData();
        ParsedResponse response = this.apiClient.getConfigFields(ONE_PROJECT_JQL_QUERY, Boolean.valueOf(false));
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)200));
        Assert.assertThat((Object)((Set)response.body).size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        List<String> fieldKeysInResponse = this.getResponseFieldKeysList((Set)response.body);
        Assert.assertThat((Object)fieldKeysInResponse.contains(this.customDateTimeIdGlobal), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)fieldKeysInResponse.contains(this.customDateTimeIdProjectRestricted), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)fieldKeysInResponse.contains(this.customTextFieldId), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void getConfigFieldsTestWithTwoProjectQueryExpandedRetrievalFalse() {
        this.setupConfigFieldTestData();
        ParsedResponse response = this.apiClient.getConfigFields(ONE_PROJECT_JQL_QUERY);
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)200));
        Assert.assertThat((Object)((Set)response.body).size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        List<String> fieldKeysInResponse = this.getResponseFieldKeysList((Set)response.body);
        Assert.assertThat((Object)fieldKeysInResponse.contains(this.customDateTimeIdGlobal), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)fieldKeysInResponse.contains(this.customDateTimeIdProjectRestricted), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)fieldKeysInResponse.contains(this.customTextFieldId), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void getConfigFieldsUpdatedRetrievalTestOneProjectQuery() {
        this.setupConfigFieldTestData();
        ParsedResponse response = this.apiClient.getConfigFields(ONE_PROJECT_JQL_QUERY, Boolean.valueOf(true));
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)200));
        Assert.assertThat((Object)((Set)response.body).size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        List<String> fieldKeysInResponse = this.getResponseFieldKeysList((Set)response.body);
        Assert.assertThat((Object)fieldKeysInResponse.contains(this.customDateTimeIdGlobal), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)fieldKeysInResponse.contains(this.customDateTimeIdProjectRestricted), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)fieldKeysInResponse.contains(this.customDatePickerIdIssuetypeRestricted), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)fieldKeysInResponse.contains(this.customTextFieldId), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void getConfigFieldsUpdatedRetrievalTestTwoProjectQuery() {
        this.setupConfigFieldTestData();
        ParsedResponse response = this.apiClient.getConfigFields(TWO_PROJECT_JQL_QUERY, Boolean.valueOf(true));
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.equalTo((Object)200));
        Assert.assertThat((Object)((Set)response.body).size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        List<String> fieldKeysInResponse = this.getResponseFieldKeysList((Set)response.body);
        Assert.assertThat((Object)fieldKeysInResponse.contains(this.customDateTimeIdGlobal), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)fieldKeysInResponse.contains(this.customDateTimeIdProjectRestricted), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)fieldKeysInResponse.contains(this.customDatePickerIdIssuetypeRestricted), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)fieldKeysInResponse.contains(this.customTextFieldId), (Matcher)Matchers.equalTo((Object)false));
    }

    private List<String> getResponseFieldKeysList(Set<LinkedHashMap<String, String>> responseSet) {
        return responseSet.stream().map(map -> (String)map.get("key")).collect(Collectors.toList());
    }

    private void setupConfigFieldTestData() {
        this.customTextFieldId = this.backdoor.customFields().createCustomField("custom-textarea-global", null, CUSTOM_FIELD_TYPE_TEXTAREA, null);
        this.customDateTimeIdGlobal = this.backdoor.customFields().createCustomField("custom-datetime-global", null, CUSTOM_FIELD_TYPE_DATETIME, null);
        IssueTypeControl.IssueType testIssueType = this.backdoor.issueType().createIssueType("testIssueType");
        long issueTypeId = Long.parseLong(testIssueType.getId());
        this.customDateTimeIdProjectRestricted = this.backdoor.customFields().createCustomField("custom-datetime-restricted-to-hsp-project", null, CUSTOM_FIELD_TYPE_DATETIME, null);
        this.customDatePickerIdIssuetypeRestricted = this.backdoor.customFields().createCustomField("custom-datetime-restricted-to-issuetype", null, CUSTOM_FIELD_TYPE_DATEPICKER, null);
        ArrayList<Long> projectRestrictList = new ArrayList<Long>();
        projectRestrictList.add(HUMAN_PROJECT_ID);
        ArrayList<Long> issueRestrictList = new ArrayList<Long>();
        issueRestrictList.add(issueTypeId);
        this.backdoor.customFields().createCustomFieldContext(this.customDateTimeIdProjectRestricted.replace("customfield_", ""), projectRestrictList, Collections.emptyList());
        this.backdoor.customFields().createCustomFieldContext(this.customDatePickerIdIssuetypeRestricted.replace("customfield_", ""), Collections.emptyList(), issueRestrictList);
    }

    @Test
    public void searchWithFilterLinkTest() {
        String filterId = this.backdoor.filters().createFilter(ONE_PROJECT_JQL_QUERY, HUMAN_FILTER_NAME);
        Assert.assertEquals((long)200L, (long)this.apiClient.searchWithFilter((String)filterId, (String[])new String[0]).statusCode);
    }
}

