/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.v2.index.IndexSnapshotPromiseBean;
import com.atlassian.jira.rest.v2.index.IndexSnapshotStatusBean;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.ztests.indexing.IndexSnapshotClient;
import com.jayway.awaitility.Awaitility;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
public class TestIndexSnapshotResourceRest
extends BaseJiraRestTest {
    private IndexSnapshotClient indexSnapshotClient;

    @Before
    public void setUp() {
        this.indexSnapshotClient = new IndexSnapshotClient(this.environmentData);
    }

    @Test
    public void testCreateIndexSnapshot() {
        ParsedResponse<IndexSnapshotPromiseBean> response = this.indexSnapshotClient.createIndexSnapshot();
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)202));
    }

    @Test
    public void testIsIndexSnapshotRunning() {
        this.backdoor.cacheControl().flushCaches();
        IndexSnapshotStatusBean status = this.indexSnapshotClient.isIndexSnapshotRunning();
        MatcherAssert.assertThat((Object)status.isRunning(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsIndexSnapshotRunningWhenRunning() {
        this.backdoor.cacheControl().flushCaches();
        this.backdoor.systemProperties().setProperty("com.atlassian.jira.index.snapshot.parallel.creation.allowed", "false");
        this.backdoor.barrier().raiseBarrierAndRun("snapshotCreation", () -> {
            ParsedResponse<IndexSnapshotPromiseBean> response = this.indexSnapshotClient.createIndexSnapshot();
            MatcherAssert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)202));
            Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(() -> this.indexSnapshotClient.isIndexSnapshotRunning());
        });
    }
}

