/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.IndexSummaryClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreBlankInstance
public class TestIndexSummaryResource
extends BaseJiraRestTest {
    @Test
    public void guestHasNoAccess() {
        Response indexSummaryResponse = ((IndexSummaryClient)this.backdoor.indexSummaryClient().anonymous()).getRawIndexSummary();
        Assert.assertEquals((long)401L, (long)indexSummaryResponse.getStatus());
    }

    @Test
    public void userHasNoAccess() {
        Response indexSummaryResponse = ((IndexSummaryClient)this.backdoor.indexSummaryClient().loginAs("fred")).getRawIndexSummary();
        Assert.assertEquals((long)403L, (long)indexSummaryResponse.getStatus());
    }

    @Test
    public void adminHasAccess() {
        Response indexSummaryResponse = ((IndexSummaryClient)this.backdoor.indexSummaryClient().loginAs("admin")).getRawIndexSummary();
        Assert.assertEquals((long)200L, (long)indexSummaryResponse.getStatus());
    }

    @Test
    public void responseCanBeUnmarshalled() {
        ((IndexSummaryClient)this.backdoor.indexSummaryClient().loginAs("admin")).getIndexSummary();
    }
}

