/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestRestClient;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestIssueResourceTransitions.xml")
public class TestIssueActionsAndOperationsResource
extends BaseJiraFuncTest {
    private static final String TEST_URL = "rest/api/1.0/issues/%s/ActionsAndOperations?atl_token=B5K4-34DH-08CH-P090_421c6fdad0582e9b4d80750605cd7bc6272c9498_lout";
    private static final String ISSUE_KEY = "HSP-1";
    private static final String ISSUE_ID = "10000";
    private static final Map<String, String> ACCEPT_HEADER = Collections.singletonMap("Accept", "application/xml;q=0.9,*/*;q=0.8");
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Inject
    private FuncTestRestClient restClient;

    @Test
    @LoginAs(user="fred")
    public void testResourceIsFoundAndShowsOperationsForIssue() throws IOException, SAXException {
        WebResponse response1 = this.restClient.GET(String.format(TEST_URL, ISSUE_KEY), ACCEPT_HEADER);
        Assert.assertEquals((long)200L, (long)response1.getResponseCode());
        this.assertThatResponseContainsIssueInformation(response1);
        WebResponse response2 = this.restClient.GET(String.format(TEST_URL, ISSUE_ID), ACCEPT_HEADER);
        Assert.assertEquals((long)200L, (long)response2.getResponseCode());
        this.assertThatResponseContainsIssueInformation(response2);
    }

    private void assertThatResponseContainsIssueInformation(WebResponse response) throws IOException {
        String responseText = response.getText();
        Assert.assertThat((Object)responseText, (Matcher)Matchers.containsString((String)"<id>10000</id>"));
        Assert.assertThat((Object)responseText, (Matcher)Matchers.containsString((String)"<key>HSP-1</key>"));
        Assert.assertThat((Object)responseText, (Matcher)Matchers.containsString((String)"<availableActionsAndOperationsWrapper>"));
    }

    @Test
    public void testResourceWithIssueKeyNotFoundForAnonymousUser() throws IOException, SAXException {
        this.exception.expect(FileNotFoundException.class);
        this.restClient.GET(String.format(TEST_URL, ISSUE_KEY));
    }

    @Test
    public void testResourceWithIssueIdNotFoundForAnonymousUser() throws IOException, SAXException {
        this.exception.expect(FileNotFoundException.class);
        this.restClient.GET(String.format(TEST_URL, ISSUE_ID));
    }

    @Test
    @LoginAs(user="fred")
    public void testResourceNotFoundForUserWithoutAccess() throws IOException, SAXException {
        this.getBackdoor().usersAndGroups().removeUserFromGroup("fred", "jira-users");
        this.exception.expect(FileNotFoundException.class);
        this.restClient.GET(String.format(TEST_URL, ISSUE_ID));
    }
}

