/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueLinkType;
import com.atlassian.jira.testkit.client.restclient.IssueLinkTypeClient;
import com.atlassian.jira.testkit.client.restclient.IssueLinkTypes;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@Restore(value="TestIssueLinkType.xml")
public class TestIssueLinkTypeResource
extends BaseJiraRestTest {
    private static final Long ISSUE_LINK_TYPE_ID = 10000L;
    private IssueLinkTypeClient issueLinkTypeClient;
    @Inject
    private FuncTestUrlHelper urlHelper;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    @Test
    public void setUpTest() {
        this.issueLinkTypeClient = new IssueLinkTypeClient((JIRAEnvironmentData)this.environmentData);
    }

    @Test
    public void testGetAllIssueLinkTypes() {
        IssueLinkTypes issueLinkTypes = this.issueLinkTypeClient.getIssueLinkTypes();
        List list = issueLinkTypes.issueLinkTypes;
        Assert.assertEquals((long)2L, (long)list.size());
        IssueLinkType type = (IssueLinkType)list.get(0);
        Assert.assertEquals((Object)type.name, (Object)"Blocks");
        Assert.assertEquals((Object)"Blocks", (Object)type.outward);
        Assert.assertEquals((Object)"Blocked by", (Object)type.inward);
        Assert.assertEquals((long)new Long(10100L).intValue(), (long)type.id.intValue());
        Assert.assertEquals((Object)this.urlHelper.getBaseUrlPlus("rest/api/2/issueLinkType/10100"), (Object)type.self.toString());
        type = (IssueLinkType)list.get(1);
        Assert.assertEquals((Object)type.name, (Object)"Duplicate");
        Assert.assertEquals((Object)"Duplicates", (Object)type.outward);
        Assert.assertEquals((Object)"Duplicated by", (Object)type.inward);
        Assert.assertEquals((long)new Long(10000L).intValue(), (long)type.id.intValue());
        Assert.assertEquals((Object)this.urlHelper.getBaseUrlPlus("rest/api/2/issueLinkType/10000"), (Object)type.self.toString());
    }

    @Test
    public void testGetAllIssueLinkTypesReturns404WhenIssueLinkingDisabled() {
        this.backdoor.issueLinking().disable();
        Assert.assertEquals((long)404L, (long)this.issueLinkTypeClient.getResponseForAllLinkTypes().statusCode);
    }

    @Test
    public void testGetAllIssueLinkTypesAnonymousUserBlocked() {
        int statusCode = ((IssueLinkTypeClient)this.issueLinkTypeClient.anonymous()).getResponseForAllLinkTypes().statusCode;
        Assert.assertEquals((long)401L, (long)statusCode);
    }

    @Test
    public void testGetIssueLinkTypeReturns404WhenIssueLinkingDisabled() {
        this.backdoor.issueLinking().disable();
        Assert.assertEquals((long)404L, (long)this.issueLinkTypeClient.getResponseForLinkType((String)TestIssueLinkTypeResource.ISSUE_LINK_TYPE_ID.toString()).statusCode);
    }

    @Test
    public void testCreateIssueLinkType() {
        IssueLinkType linkType = this.issueLinkTypeClient.createIssueLinkType("New Thing", "inbound", "outbound");
        MatcherAssert.assertThat((Object)linkType.name, (Matcher)CoreMatchers.is((Object)"New Thing"));
        MatcherAssert.assertThat((Object)linkType.inward, (Matcher)CoreMatchers.is((Object)"inbound"));
        MatcherAssert.assertThat((Object)linkType.outward, (Matcher)CoreMatchers.is((Object)"outbound"));
    }

    @Test
    public void testDeleteIssueLinkType() {
        IssueLinkType linkType = this.issueLinkTypeClient.createIssueLinkType("New Thing", "inbound", "outbound");
        ParsedResponse response = this.issueLinkTypeClient.deleteIssueLinkType(linkType.id.toString());
        MatcherAssert.assertThat((Object)response.statusCode, (Matcher)CoreMatchers.is((Object)204));
        try {
            this.issueLinkTypeClient.getIssueLinkType(linkType.id.toString());
            Assert.fail();
        }
        catch (WebApplicationException e) {
            MatcherAssert.assertThat((Object)e.getResponse().getStatusInfo(), (Matcher)CoreMatchers.is((Object)Response.Status.NOT_FOUND));
        }
    }

    @Test
    public void testGetIssueLinkType() {
        IssueLinkType type = this.issueLinkTypeClient.getIssueLinkType(ISSUE_LINK_TYPE_ID.toString());
        Assert.assertEquals((Object)type.name, (Object)"Duplicate");
        Assert.assertEquals((Object)"Duplicates", (Object)type.outward);
        Assert.assertEquals((Object)"Duplicated by", (Object)type.inward);
        Assert.assertEquals((Object)ISSUE_LINK_TYPE_ID, (Object)type.id);
    }

    @Test
    public void testGetIssueLinkTypeAsAnonymous() {
        ParsedResponse response = ((IssueLinkTypeClient)this.issueLinkTypeClient.anonymous()).getResponseForLinkType(ISSUE_LINK_TYPE_ID.toString());
        Assert.assertEquals((long)401L, (long)response.statusCode);
    }

    @Test
    public void testGetIssueLinkTypeIssueLinkTypeNotFound() {
        ParsedResponse response = this.issueLinkTypeClient.getResponseForLinkType("10012");
        Assert.assertEquals((long)404L, (long)response.statusCode);
        Assert.assertEquals((Object)"No issue link type with id '10012' found.", response.entity.errorMessages.get(0));
    }
}

