/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.EntityProperty;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util.PropertyAssertions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ENTITY_PROPERTIES, Category.REST})
@RestoreBlankInstance
public class TestIssuePropertyResource
extends BaseJiraRestTest {
    public static final String PROPERTY_KEY = "issue.status";
    public static final String PROPERTY_KEY2 = "issue.label";
    private EntityPropertyClient client;

    @Before
    public void before() {
        this.client = new EntityPropertyClient((JIRAEnvironmentData)this.environmentData, "issue");
    }

    @Test
    public void creatingNewIssueProperty() throws JSONException {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "First issue with properties");
        Assert.assertThat((Object)this.client.getKeys((String)issue.key).keys, (Matcher)Matchers.empty());
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"status", (Object)"done", (Object)"resolution", (Object)"won't fix"));
        this.client.put(issue.key, PROPERTY_KEY, jsonObject);
        EntityProperty issueProperty = this.client.get(issue.key, PROPERTY_KEY);
        Assert.assertThat((Object)issueProperty.key, (Matcher)Matchers.is((Object)PROPERTY_KEY));
        Assert.assertThat((Object)jsonObject, (Matcher)Matchers.is((Object)new JSONObject(issueProperty.value)));
        List keys = this.client.getKeys((String)issue.id).keys;
        Assert.assertThat((Object)keys, (Matcher)Matchers.hasItem(PropertyAssertions.propertyKey(PROPERTY_KEY)));
        PropertyAssertions.assertWebApplicationException(() -> {
            ((EntityPropertyClient)this.client.anonymous()).getKeys(issue.id);
            return null;
        }, Response.Status.UNAUTHORIZED);
        PropertyAssertions.assertWebApplicationException(() -> {
            ((EntityPropertyClient)this.client.anonymous()).get(issue.key, PROPERTY_KEY);
            return null;
        }, Response.Status.UNAUTHORIZED);
    }

    @Test
    public void deletingProperties() throws JSONException {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with properties");
        Assert.assertThat((Object)this.client.getKeys((String)issue.key).keys, (Matcher)Matchers.empty());
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"label", (Object)"todo", (Object)"color", (Object)"red"));
        this.client.put(issue.key, PROPERTY_KEY2, jsonObject);
        EntityProperty issueProperty = this.client.get(issue.key, PROPERTY_KEY2);
        Assert.assertThat((Object)issueProperty.key, (Matcher)Matchers.is((Object)PROPERTY_KEY2));
        Assert.assertThat((Object)jsonObject, (Matcher)Matchers.is((Object)new JSONObject(issueProperty.value)));
        this.client.delete(issue.key, PROPERTY_KEY2);
        Assert.assertThat((Object)this.client.getKeys((String)issue.key).keys, (Matcher)Matchers.empty());
        PropertyAssertions.assertWebApplicationException(() -> {
            this.client.get(issue.key, PROPERTY_KEY2);
            return null;
        }, Response.Status.NOT_FOUND);
    }

    @Test
    public void forbiddenForUserWithoutPermissionsToProject() {
        this.backdoor.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with properties");
        ParsedResponse response = ((EntityPropertyClient)this.client.loginAs("bob", "bob")).put(issue.id, PROPERTY_KEY, new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"status", (Object)"done")));
        Assert.assertEquals((long)response.statusCode, (long)Response.Status.FORBIDDEN.getStatusCode());
    }

    @Test
    public void testPropertiesAreRemovedWhenIssueIsRemoved() throws JSONException {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Issue with properties");
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"status", (Object)"unresolved"));
        this.client.put(issue.key, PROPERTY_KEY, jsonObject);
        EntityProperty property = this.client.get(issue.key, PROPERTY_KEY);
        Assert.assertThat((Object)new JSONObject(property.value), (Matcher)Matchers.is((Object)jsonObject));
        this.backdoor.issues().deleteIssue(issue.key, true);
        PropertyAssertions.assertWebApplicationException(() -> {
            this.client.get(issue.key, PROPERTY_KEY);
            return null;
        }, Response.Status.NOT_FOUND);
    }

    @Test
    public void testSettingPropertyWithUnicodeCharacters() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "issue with properties");
        String propertyValueWithUnicode = "this issue is \ud83d\udca9";
        JSONObject jsonObject = new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"status", (Object)propertyValueWithUnicode));
        this.client.put(issue.key, PROPERTY_KEY, jsonObject);
        EntityProperty entityProperty = this.client.get(issue.key, PROPERTY_KEY);
        Assert.assertThat(entityProperty.value.get("status"), (Matcher)Matchers.is((Object)propertyValueWithUnicode));
    }
}

