/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestRestClient;
import com.atlassian.jira.functest.framework.FuncTestUrlHelper;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueTransitionsMeta;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.collect.ImmutableSet;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.util.Collections;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestIssueResource
extends BaseJiraFuncTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Inject
    private FuncTestRestClient restClient;
    @Inject
    private Navigation navigation;
    @Inject
    private Administration administration;
    private IssueClient issueClient;
    private FuncTestUrlHelper funcTestUrlHelper;

    @Before
    public void createIssueClient() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
        this.funcTestUrlHelper = new FuncTestUrlHelper(this.environmentData);
    }

    @Test
    public void anonymousIssueDoesNotExist() throws Exception {
        this.navigation.logout();
        WebResponse response = this.restClient.GET("/rest/api/2/issue/UNKN-100");
        Assert.assertEquals((long)401L, (long)response.getResponseCode());
    }

    @Test
    public void testViewIssueNotFound() throws Exception {
        WebResponse resp123 = this.restClient.GET("rest/api/2/issue/1");
        Assert.assertEquals((long)404L, (long)resp123.getResponseCode());
        this.assertNoLongerExistsError(resp123);
        WebResponse resp123Xml = this.restClient.GET("rest/api/2/issue/1", Collections.singletonMap("Accept", "application/xml;q=0.9,*/*;q=0.8"));
        Assert.assertEquals((long)404L, (long)resp123Xml.getResponseCode());
        this.assertNoLongerExistsError(resp123Xml);
        WebResponse response = this.restClient.GET("rest/api/2/issue/1", Collections.singletonMap("Accept", "application/xml;q=0.9"));
        Assert.assertEquals((long)Response.Status.NOT_ACCEPTABLE.getStatusCode(), (long)response.getResponseCode());
    }

    @Test
    public void testNotLoggedIn_IssueExists() throws Exception {
        String key = this.navigation.issue().createIssue("monkey", "Bug", "test bug");
        this.navigation.logout();
        WebResponse response = this.restClient.GET("/rest/api/2/issue/" + key);
        Assert.assertEquals((long)401L, (long)response.getResponseCode());
    }

    @Test
    public void testCaseInsensitiveKeyLookup() throws Exception {
        String key = this.navigation.issue().createIssue("monkey", "Bug", "test bug");
        Issue realissue = this.issueClient.get(key, new Issue.Expand[0]);
        Issue issue = this.issueClient.get(key.toLowerCase(), new Issue.Expand[0]);
        Assert.assertEquals((Object)realissue.id, (Object)issue.id);
        Assert.assertEquals((Object)key, (Object)issue.key);
        issue = this.issueClient.get(key.toUpperCase(), new Issue.Expand[0]);
        Assert.assertEquals((Object)realissue.id, (Object)issue.id);
        Assert.assertEquals((Object)key, (Object)issue.key);
    }

    @Test
    public void testMovedIssueKeyLookup() throws Exception {
        String key = this.navigation.issue().createIssue("monkey", "Bug", "test bug");
        Issue origissue = this.issueClient.get(key, new Issue.Expand[0]);
        this.navigation.issue().viewIssue(key);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("homosapien");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.submit("Move");
        Issue issue = this.issueClient.get(key, new Issue.Expand[0]);
        Assert.assertEquals((Object)origissue.id, (Object)issue.id);
        Assert.assertEquals((Object)"HSP-1", (Object)issue.key);
        issue = this.issueClient.get(key.toLowerCase(), new Issue.Expand[0]);
        Assert.assertEquals((Object)origissue.id, (Object)issue.id);
        Assert.assertEquals((Object)"HSP-1", (Object)issue.key);
        issue = this.issueClient.get(key.toUpperCase(), new Issue.Expand[0]);
        Assert.assertEquals((Object)origissue.id, (Object)issue.id);
        Assert.assertEquals((Object)"HSP-1", (Object)issue.key);
    }

    @Test
    public void testUnassignedIssueHasNoValue() throws Exception {
        this.administration.generalConfiguration().setAllowUnassignedIssues(true);
        String key = this.navigation.issue().createIssue("monkey", "Bug", "test bug");
        this.navigation.issue().assignIssue(key, "my comment", "Unassigned");
        Issue issue = this.issueClient.get(key, new Issue.Expand[0]);
        Assert.assertNull((Object)issue.fields.assignee);
    }

    @Test
    @Restore(value="TestIssueResourceTransitions.xml")
    public void testIssueResourceAcceptsExpandingTransitions() throws Exception {
        Issue issue = this.issueClient.getFromURL(this.getUrl("HSP-1", "transitions"), new Issue.Expand[0]);
        Assert.assertEquals((long)3L, (long)issue.transitions.size());
        Assert.assertEquals((Object)"Resolve Issue", (Object)((IssueTransitionsMeta.Transition)issue.transitions.get((int)1)).name);
        Assert.assertNull((Object)((IssueTransitionsMeta.Transition)issue.transitions.get((int)1)).fields);
    }

    @Test
    @Restore(value="TestIssueResourceTransitions.xml")
    public void testIssueResourceAcceptsExpandingTransitionsFields() throws Exception {
        Issue issue = this.issueClient.getFromURL(this.getUrl("HSP-1", "transitions.fields"), new Issue.Expand[0]);
        Assert.assertEquals((long)3L, (long)issue.transitions.size());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"fixVersions", (Object)"customfield_10000", (Object)"assignee", (Object)"resolution"), ((IssueTransitionsMeta.Transition)issue.transitions.get((int)1)).fields.keySet());
        Assert.assertTrue((String)"There is a transition requiring 'resolution'", (boolean)((IssueTransitionsMeta.TransitionField)((IssueTransitionsMeta.Transition)issue.transitions.get((int)1)).fields.get((Object)"resolution")).required);
    }

    private String getUrl(String issueKey, String expand) {
        String path = "/rest/api/2/issue/" + issueKey;
        if (StringUtils.isNotEmpty((CharSequence)expand)) {
            path = path + "?expand=" + expand;
        }
        return this.funcTestUrlHelper.getBaseUrlPlus(path);
    }

    private void assertNoLongerExistsError(WebResponse resp123) throws JSONException, IOException {
        JSONObject content = new JSONObject(resp123.getText());
        Assert.assertEquals((long)1L, (long)content.getJSONArray("errorMessages").length());
        Assert.assertEquals((Object)"Issue Does Not Exist", (Object)content.getJSONArray("errorMessages").getString(0));
    }
}

