/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.FieldOperation;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@LoginAs(user="admin")
public class TestIssueResourceComments
extends BaseJiraFuncTest {
    private IssueClient issueClient;
    @Inject
    private Administration administration;

    @Test
    @Restore(value="TestEditComment.xml")
    public void testCommentRendering() throws Exception {
        Issue hsp1 = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Assert.assertEquals((Object)"I'm a hero!", (Object)((Comment)hsp1.fields.comment.getComments().get((int)0)).body);
        Issue expandedHsp1 = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.renderedFields});
        Assert.assertEquals((Object)"I'm a hero!", (Object)((Comment)expandedHsp1.fields.comment.getComments().get((int)0)).body);
        Assert.assertEquals((Object)"2007-02-13T17:09:12.012+1100", (Object)((Comment)expandedHsp1.fields.comment.getComments().get((int)0)).created);
        Assert.assertEquals((Object)"2007-02-13T17:09:12.012+1100", (Object)((Comment)expandedHsp1.fields.comment.getComments().get((int)0)).updated);
        Assert.assertEquals((Object)"I&#39;m a hero!", (Object)((Comment)expandedHsp1.renderedFields.comment.getComments().get((int)0)).body);
        Assert.assertEquals((Object)"13/Feb/07 5:09 PM", (Object)((Comment)expandedHsp1.renderedFields.comment.getComments().get((int)0)).created);
        Assert.assertEquals((Object)"13/Feb/07 5:09 PM", (Object)((Comment)expandedHsp1.renderedFields.comment.getComments().get((int)0)).updated);
    }

    @Test
    @Restore(value="TestEditComment.xml")
    public void testSystemTextFieldRendering() throws Exception {
        this.navigation.issue().setDescription("HSP-1", "I'll have 5<10<15 things?");
        this.navigation.issue().setEnvironment("HSP-1", "I'll have 5<10<15 things?");
        Issue hsp1 = this.issueClient.get("HSP-1", new Issue.Expand[0]);
        Assert.assertEquals((Object)"\r\nI'll have 5<10<15 things?", (Object)hsp1.fields.description);
        Assert.assertEquals((Object)"I'll have 5<10<15 things?", (Object)hsp1.fields.environment);
        Issue expandedHsp1 = this.issueClient.get("HSP-1", new Issue.Expand[]{Issue.Expand.renderedFields});
        Assert.assertEquals((Object)"\r<br/>\nI&#39;ll have 5&lt;10&lt;15 things?", (Object)expandedHsp1.renderedFields.description);
        Assert.assertEquals((Object)"I&#39;ll have 5&lt;10&lt;15 things?", (Object)expandedHsp1.renderedFields.environment);
    }

    @Test
    @RestoreBlankInstance
    public void testComment() throws Exception {
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.PROJECT_ROLES);
        this.administration.roles().addProjectRoleForUser("monkey", "Administrators", "admin");
        String key = this.navigation.issue().createIssue("monkey", "Bug", "First Test Issue");
        this.navigation.issue().addComment(key, "comment", "Administrators");
        Issue issue = this.issueClient.get(key, new Issue.Expand[0]);
        Assert.assertEquals((long)1L, (long)issue.fields.comment.getComments().size());
        this.tester.gotoPage("/rest/api/2/issue/" + key);
        Comment comment = (Comment)issue.fields.comment.getComments().get(0);
        Assert.assertEquals((Object)"comment", (Object)comment.body);
        Assert.assertEquals((Object)"role", (Object)comment.visibility.type);
        Assert.assertEquals((Object)"Administrators", (Object)comment.visibility.value);
        Assert.assertNotNull((Object)comment.created);
        Assert.assertNotNull((Object)comment.updated);
        Assert.assertEquals((Object)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/issue/10000/comment/10000"), (Object)comment.self);
        Assert.assertEquals((Object)"admin", (Object)comment.author.name);
        Assert.assertEquals((Object)"Administrator", (Object)comment.author.displayName);
        Assert.assertEquals((Object)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/user?username=admin"), (Object)comment.author.self);
        Assert.assertEquals((Object)"admin", (Object)comment.updateAuthor.name);
        Assert.assertEquals((Object)"Administrator", (Object)comment.updateAuthor.displayName);
        Assert.assertEquals((Object)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2/user?username=admin"), (Object)comment.updateAuthor.self);
    }

    @Test
    @Restore(value="TestEditComment.xml")
    public void testEditCommentBody() throws Exception {
        String issueKey = "HSP-1";
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        HashMap<String, List<FieldOperation>> operations = new HashMap<String, List<FieldOperation>>();
        String commentId = "10041";
        String commentBody = "Test";
        Comment jsonComment = new Comment();
        jsonComment.id = commentId;
        jsonComment.body = commentBody;
        this.addCommentOperation("edit", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        Comment comment = (Comment)issue.fields.comment.getComments().get(2);
        Assert.assertEquals((Object)commentId, (Object)comment.id);
        Assert.assertEquals((Object)commentBody, (Object)comment.body);
    }

    @Test
    @Restore(value="TestEditComment.xml")
    public void testEditCommentSecurityRoleLevel() throws Exception {
        String commentId;
        String issueKey = "HSP-1";
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        HashMap<String, List<FieldOperation>> operations = new HashMap<String, List<FieldOperation>>();
        Comment jsonComment = new Comment();
        jsonComment.id = commentId = "10041";
        jsonComment.visibility = new Visibility("role", "Administrators");
        this.addCommentOperation("edit", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        Comment comment = (Comment)issue.fields.comment.getComments().get(2);
        Assert.assertEquals((Object)commentId, (Object)comment.id);
        Assert.assertEquals((Object)"role", (Object)comment.visibility.type);
        Assert.assertEquals((Object)"Administrators", (Object)comment.visibility.value);
    }

    @Test
    @Restore(value="TestEditComment.xml")
    public void testEditCommentSecurityGroupLevel() throws Exception {
        String commentId;
        String issueKey = "HSP-1";
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        HashMap<String, List<FieldOperation>> operations = new HashMap<String, List<FieldOperation>>();
        Comment jsonComment = new Comment();
        jsonComment.id = commentId = "10041";
        jsonComment.visibility = new Visibility("group", "jira-administrators");
        this.addCommentOperation("edit", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        Comment comment = (Comment)issue.fields.comment.getComments().get(2);
        Assert.assertEquals((Object)commentId, (Object)comment.id);
        Assert.assertEquals((Object)"group", (Object)comment.visibility.type);
        Assert.assertEquals((Object)"jira-administrators", (Object)comment.visibility.value);
    }

    @Test
    @Restore(value="TestEditComment.xml")
    public void testEditCommentSecurityFromRoleToGroupLevel() throws Exception {
        String commentId;
        String issueKey = "HSP-1";
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        HashMap<String, List<FieldOperation>> operations = new HashMap<String, List<FieldOperation>>();
        Comment jsonComment = new Comment();
        jsonComment.id = commentId = "10041";
        jsonComment.visibility = new Visibility("role", "Administrators");
        this.addCommentOperation("edit", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        Comment comment = (Comment)issue.fields.comment.getComments().get(2);
        Visibility visibility = comment.visibility;
        Assert.assertEquals((Object)"role", (Object)visibility.type);
        Assert.assertEquals((Object)"Administrators", (Object)visibility.value);
        jsonComment = new Comment();
        jsonComment.id = commentId;
        jsonComment.visibility = new Visibility("group", "jira-administrators");
        this.addCommentOperation("edit", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        comment = (Comment)issue.fields.comment.getComments().get(2);
        visibility = comment.visibility;
        Assert.assertEquals((Object)"group", (Object)visibility.type);
        Assert.assertEquals((Object)"jira-administrators", (Object)visibility.value);
    }

    @Test
    @Restore(value="TestEditComment.xml")
    public void testEditCommentRemoveSecurityLevel() throws Exception {
        String commentId;
        String issueKey = "HSP-1";
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        HashMap<String, List<FieldOperation>> operations = new HashMap<String, List<FieldOperation>>();
        Comment jsonComment = new Comment();
        jsonComment.id = commentId = "10041";
        jsonComment.visibility = new Visibility("role", "Administrators");
        this.addCommentOperation("edit", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        Comment comment = (Comment)issue.fields.comment.getComments().get(2);
        Visibility visibility = comment.visibility;
        Assert.assertEquals((Object)"role", (Object)visibility.type);
        Assert.assertEquals((Object)"Administrators", (Object)visibility.value);
        jsonComment = new Comment();
        jsonComment.id = commentId;
        jsonComment.visibility = null;
        this.addCommentOperation("edit", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        comment = (Comment)issue.fields.comment.getComments().get(2);
        visibility = comment.visibility;
        Assert.assertNull((String)"No security level expected!", (Object)visibility);
    }

    @Test
    @Restore(value="TestEditComment.xml")
    public void testRemoveComment() throws Exception {
        String issueKey = "HSP-1";
        String commentId = "10041";
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        Assert.assertEquals((long)3L, (long)issue.fields.comment.getComments().size());
        Comment comment = (Comment)issue.fields.comment.getComments().get(2);
        Assert.assertEquals((Object)commentId, (Object)comment.id);
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        HashMap<String, List<FieldOperation>> operations = new HashMap<String, List<FieldOperation>>();
        Comment jsonComment = new Comment();
        jsonComment.id = commentId;
        this.addCommentOperation("remove", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        Assert.assertEquals((long)2L, (long)issue.fields.comment.getComments().size());
    }

    @Test
    @Restore(value="TestEditComment.xml")
    public void testAddCommentWithSecurityLevel() throws Exception {
        String issueKey = "HSP-1";
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        HashMap<String, List<FieldOperation>> operations = new HashMap<String, List<FieldOperation>>();
        Comment jsonComment = new Comment();
        jsonComment.body = "New Comment!";
        jsonComment.visibility = new Visibility("role", "Administrators");
        this.addCommentOperation("add", operations, jsonComment);
        issueUpdateRequest.update(operations);
        this.issueClient.edit(issueKey, issueUpdateRequest);
        Issue issue = this.issueClient.get(issueKey, new Issue.Expand[0]);
        Comment comment = (Comment)issue.fields.comment.getComments().get(3);
        Visibility visibility = comment.visibility;
        Assert.assertEquals((Object)"role", (Object)visibility.type);
        Assert.assertEquals((Object)"Administrators", (Object)visibility.value);
    }

    private void addCommentOperation(String operation, Map<String, List<FieldOperation>> operations, Comment comment) {
        ArrayList<FieldOperation> fieldOperations = new ArrayList<FieldOperation>();
        FieldOperation fieldOperation = new FieldOperation();
        fieldOperation.init(operation, (Object)comment);
        fieldOperations.add(fieldOperation);
        operations.put("comment", fieldOperations);
    }

    @Before
    public void setUpTest() {
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
    }
}

